/*
  some string routines
*/

#include <string.h>

#include "config.h"

int parse_list_with_flag_tab(char *file,int line,char *list,
struct flag_tab *tab,char *delimiter)
/* compare comma-list with flag_tab and returns flags bit-combination */
{
  char buff[BUFSIZE],*p; int flags=0,i,found;
  strcpy(buff,list);
  p=strtok(buff,delimiter);
  while(p)
  {
    i=0;
    found=FALSE;
    while(1)
    {
      if((tab+i)->text==NULL) break;
      if(!strcasecmp((tab+i)->text,p))
      {
/*printf("DEBUG: %s(%d): %s - ok\n",file,line,p);*/
	flags|=(tab+i)->bitmask;
	found=TRUE;
	break;
      }
      i++;
    }
    if(found==FALSE)
      e_printf("%s(%d): %s - unknown keyword, ignored",file,line,p);
    p=strtok(NULL,delimiter);
  }
  return flags;
}

char *strschr(char *str,char *what)
/*
Find any of char from "what" in "str", than find char of "str" which not exist
in "str" and returns offset. If substring not found, returns NULL.
*/
{
  char *tmp;
  do {
    tmp=what;
    do {
      if(*str==*tmp) {

        do {
	  tmp=what;
	  do {
	    if(*str==*tmp) break;
	  } while(*(++tmp));
          if(!(*tmp)) return str;
	} while (*(++str));
	return NULL;

      }
    } while(*(++tmp)) ;
  } while(*(++str)) ;
  return 0;
}

char *strschr2(char *str,char *what)
/*
Find any of char from "what" in "str" and returns offset.
If substring not found, returns NULL.
*/
{
  char *tmp;
  do {
    tmp=what;
    do {
      if(*str==*tmp) {
        return str;
      }
    } while(*(++tmp)) ;
  } while(*(++str)) ;
  return 0;
}

void delcrlf(char *s)
{
/* TODO: rewrite for mostly right method ;-) */
  char *p;
  p=strchr(s,'\r'); if(p) p[0]=0;
  p=strchr(s,'\n'); if(p) p[0]=0;
}

void strremove(char *s,char *r)
/* remove all of r from s */
{
	int remove_len;
	char *p;
	remove_len=strlen(r);
	while(1)
	{
		p=strstr(s,r);
		if(p==NULL) break;
		strcpy(p,p+remove_len);
	}
}

int cmp_paths(char *_s1,char *_s2)
/* compare two pathnames (dumb and fucked method) */
{
	int res;
	char *s1,*s2;
	s1=xstrcpy(_s1);
	s2=xstrcpy(_s2);
	strremove(s1,"//");
	strremove(s2,"//");
	res=strcmp(s1,s2);
	xfree(s1);
	xfree(s2);
	return res;
}

void str_truncate(int max,char *str)
/* used only for truncating strings which written to tic file */
{
	int len;
	if(max<3) return; /* skip some bugs, CR LF MUST be present in tic string */
	len=strlen(str);
	if(len<=max) return;
	e_printf("too long string, truncating to %d bytes (%s)",max,str);
	str[max]=0;
	str[max-1]=str[len-1];
	str[max-2]=str[len-2];
}


#ifdef TEST
main()
{
  char buff1[999],buff2[999]; char *p;
  printf("enter str: "); scanf("%s",buff1);
  printf("enter what: "); scanf("%s",buff2);
	strremove(buff1,buff2);
	printf("%s\n",buff1);
/*  p=strschr(buff1,buff2); */
/*  if(!p) printf("p=NULL\n"); */
/*  else printf("p=%s\n",p); */
}
#endif
