#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include "ifpolld.h"
#include "log.h"
#include "Txy.h"

//    0 -  ! 1 - .
txy(char *xy)
{
	char buf[CHAR_MAX];
	time_t GMTime = time( NULL );
	struct tm *Now = gmtime( &GMTime );
	int NowMin = Now->tm_hour * 60 + Now->tm_min;
	int WorkTimeStartMin, WorkTimeEndMin;

	//   .
	if( xy[0] < 'A' || xy[0] > 'X' && xy[0] < 'a' || xy[0] > 'x' )
	{
#ifdef DEBUG
		sprintf( buf, "Error Txy flag! (Txy = T%s)", xy );
		debug( buf, 3 );
#endif
		return( 0 );
	}
	if( xy[1] < 'A' || xy[1] > 'X' && xy[1] < 'a' || xy[1] > 'x' )
	{
#ifdef DEBUG
		sprintf( buf, "Error Txy flag! (Tyx = T%s)", xy );
		debug( buf, 3 );
#endif
		return( 0 );
	}

	WorkTimeStartMin = ( toupper( *xy ) - 'A' ) * 60;
	if ( islower( *xy++ ) )
		WorkTimeStartMin += 30;
	WorkTimeEndMin = ( toupper( *xy ) - 'A' ) * 60;
	if ( islower( *xy ) )
		WorkTimeEndMin += 30;
#ifdef DEBUG
	sprintf( buf, "Working time: %02d:%02d-%02d:%02d, now %02d:%02d GMT", 
		WorkTimeStartMin / 60, WorkTimeStartMin % 60,
		WorkTimeEndMin / 60, WorkTimeEndMin % 60,
		NowMin / 60, NowMin % 60 );
	debug( buf, 3 );
#endif

	if ( WorkTimeEndMin == WorkTimeStartMin )
		return( 1 );
	
	if ( WorkTimeEndMin > WorkTimeStartMin )
	{
		if ( NowMin >= WorkTimeStartMin && NowMin < WorkTimeEndMin )
			return( 1 );
		else
			return( 0 );
	}
	else
	{
		if ( NowMin >= WorkTimeStartMin || NowMin < WorkTimeEndMin )
			return( 1 );
		else
			return( 0 );
	}
}
