#ifdef ZMHFLO

#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include "ifpolld.h"
#include "log.h"
#include "Txy.h"
#include "zmh.h"

/*    0 -    f[c|h]lo! 1 -  ZMH  
 * f[c|h]lo -
 * dname -   
 * fname -   */
zmh(char *dname, char *fname)
{
	int z;
	char oldfile[PATH_MAX];
	char newfile[PATH_MAX];
	char tmp[CHAR_MAX];
  #ifdef DEBUG
	char buf[CHAR_MAX];
  #endif

	//   f[c|h]lo 
	if( tolower(fname[9]) != 'f' || tolower(fname[9]) != 'c' ||
	    tolower(fname[9]) != 'h' )
		if( tolower(fname[10]) != 'l' )
			return( 1 );	//   f[c|h]l?

	strcpy( tmp, fname );

	//   ZMH -    *.f[c|h]lo  *.f[c|h]lz
	z = txy(ZMH);
	if( z == 1 && tolower(fname[11]) == 'z' ) return( 1 );
	if( z != 1 && tolower(fname[11]) == 'o' ) return( 1 );
  #ifdef DEBUG
	sprintf( buf, "ZMH now and found \"*.%cl%c\" file!",
			tolower(fname[9]), tolower(fname[11]) );
	debug( buf, 2 );
  #endif

	if( tolower(fname[11]) == 'z' )
		tmp[11] = 'o';
	else
		tmp[11] = 'z';

  #ifdef DEBUG
	sprintf( buf, "Rename \"%s\" to \"%s\"", fname, tmp );
	debug( buf, 2 );
  #endif

	sprintf( oldfile, "%s/%s", dname, fname );
	sprintf( newfile, "%s/%s", dname, tmp );
	_rename( oldfile, newfile );

	return( 1 );
}

//       .
_rename( oldfile, newfile )
char oldfile[CHAR_MAX];
char newfile[CHAR_MAX];
{
	FILE *old, *new;

	char buf[PATH_MAX];

	if( (old = fopen( oldfile, "r") ) == NULL ) return( 1 );
	if( (new = fopen( newfile, "a") ) == NULL ) exit( -1 );

	//        
	while( fgets( buf, PATH_MAX, old ) != NULL )
		fputs( buf, new );
	fclose( old );
	fclose( new );
	remove( oldfile );	//   
	return( 0 );
}

#endif	/* ZMHFLO */
