/*			   AreaFix'			*/

/************************************************************************/
/*		:	Ilya Yanok, 2:5030/763.11		*/
/*		(   ) v.0.1.7			*/
/************************************************************************/

#include <stdio.h>
#include <string.h>
#include <fnmatch.h>
#include <ctype.h>
#include "lib.h"
#include "limits.h"
#include "log.h"
#include "readconf.h"
#include "readareas.h"
#include "readpasswd.h"
#include "readnewsfeeds.h"
#include "whatcomm.h"
#include "sendmail.h"
#include "subscribe.h"
#include "restricted.h"
#include "areafix.h"

static	int R_QUERY=-1;
static	int R_INFO=-1;
static	int R_LIST=-1;
static	int R_UNLINKED=-1;
static	int R_AVAIL=-1;
static	int R_RESCAN=-1;	// TODO!

static	int FLG=0;
static	int FLG_=0;

static	char Name[CHAR_MAX]="\0";
static	char Addr[CHAR_MAX]="\0";
static	char Pass[CHAR_MAX]="\0";

int ReadMsg(char *file)
{
	FILE *f;
	char str[CHAR_MAX];
	char File[PATH_MAX];

	snprintf( File, PATH_MAX, "%s/%s", QUEUE, file );

	if( ( f = fopen( File, "r" ) ) == NULL )
	{
		log( 0, "QueueFile \"%s\" cannot be opened!", File );
		return( -1 );
	}

	while( fgets( str, CHAR_MAX, f ) != NULL )
	{
		strtok( str, "\n" );
		if( str[0] == '%' )
		{
			if( str[1] == '+' && Rest( str ) != -1 &&
				strstr( passwd.distr, "int" ) != NULL )
			{
				SubScribeNewsGroup( str );
				FLG++;
			}
			else if( str[1] == '-' && Rest( str ) != -1 &&
				strstr( passwd.distr, "int" ) != NULL )
			{
				UnSubScribeNewsGroup( str );
				FLG++;
			}
			else
				ReadCommand( str );
		}
		else if( str[0] == '+' )
		{
			SubScribe( str );
			FLG++;
		}
		else if( str[0] == '-' )
		{
			UnSubScribe( str );
			FLG++;
		}
		else if( strncmp( str, "From: ", 6 ) == 0 )
		{
			if( Name[0] != 0 || Addr[0] != 0 )
			{
				log(0,"Message error - too many From strings");
				return( -1 );
			}
			Address( str );
		}
		else if( strncmp( str, "Subject: ", 9 ) == 0 )
		{
			if( Pass[0] != 0 )
			{
				log(0,"Message error - too many Subj strings");
				return( -1 );
			}
			if( Password( str ) == -1 )
			{
				fclose( f );
				return( -1 );
			}
			//  
			if( ReadActive() == -1 )
			{
				fclose( f );
				return( -1 );
			}
		}
	}

	fclose( f );

	//  -      ...
	if( !R_QUERY ) SendQueryMail();
	if( !R_INFO ) SendInfoMail();
	if( !R_UNLINKED ) SendUnlinkedMail();
	if( !R_LIST ) SendListMail();
	if( !R_AVAIL ) SendAvailList();
//	if( !R_RESCAN ) Rescan();

	//        
	// / -   
	if( FLG != 0 || FLG_ != 0 )
	{
		if( FLG != 0 )
		//     
			SendSubScribeMail();
		//   NewsFeeds
		WriteNewsFeeds( passwd.site );
		//  NewsFeeds    inn'
		log( 5, "Exec: \"%s\"", conf.ReloadCommand );
		system( conf.ReloadCommand );
	}

	return( 0 );
}

/*    ,    '<' '>'	*/
int Address(char *str)
{
	char tmp[CHAR_MAX];
	char *name, *addr, *newaddr;

	newaddr = str;

	log( 5, "Found string: \"%s\"", newaddr );

	newaddr += strcspn( str, " \t" );
	newaddr += strspn( newaddr, " \t" );

	//     '<'  '>'
	/*    :
	   'Maxim.Timofeyev@p1.f763.n5030.z2.fidonet.org',   
	   '<'  '>'  ,      .  */
	if( !strchr( str, '<' ) && !strchr( str, '>' ) )
	{
		log( 5, "string don't have '<' and '>' char" );
		tmp[0] = '<';
		strncat( tmp, newaddr, sizeof(tmp)-1 );
		strncat( tmp, ">", sizeof(tmp)-1 );
		log( 5, "New string: \"%s\"", tmp );
	}
	else
		strcpy( tmp, newaddr );

	// <Maxim.Timofeyev@p1.f763.n5030.z2.fidonet.rog>
	name = strchr( tmp, '<' ) + 1;
	strcpy( Name, name );
	strtok( Name, "@" );
	addr = strchr( tmp, '@' ) + 1;

	log( 5, "Name: \"%s\"", Name );

	strtok( addr, ">" );

	log( 5, "Address: \"%s\"", addr );

	strcpy( Addr, addr );

	log( 1, "Message From: \"%s\", Address: \"%s\"", Name, ToFtn( Addr ) );

	return( 0 );
}

int Password(char *str)
{
	char tmp[CHAR_MAX];
	char *t, *tt, c;

#ifndef	SECURELOG
	log( 5, "Read message, string: \"%s\"", str );
#else
	log( 5, "Read password string..." );
#endif

	sscanf( str, "Subject: %[A-Za-z0-9!@#$%&*,.-+=_\() ]", tmp );

	t = tmp;
	if( strtok( tmp, " " ) != NULL )
	{
		t += strlen( tmp ) + 1;
		strlwr( t );
		log( 4, "Found \"%s\" flags in password string.", t );
		for( ; tt = strtok( t, " -" ); t = 0 )
		{
			log( 5, "Read \"%s\" flag.", tt );
			c = tt[0];
			log( 4, "Found '-%c' flag.", c );
			switch( c )
			{
				case 'q': R_QUERY=0;	break;
				case 'i': R_INFO=0;	break;
				case 'l': R_LIST=0;	break;
				case 'u': R_UNLINKED=0;	break;
				case 'a': R_AVAIL=0;	break;
				case 'r': R_RESCAN=0;	break;
			}
		}
	}

#ifdef	PASSLWR
	strlwr( tmp );
#endif

	strcpy( Pass, tmp );

#ifndef	SECURELOG
	log( 1, "Password: \"%s\"", Pass );
#endif

	/*		    			*/
	if( ReadPasswdFile( Name, Addr, Pass ) == -1 )
	{
		SendErrorPassword( Name, Addr, Pass );
		return( -1 );
	}

	return( 0 );
}

int ReadCommand(char *str)
{
	int c;

	strlwr( str );
	c = WhatComm( str );
	if( c == -1 )
	{
		log( 2, "Bad mailing command \"%s\"", str );
		strcpy( s.EchoNews[s.n], str );
		s.already[s.n]=3;
		s.SEchoNews[s.n++]=0;
		FLG++;
		return( -1 );
	}
	switch( c )
	{
		case 0:	// %Help
			SendHelpMail();
			break;
		case 1:	// %NewsList
			SendNewsListMail();
			break;
		case 2:	// %Query
			if( R_QUERY ) SendQueryMail();
			break;
		case 3:	// %Unlinked
			if( R_UNLINKED ) SendUnlinkedMail();
			break;
		case 4:	// %Passive
			if( site.passive == 1 )
				SendAlreadyPassiveActive( 0 );	// passive
			else
			{
				FLG_++;
				SendPassiveActiveStatus( 0 );	// passive
			}
			site.passive = 1;
			break;
		case 5:	// %Active
			if( site.passive == 0 )
				SendAlreadyPassiveActive( 1 );	// active
			else
			{
				FLG_++;
				SendPassiveActiveStatus( 1 );	// active
			}
			site.passive = 0;
			break;
		case 6:	// %List
			if( R_LIST ) SendListMail();
			break;
		case 7:	// %Avail
			if( R_AVAIL ) SendAvailList();
			break;
		case 8: // %Pause
			if( site.passive == 1 )
				SendAlreadyPassiveActive( 0 );	// passive
			else
			{
				FLG_++;
				SendPassiveActiveStatus( 0 );	// passive
			}
			site.passive = 1;
			break;	
		case 9: // %Resume
			if( site.passive == 0 )
				SendAlreadyPassiveActive( 1 );	// active
			else
			{
				FLG_++;
				SendPassiveActiveStatus( 1 );	// active
			}
			site.passive = 0;
			break;
		case 10: // %Info
			if( R_INFO ) SendInfoMail();
			break;
	}
}

int SubScribe(char *str)
{
	int i=-1;
	int modified=-1;
	char buf[CHAR_MAX];

	strtok( str, " " );
	//     
	strlwr( str );

	if( str[1] == '*' && conf.SubScribeAll != 1 )
		goto Exit;

	while( ++i != areas.n )
	{
		snprintf( buf, CHAR_MAX, "+%s", areas.echo[i] );
		strlwr( buf );
		if( !strstr( passwd.distr,areas.distr[i]) ||
			fnmatch(str,buf,0) || Rest(buf) )
			continue;
		modified=0;
		if( areas.s[i] )
		{
			strcpy( s.EchoNews[s.n], buf );
			s.already[s.n]=1;
			s.SEchoNews[s.n++]=1;
			//   !
			log( 5, "Already SubScribed to \"%s\"", areas.echo[i] );

			continue;
		}
		strcpy( s.EchoNews[s.n], buf );
		s.already[s.n]=0;
		s.SEchoNews[s.n++]=1;
		areas.s[i]=1;
		// 
		log( 5, "SubScribed to \"%s\"", areas.echo[i] );
	}
Exit:
	if (modified)
	{
		strcpy( s.EchoNews[s.n], str );
		s.already[s.n]=2;
		s.SEchoNews[s.n++]=1;
		log( 5, "Site cannot SubScribe to \"%s\" - no such echo", str );	
	}
	return( modified );
}

int UnSubScribe(char *str)
{
	int i=-1;
	int modified=-1;
	char buf[CHAR_MAX];

	strtok( str, " " );
	//     
	strlwr( str );

	while( ++i != areas.n )
	{
		snprintf( buf, CHAR_MAX, "-%s", areas.echo[i] );
		strlwr( buf );
		if( !strstr(passwd.distr,areas.distr[i]) ||
				fnmatch(str,buf,0) || Rest(buf) )
			continue;
		modified=0;
		if( !areas.s[i] )
		{
			strcpy( s.EchoNews[s.n], buf );
			s.already[s.n]=1;
			s.SEchoNews[s.n++]=1;
			//   ,   ?
			log( 5,"Is not SubScribed to \"%s\"",areas.echo[i] );

			continue;
		}
		strcpy( s.EchoNews[s.n], buf );
		s.already[s.n]=0;
		s.SEchoNews[s.n++]=1;
		areas.s[i]=0;
		//  
		log( 5, "UnSubScribed from \"%s\"", areas.echo[i] );
		FLG++;
		continue;
	}

	if(modified)
	{
		strcpy( s.EchoNews[s.n], str );
		s.already[s.n]=2;
		s.SEchoNews[s.n++]=1;
		log( 5, "Site cannot SubScribe to \"%s\" - no such echo", str );
	}
	return( modified );
}

int SubScribeNewsGroup(char *str)
{
	int i=-1;
	int modified=-1;
	char buf[CHAR_MAX];

	strtok( str, " " );
	//     
	strlwr( str );

	if( str[2] == '*' && conf.SubScribeAll != 1 )
		goto Exit;

	while( ++i != areas.n )
	{
		snprintf( buf, CHAR_MAX, "%%+%s", areas.ng[i] );
		strlwr( buf );
		if( !fnmatch( str, buf, 0 ) )
			continue;
		modified=0;
		if( areas.s[i] )
		{
			strcpy( s.EchoNews[s.n], buf );
			s.already[s.n]=1;
			s.SEchoNews[s.n++]=0;
			//   !
			log( 5, "Already SubScribed to \"%s\"", areas.ng[i] );

			FLG++;
			continue;
		}
		strcpy( s.EchoNews[s.n], buf );
		s.already[s.n]=0;
		s.SEchoNews[s.n++]=0;
		areas.s[i]=1;
		// 
		log( 5, "SubScribed to \"%s\"", areas.ng[i] );

		FLG++;
		continue;
	}
Exit:
	if (modified)
	{
		strcpy( s.EchoNews[s.n], str );
		s.already[s.n]=2;
		s.SEchoNews[s.n++]=0;
		log( 5, "Site cannot SubScribed to \"%s\" - no such echo", str );
	}
	return( modified );
}

int UnSubScribeNewsGroup(char *str)
{
	int i=-1;
	int modified=-1;
	char buf[CHAR_MAX];

	strtok( str, " " );
	//     
	strlwr( str );

	while( ++i != areas.n )
	{
		snprintf( buf, CHAR_MAX, "%%-%s", areas.ng[i] );
		strlwr( buf );
		if( !fnmatch( str, buf, 0 ) )
			continue;
		modified=0;
		if( !areas.s[i] )
		{
			strcpy( s.EchoNews[s.n], buf );
			s.already[s.n]=1;
			s.SEchoNews[s.n++]=0;
			//  !   ?
			log( 5, "Is not SubScribed to \"%s\"", areas.ng[i] );

			FLG++;
			continue;
		}
		strcpy( s.EchoNews[s.n], buf );
		s.already[s.n]=0;
		s.SEchoNews[s.n++]=0;
		areas.s[i] = 0;
		//  !
		log( 5, "UnSubScribed from \"%s\"", areas.ng[i] );

		FLG++;
		continue;
	}

	if(modified)
	{
		strcpy( s.EchoNews[s.n], str );
		s.already[s.n]=2;
		s.SEchoNews[s.n++]=0;
		log( 5, "Site cannot SubScribed to \"%s\" - no such echo", str );
	}
	return( modified );
}

int Rest(char *str)
{
	strtok( str, " " );
	if( Restricted( str ) == -1 )
	{
		strcpy( s.EchoNews[s.n], str );
		s.already[s.n]=4;
		s.SEchoNews[s.n++]=1;
		log(5, "Site cannot SubScribed to \"%s\" - see RestEcho", str);
		return( -1 );
	}
	return( 0 );
}
