/* FreeTDS - Library of routines accessing Sybase and Microsoft databases
 * Copyright (C) 1998-1999  Brian Bruns
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _tds_h_
#define _tds_h_

static char rcsid_tds_h[]=
	 "$Id: tds.h,v 1.29 1999/08/22 02:19:31 camber Exp $";
static void *no_unused_tds_h_warn[]={rcsid_tds_h, no_unused_tds_h_warn};

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/signal.h>
#include <sys/wait.h>

#include "tdsver.h"


#ifdef __cplusplus
extern "C" {
#endif 

/* 
** this is where platform specific changes need to be made.
** I've tried to change all references to data that goes to 
** or comes off the wire to use these typedefs.  I've probably 
** missed a bunch, but the idea is we can do an ifdef here 
** to set the appropriately sized native type.
**
** If you have problems on 64bit machines and the code is 
** using a native datatype, please change the code to use
** these. (In the TDS layer only, the API layers have their
** own typedefs which equate to these).
*/
typedef char		TDS_CHAR;      /*  8 bit char     */
typedef unsigned char	TDS_UCHAR;     /*  8 bit uchar    */
typedef unsigned char	TDS_TINYINT;   /*  8 bit int      */
typedef short		TDS_SMALLINT;  /* 16 bit int      */
typedef unsigned short	TDS_USMALLINT; /* 16 bit unsigned */
typedef long		TDS_INT;       /* 32 bit int      */
typedef unsigned long	TDS_UINT;      /* 32 bit unsigned */
typedef float		TDS_REAL;      /* 32 bit float    */
typedef double		TDS_FLOAT;     /* 64 bit float    */
typedef struct tdsnumeric
{
        unsigned char         precision;
        unsigned char         scale;
        unsigned char         array[33];
} TDS_NUMERIC;
typedef struct tdsmoney
{
        TDS_INT         mnyhigh;
        TDS_INT         mnylow;
} TDS_MONEY;
typedef struct tdsmoney4
{
        TDS_INT          mny4;
} TDS_MONEY4;
typedef struct tdsdatetime
{
	TDS_INT dtdays;
	TDS_INT dttime;
} TDS_DATETIME;
typedef struct tdsdatetime4
{
	TDS_USMALLINT days;
	TDS_USMALLINT minutes;
} TDS_DATETIME4;

#define TDS_NO_MORE_ROWS     -2
#define TDS_SUCCEED          1
#define TDS_FAIL             0
#define TDS_NO_MORE_RESULTS  2
#define TDS_DONT_RETURN      42

#define TDS_CLOSE_TOKEN     113  /* 0x71    TDS 5.0 only? ct_close()  */
#define TDS_RET_STAT_TOKEN  121  /* 0x79                              */
#define TDS_124_TOKEN       124  /* 0x7C    TDS 4.2 only - TDS_PROCID */
#define TDS_COL_NAME_TOKEN  160  /* 0xA0    TDS 4.2 only              */
#define TDS_COL_INFO_TOKEN  161  /* 0xA1    TDS 4.2 only - TDS_COLFMT */
/*#define  TDS_TABNAME   164 */
/*#define  TDS_COL_INFO   165 */
#define TDS_167_TOKEN       167  /* 0xA7                              */
#define TDS_168_TOKEN       168  /* 0xA8                              */
#define TDS_ORDER_BY_TOKEN  169  /* 0xA9    TDS_ORDER                 */
#define TDS_ERR_TOKEN       170  /* 0xAA                              */
#define TDS_MSG_TOKEN       171  /* 0xAB                              */
/*#define  TDS_RETURNVALUE   172 */
#define TDS_LOGIN_ACK_TOKEN 173  /* 0xAD                              */
#define TDS_174_TOKEN       174  /* 0xAE    TDS_CONTROL               */
#define TDS_ROW_TOKEN       209  /* 0xD1                              */
#define TDS_CMP_ROW_TOKEN   211  /* 0xD3                              */
#define TDS_CAP_TOKEN       226  /* 0xE2                              */
#define TDS_ENV_CHG_TOKEN   227  /* 0xE3                              */
#define TDS_EED_TOKEN       229  /* 0xE5                              */
#define TDS_RESULT_TOKEN    238  /* 0xEE                              */
#define TDS_END_TOKEN       253  /* 0xFD    TDS_DONE                  */
#define TDS_END2_TOKEN      254  /* 0xFE    TDS_DONEPROC              */
#define TDS_END3_TOKEN      255  /* 0xFF    TDS_DONEINPROC            */

#define TDS_DONEPROC        TDS_END2_TOKEN
#define TDS_DONEINPROC      TDS_END3_TOKEN


/* states for tds_process_messages() */
#define PROCESS_ROWS    0
#define PROCESS_RESULTS 1
#define CANCEL          2
#define GOTO_1ST_ROW    3
#define LOGIN           4

/* 
<rant> Sybase does an awful job of this stuff, non null ints of size 1 2 
and 4 have there own codes but nullable ints are lumped into INTN
sheesh! </rant>
*/
#define SYBCHAR      47   /* 0x2F */
#define SYBVARCHAR   39   /* 0x27 */
#define SYBINTN      38   /* 0x26 */
#define SYBINT1      48   /* 0x30 */
#define SYBINT2      52   /* 0x34 */
#define SYBINT4      56   /* 0x38 */
#define SYBFLT8      62   /* 0x3E */
#define SYBDATETIME  61   /* 0x3D */
#define SYBBIT       50   /* 0x32 */
#define SYBTEXT      35   /* 0x23 */
#define SYBIMAGE     34   /* 0x22 */
#define SYBMONEY4    122  /* 0x7A */
#define SYBMONEY     60   /* 0x3C */
#define SYBDATETIME4 58   /* 0x3A */
#define SYBREAL      59   /* 0x3B */
#define SYBBINARY    45   /* 0x2D */
#define SYBVOID      31   /* 0x1F */
#define SYBVARBINARY 37   /* 0x25 */
#define SYBNUMERIC   108  /* 0x6C */
#define SYBDECIMAL   106  /* 0x6A */
#define SYBFLTN      109  /* 0x6D */
#define SYBMONEYN    110  /* 0x6E */
#define SYBDATETIMN  111  /* 0x6F */


#define is_end_token(x) (x==TDS_END_TOKEN    || \
			x==TDS_END2_TOKEN    || \
			x==TDS_END3_TOKEN)

/* FIX ME -- not a complete list */
#define is_fixed_type(x) (x==SYBINT1    || \
			x==SYBINT2      || \
			x==SYBINT4      || \
			x==SYBREAL	|| \
			x==SYBFLT8      || \
			x==SYBDATETIME  || \
			x==SYBDATETIME4 || \
			x==SYBBIT       || \
			x==SYBMONEY     || \
			x==SYBMONEY4)
#define is_nullable_type(x) (x==SYBINTN || \
			x==SYBFLTN      || \
			x==SYBDATETIMN  || \
			x==SYBVARCHAR   || \
			x==SYBVARBINARY	|| \
			x==SYBMONEYN)

#define TDS_MAX_CAPABILITY	18
#define MAXPRECISION 		50


typedef struct tds_login {
	TDS_CHAR  host_name[30];
	TDS_CHAR  user_name[30];
	TDS_CHAR  password[30];
	TDS_TINYINT bulk_copy; 
	TDS_CHAR  app_name[30];
	TDS_CHAR  server_name[30];
	TDS_TINYINT  major_version; /* TDS version */
	TDS_TINYINT  minor_version; /* TDS version */
	TDS_CHAR  library[11]; /* Ct-Library or DB-Library */
	TDS_CHAR language[30]; /* ie us-english */
	TDS_TINYINT encrypted; 
	TDS_CHAR char_set[30]; /*  ie iso_1 */
	TDS_SMALLINT block_size; 
	TDS_TINYINT suppress_language;
	unsigned char capabilities[TDS_MAX_CAPABILITY];
	int port;
} TDSLOGIN;

typedef struct tds_column_info {
	TDS_SMALLINT column_type;
	TDS_SMALLINT column_usertype;
	TDS_INT column_size;
	TDS_INT column_offset;
	TDS_CHAR column_name[256];
	TDS_SMALLINT column_bindtype;
	TDS_SMALLINT column_bindlen;
	TDS_CHAR *column_nullbind;
	TDS_CHAR *varaddr;
	TDS_CHAR *column_lenbind;
	TDS_SMALLINT column_prec;
	TDS_SMALLINT column_scale;
} TDSCOLINFO;

typedef struct tds_result_info {
	TDS_SMALLINT  rows_exist;
	TDS_INT       row_count;
	TDS_INT       row_size;
	TDS_SMALLINT  num_cols;
	TDS_TINYINT   more_results;
	TDSCOLINFO    **columns;
	int           null_info_size;
	unsigned char *current_row;
	TDS_TINYINT   state;
	TDS_TINYINT   has_status;
	TDS_INT       ret_status;
} TDSRESULTINFO;

/* values for res_info->state */
enum {
	TDS_QUERYING,
	TDS_PENDING,
	TDS_COMPLETED,
	TDS_CANCELED,
};

typedef struct tds_compute_info {
        TDS_SMALLINT num_cols;
	TDS_INT row_size;
        TDSCOLINFO **columns;
	unsigned char *current_row;
} TDSCOMPUTEINFO;

typedef struct tds_msg_info {
      TDS_SMALLINT priv_msg_type;
      TDS_SMALLINT line_number;
      TDS_SMALLINT msg_number;
      TDS_SMALLINT msg_state;
      TDS_SMALLINT msg_level;
      TDS_CHAR *server;
      TDS_CHAR *message;
      TDS_CHAR *proc_name;
      TDS_CHAR *sql_state;
} TDSMSGINFO;


typedef struct tds_socket {
        int s;
	unsigned char *in_buf;
	unsigned char *out_buf;
	unsigned int in_buf_max;
	unsigned in_pos;
	unsigned out_pos;
	unsigned in_len;
	unsigned out_len;
	unsigned char out_flag;
	unsigned char last_packet;
	void *parent;
	TDSRESULTINFO *res_info;
        TDSCOMPUTEINFO *comp_info;
	TDSMSGINFO *msg_info;
	TDS_SMALLINT major_version;
	TDS_SMALLINT minor_version;
	unsigned char capabilities[TDS_MAX_CAPABILITY];
} TDSSOCKET;

extern int tds_write_packet(TDSSOCKET *tds,unsigned char final);
extern int tds_init_write_buf(TDSSOCKET *tds);
extern void tds_free_result_info(TDSRESULTINFO *info);
extern void tds_free_socket(TDSSOCKET *tds);
extern void tds_free_results(TDSRESULTINFO *res_info);
extern void tds_free_msg(TDSMSGINFO *msg_info);
extern int tds_put_n(TDSSOCKET *tds, unsigned char *buf, int n);
extern int tds_put_string(TDSSOCKET *tds, unsigned char *buf, int n);
extern int tds_put_int(TDSSOCKET *tds, TDS_INT i);
extern int tds_put_smallint(TDSSOCKET *tds, TDS_SMALLINT si);
extern int tds_put_tinyint(TDSSOCKET *tds, TDS_TINYINT ti);
extern int tds_put_byte(TDSSOCKET *tds, unsigned char c);
extern unsigned char tds_get_byte(TDSSOCKET *tds);
extern void tds_unget_byte(TDSSOCKET *tds);
extern TDS_SMALLINT tds_get_smallint(TDSSOCKET *tds);
extern char *tds_get_n(TDSSOCKET *tds, void *dest, int n);
extern TDSRESULTINFO *tds_alloc_results(int num_cols);
extern TDSCOMPUTEINFO *tds_alloc_compute_results(int num_cols);
extern TDSSOCKET *tds_alloc_socket(int bufsize);
extern void *tds_alloc_row(TDSRESULTINFO *res_info);
extern char *tds_msg_get_proc_name(TDSSOCKET *tds);
extern TDSLOGIN *tds_alloc_login();
extern TDSSOCKET *tds_connect(TDSLOGIN *login);
extern void tds_set_packet(TDSLOGIN *tds_login, short packet_size);
extern void tds_set_port(TDSLOGIN *tds_login, int port);
extern void tds_set_passwd(TDSLOGIN *tds_login, char *password);
extern void tds_set_user(TDSLOGIN *tds_login, char *username);
extern void tds_set_app(TDSLOGIN *tds_login, char *application);
extern void tds_set_host(TDSLOGIN *tds_login, char *hostname);
extern void tds_set_library(TDSLOGIN *tds_login, char *library);
extern void tds_set_server(TDSLOGIN *tds_login, char *server);
extern void tds_set_charset(TDSLOGIN *tds_login, char *charset);
extern void tds_set_language(TDSLOGIN *tds_login, char *language);
extern void tds_set_version(TDSLOGIN *tds_login, short major_ver, short minor_ver);
extern void tds_set_capabilities(TDSLOGIN *tds_login, unsigned char *capabilities, int size);
extern int tds_submit_query(TDSSOCKET *tds, char *query);
extern int tds_process_result_tokens(TDSSOCKET *tds);
extern int tds_process_row_tokens(TDSSOCKET *tds);
extern int tds_process_default_tokens(TDSSOCKET *tds, int marker);
extern void tds_process_end(TDSSOCKET *tds, int marker, int *more, int *canceled);
extern int tds_reset_msg_info(TDSSOCKET *tds);
extern void  tds_set_parent(TDSSOCKET* tds, void* the_parent);
extern void* tds_get_parent(TDSSOCKET* tds);
void tds_set_null(unsigned char *current_row, int column);
void tds_clr_null(unsigned char *current_row, int column);
int tds_get_null(unsigned char *current_row, int column);

#define IS_TDS42(x) (x->major_version==4 && x->minor_version==2)
#define IS_TDS46(x) (x->major_version==4 && x->minor_version==6)
#define IS_TDS50(x) (x->major_version==5 && x->minor_version==0)


#ifdef __cplusplus
}
#endif 

#endif /* _tds_h_ */
