/* FreeTDS - Library of routines accessing Sybase and Microsoft databases
 * Copyright (C) 1998-1999  Brian Bruns
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include "sybfront.h"
#include "sybdb.h"

static char  software_version[]   = "$Id: dbtest.c,v 1.6 1999/07/28 23:59:57 camber Exp $";
static void *no_unused_var_warn[] = {software_version,
                                     no_unused_var_warn};


static int syb_msg_handler( dbproc, msgno, msgstate, severity, msgtext,
                            srvname, procname, line )
      DBPROCESS   *dbproc ;
      DBINT        msgno ;
      int          msgstate ;
      int          severity ;
      char        *msgtext ;
      char        *srvname ;
      char        *procname ;
      int          line ;
{
      char   *thresh_display ;
      char   *thresh_fail ;
      char    var_value[31] ;
      int     i ;
      char   *c ;

      /*
       * Check for "database changed", or "language changed" messages from
       * the client.  If we get one of these, then we need to pull the
       * name of the database or charset from the message and set the
       * appropriate variable.
       */
      if( msgno == 5701 ||    /* database context change */
               msgno == 5703 ||    /* language changed */
               msgno == 5704 ) {   /* charset changed */

              /* fprintf( stderr, "msgno = %d: %s\n", msgno, msgtext ) ; */

              if( msgtext != NULL && (c = strchr( msgtext, '\'' )) != NULL ) {
		      i = 0 ;
                      for( ++c; i <= 30 && *c != '\0' && *c != '\''; ++c )
                              var_value[i++] = *c ;
                      var_value[i] = '\0' ;

#if 0
                      switch(msgno) {
                              case 5701 :
                                      env_set( g_env, "database", var_value )
;
                                      break ;
                              case 5703 :
                                      env_set( g_env, "language", var_value )
;
                                      break ;
                              case 5704 :
                                      env_set( g_env, "charset", var_value ) ;-                                       break ;
                              default :
                                      break ;
                      }
#endif
              }
              return 0 ;
      }

      /*
       * If the severity is something other than 0 or the msg number is
       * 0 (user informational messages).
       */
      if( severity >= 0 || msgno == 0 ) {
              /*
               * If the message was something other than informational, and
               * the severity was greater than 0, then print information to
               * stderr with a little pre-amble information.
               */
              if( msgno > 0 && severity > 0 ) {
                      fprintf( stderr, "Msg %d, Level %d, State %d\n",
                                              (int)msgno, (int)severity, (int)msgstate ) ;
                      fprintf( stderr, "Server '%s'", srvname ) ;
                      if( procname != NULL && *procname != '\0' )
                              fprintf( stderr, ", Procedure '%s'", procname )
;
                      if( line > 0 )
                              fprintf( stderr, ", Line %d", line ) ;
                      fprintf( stderr, "\n" ) ;
                      fprintf( stderr,"%s\n", msgtext ) ;
                      fflush( stderr ) ;
              } else {
                      /*
                       * Otherwise, it is just an informational (e.g. print) message
                       * from the server, so send it to stdout.
                       */
                      fprintf( stdout, "%s\n", msgtext ) ;
                      fflush( stdout ) ;
              }
      }

      return 0 ;
}

static int syb_err_handler( dbproc, severity, dberr, oserr, dberrstr, oserrstr )
      DBPROCESS    *dbproc ;
      int           severity ;
      int           dberr ;
      int           oserr ;
      char         *dberrstr ;
      char         *oserrstr ;
{

#if 0
      /*
       * For fatal server messages, cancel the query and rely on the
       * message handler to spew the appropriate error messages out.
       */
      if (severity == EXSERVER )
              return INT_CANCEL ;

      /*
       * For any other type of severity (that is not a server
       * message), we increment the batch_failcount.
       */
      env_set( g_env, "batch_failcount", "1" ) ;
#endif

      fprintf( stderr, "DB-LIBRARY error (severity %d):\n", severity ) ;
      fprintf( stderr, "   %s\n", dberrstr ) ;
      fflush( stderr ) ;

      /*
       * If the dbprocess is dead or the dbproc is a NULL pointer and
       * we are not in the middle of logging in, then we need to exit.
       * We can't do anything from here on out anyway.
       */
      if( (dbproc == NULL || DBDEAD(dbproc)) )
              exit(255) ;

      return INT_CANCEL ;
}

int main()
{
LOGINREC *login;
DBPROCESS *dbproc;
char ip_addr[40],ip_port[10];
int i, numCols;
char *teststr[8];
DBINT testint;
DBFLT8 flt;
int firstTimeForHeader = 1;

/* Fortify_EnterScope(); */
 dbinit();

 dberrhandle( syb_err_handler );
 dbmsghandle( syb_msg_handler );

 dbinit();
 login = dblogin();
 DBSETLPWD(login,"sybase");
 DBSETLUSER(login,"guest");
 DBSETLAPP(login,"sqsh");
 DBSETLHOST(login,"ntbox.dntis.ro");

 dbproc = dbopen(login, "JDBC");

 /* dbcmd(dbproc,"select * from publishers where pub_id = '6666'\n"); */
 /* dbcmd(dbproc,"sp_help teams\n"); */
 /* dbcmd(dbproc,"select t.total_sales from titles t, authors a, publishers p, teams tt, authors a2\n"); */
 /* dbcmd(dbproc,"select name from sysobjects\n"); */
 /* dbcmd(dbproc,"select count(*) from authors\n"); */
 dbcmd(dbproc,"select size from floater"); 
 dbsqlexec(dbproc);
 while (dbresults(dbproc)!=NO_MORE_RESULTS) {
 	for (i=1;i<=dbnumcols(dbproc);i++)
 	{
    	printf ("col %d is %s\n",i,dbcolname(dbproc,i));
 	}
 	/* dbbind(dbproc,1,INTBIND,-1,(BYTE *) &testint); */
        /* dbbind(dbproc,1,STRINGBIND,-1,(BYTE *) teststr); */
        dbbind(dbproc,1,FLT8BIND,-1,(BYTE *) &flt); 
 	while (dbnextrow(dbproc)!=NO_MORE_ROWS)
           /* printf("%d\n",testint);  */
	   printf("%6.3g\n",flt);  
	   /* printf("%s\n",teststr); */
 }
 dbexit();
 return 0; /* keep lint happy */
}
