/* FreeTDS - Library of routines accessing Sybase and Microsoft databases
 * Copyright (C) 1998-1999  Brian Bruns
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "tdsutil.h"
#include "tds.h"
#include "tdsconvert.h"
#include <stdlib.h>
#include <unistd.h>
#include <time.h>


static char  software_version[]   = "$Id: convert.c,v 1.12 1999/08/11 01:53:59 camber Exp $";
static void *no_unused_var_warn[] = {software_version,
                                     no_unused_var_warn};
typedef union dbany {
        TDS_TINYINT	ti;
        TDS_SMALLINT	si;
        TDS_INT		i;
	TDS_FLOAT		f;
	TDS_REAL		r;
	TDS_CHAR		*c;
	TDS_MONEY         m;
	TDS_MONEY4	m4;
	TDS_DATETIME	dt;
	TDS_DATETIME4	dt4;
/*
	TDS_DECIMAL	d;
	TDS_NUMERIC	n;
*/
} DBANY; 

TDS_INT tds_convert_any(unsigned char *dest, TDS_INT dtype, TDS_INT dlen, DBANY *any);
static int _string_to_tm(char *datestr, struct tm *t);


/* 
this needs to go... 
it won't handle binary or text/image when they are added
it's not thread safe
it works for the moment though til i decide how i really want to handle it
*/
static TDS_CHAR tmp_str[1024];  


int tds_get_conversion_type(int srctype, int colsize)
{
	if (srctype == SYBINTN) {
		if (colsize==4)
			 return SYBINT4;
		else if (colsize==2)
			 return SYBINT2;
		else if (colsize==1)
			 return SYBINT1;
	} else if (srctype == SYBFLTN) {
		if (colsize==8)
			return SYBFLT8;
		else if (colsize==4)
			return SYBREAL;
	}
	return srctype;
}
TDS_INT tds_convert_char(int srctype,unsigned char *src,
	int desttype,unsigned char *dest,TDS_INT destlen)
{
DBANY any;
struct tm t;
time_t secs_from_epoch;
   
   switch(desttype) {
      case SYBCHAR:
      case SYBVARCHAR:
         any.c = src;
         break;
      case SYBTEXT:
         break;
      case SYBBINARY:
      case SYBIMAGE:
         break;
      case SYBINT1:
         any.ti = atoi(src);
         break;
      case SYBINT2:
         any.si = atoi(src);
         break;
      case SYBINT4:
         any.i = atol(src);
         break;
      case SYBFLT8:
         any.f = atof(src);
         break;
      case SYBREAL:
         any.r = atof(src);
         break;
      case SYBBIT:
         any.ti = (atoi(src)>0) ? 1 : 0;
         break;
      case SYBMONEY:
         break;
      case SYBMONEY4:
         break;
      case SYBDATETIME:
	 _string_to_tm(src, &t);
	 secs_from_epoch = mktime(&t);
	 any.dt.dtdays = (secs_from_epoch/60/60/24)+25567;
	 any.dt.dttime = (secs_from_epoch%60%60%24)*300;
         break;
      case SYBDATETIME4:
	 _string_to_tm(src, &t);
	 secs_from_epoch = mktime(&t);
	 any.dt4.days = (secs_from_epoch/60/60/24)+25567;
	 any.dt4.minutes = (secs_from_epoch%60%60%24)/60;
         break;
      case SYBNUMERIC:
      case SYBDECIMAL:
         break;
/*
		case SYBBOUNDRY:
			break;
		case SYBSENSITIVITY:
			break;
*/
      default:
         return TDS_FAIL;
   }
   return tds_convert_any(dest, desttype, destlen, &any);
}
TDS_INT tds_convert_bit(int srctype,unsigned char *src,
	int desttype,unsigned char *dest,TDS_INT destlen)
{
DBANY any;

	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			sprintf(tmp_str,"%c",src[0] ? '1' : '0');
			any.c = tmp_str;
			break;
		case SYBTEXT:
			break;
		case SYBBINARY:
		case SYBIMAGE:
			break;
		case SYBINT1:
			any.ti = src[0] ? 1 : 0;
			break;
		case SYBINT2:
			any.si = src[0] ? 1 : 0;
			break;
		case SYBINT4:
			any.i = src[0] ? 1 : 0;
			break;
		case SYBFLT8:
			any.f = src[0] ? 1.0 : 0.0;
			break;
		case SYBREAL:
			any.r = src[0] ? 1.0 : 0.0;
			break;
		case SYBBIT:
			any.ti = src[0];
			break;
		case SYBMONEY:
			break;
		case SYBMONEY4:
			break;
		case SYBNUMERIC:
		case SYBDECIMAL:
			break;
/*
		case SYBBOUNDRY:
			break;
		case SYBSENSITIVITY:
			break;
*/
	}
	return tds_convert_any(dest, desttype, destlen, &any);
}
TDS_INT tds_convert_int1(int srctype,unsigned char *src,
	int desttype,unsigned char *dest,TDS_INT destlen)
{
DBANY any;

	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			sprintf(tmp_str,"%d",src[0]);
			any.c = tmp_str;
			break;
		case SYBINT1:
			any.ti = *((TDS_TINYINT *) src);
			break;
		case SYBINT2:
			any.si = *((TDS_TINYINT *) src);
			break;
		case SYBINT4:
			any.i = *((TDS_TINYINT *) src);
			break;
		default:
			return TDS_FAIL;
	}
	return tds_convert_any(dest, desttype, destlen, &any);
}
TDS_INT tds_convert_int2(int srctype,unsigned char *src,
	int desttype,unsigned char *dest,TDS_INT destlen)
{
DBANY any;
	
	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			sprintf(tmp_str,"%d",*((TDS_SMALLINT *) src));
			any.c = tmp_str;
			break;
		case SYBINT1:
			any.ti = *((TDS_SMALLINT *) src);
			break;
		case SYBINT2:
			any.si = *((TDS_SMALLINT *) src);
			break;
		case SYBINT4:
			any.i = *((TDS_SMALLINT *) src);
			break;
	}
	return tds_convert_any(dest, desttype, destlen, &any);
}
TDS_INT tds_convert_int4(int srctype,unsigned char *src,
	int desttype,unsigned char *dest,TDS_INT destlen)
{
DBANY any;
	
	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			sprintf(tmp_str,"%ld",*((TDS_INT *) src));
			any.c = tmp_str;
			break;
		case SYBINT1:
			any.ti = *((TDS_INT *) src);
			break;
		case SYBINT2:
			any.si = *((TDS_INT *) src);
			break;
		case SYBINT4:
			any.i = *((TDS_INT *) src);
			break;
		default:
			return TDS_FAIL;
	}
	return tds_convert_any(dest, desttype, destlen, &any);
}
TDS_INT tds_convert_numeric(int srctype,TDS_NUMERIC *src,TDS_INT srclen,
	int desttype,unsigned char *dest,TDS_INT destlen)
{
unsigned long bignum;
char tmpstr[MAXPRECISION];
int left_len;

	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			tds_numeric_to_string(src,dest);
                        return strlen(dest);
			break;
		case SYBNUMERIC:
		case SYBDECIMAL:
			memcpy(dest, src, sizeof(TDS_NUMERIC));
			return sizeof(TDS_NUMERIC);
			break;
		default:
			return TDS_FAIL;
			break;
	}
}
TDS_INT tds_convert_money(int srctype,unsigned char *src,
	int desttype,unsigned char *dest,TDS_INT destlen)
{
unsigned long dollars, hundreths,bignum;

	switch(desttype) {
		case SYBCHAR:
		case SYBVARCHAR:
			return tds_money_to_string(src, dest);
			/* FIX ME -- this will not handle really big money */
			/* bignum=(unsigned char) src[4]+
				(unsigned char) src[5]*256+
				(unsigned char) src[6]*256*256+
				(unsigned char) src[7]*256*256*256;
			dollars=bignum/10000;
			hundreths=bignum%10000;
			sprintf(dest,"%lu.%02lu",dollars,hundreths/100);
                        return strlen(dest); */
			break;
               default:
                        return TDS_FAIL;
                        break;
	}
}
TDS_INT tds_convert_datetime(int srctype,unsigned char *src,int desttype,unsigned char *dest,TDS_INT destlen)
{
   TDS_DATETIME* in = (TDS_DATETIME*)src;
   time_t tmp_secs_from_epoch;
   
   switch(desttype) {
      case SYBCHAR:
      case SYBVARCHAR:
	/* FIX ME -- I beleive this will fail for dates prior to 1970 */
         tmp_secs_from_epoch = ((in->dtdays - 25567)*(24*60*60))
            +(in->dttime/300);
         if (strlen(src)>destlen) {
            strftime(dest, destlen-1, "%b %d %Y %I:%M%p",
                     (struct tm*)gmtime(&tmp_secs_from_epoch));
            return destlen;
         } else {
            strftime(dest, 20, "%b %d %Y %I:%M%p",
                     (struct tm*)gmtime(&tmp_secs_from_epoch));
            return (strlen(dest));
         }
         break;
      case SYBDATETIME:
	memcpy(dest,src,sizeof(TDS_DATETIME));
	break;
      case SYBDATETIME4:
	break;
      default:
         return TDS_FAIL;
         break;
   }
}
TDS_INT tds_convert_datetime4(int srctype,unsigned char *src,int desttype,unsigned char *dest,TDS_INT destlen)
{
   TDS_DATETIME4* in = (TDS_DATETIME4*)src;
   time_t tmp_secs_from_epoch;
   
   switch(desttype) {
      case SYBCHAR:
      case SYBVARCHAR:
	tdsdump_log("%L inside tds_convert_datetime4() days = %d minutes = %d\n", in->days, in->minutes);
        tmp_secs_from_epoch = (in->days - 25567)*(24*60*60) + (in->minutes*60);
        if (strlen(src)>destlen) {
           strftime(dest, destlen-1, "%b %d %Y %I:%M%p",
                    (struct tm*)gmtime(&tmp_secs_from_epoch));
           return destlen;
        } else {
           strftime(dest, 20, "%b %d %Y %I:%M%p",
                    (struct tm*)gmtime(&tmp_secs_from_epoch));
           return (strlen(dest));
	}
	break;
      case SYBDATETIME:
	break;
      case SYBDATETIME4:
	memcpy(dest,src,sizeof(TDS_DATETIME4));
	return(sizeof(TDS_DATETIME4));
      default:
         return TDS_FAIL;
	break;
   }
}
TDS_INT tds_convert_real(int srctype,unsigned char *src,int desttype,unsigned
char *dest,TDS_INT destlen)
{
TDS_REAL the_value = *(float*)src;

   switch(desttype) {
      case SYBCHAR:
      case SYBVARCHAR:
         sprintf(dest,"%10.0f", the_value);
         return strlen(dest);
      case SYBREAL:
	 memcpy(dest,src,sizeof(TDS_REAL));
         return sizeof(TDS_REAL);
   }
   return TDS_FAIL;
}
TDS_INT tds_convert_flt8(int srctype,unsigned char *src,int desttype,unsigned
char *dest,TDS_INT destlen)
{
TDS_FLOAT the_value = *(double*)src;

   switch(desttype) {
      case SYBCHAR:
      case SYBVARCHAR:
         sprintf(dest,"%10.0f", the_value);
         return strlen(dest);
      case SYBFLT8:
	 memcpy(dest,src,sizeof(TDS_FLOAT));
	 return sizeof(TDS_FLOAT);
   }
   return TDS_FAIL;
}

TDS_INT tds_convert_any(unsigned char *dest, TDS_INT dtype, TDS_INT dlen, DBANY *any)
{
	switch(dtype) {
		case SYBCHAR:
		case SYBVARCHAR:
			tdsdump_log("%L converting string dlen = %d strlen = %d string = %s\n",dlen,dtype,any->c);
			if (strlen(any->c)>dlen) {
				strncpy(dest,any->c,dlen-1);
				dest[dlen-1]='\0';
				return dlen;
			} else {
				strcpy(dest, any->c);
				return (strlen(dest));
			}
			break;
		case SYBTEXT:
			break;
		case SYBBINARY:
		case SYBIMAGE:
			break;
		case SYBINT1:
			memcpy(dest,&(any->ti),1);
			return 1;
			break;
		case SYBINT2:
			memcpy(dest,&(any->si),2);
			return 2;
			break;
		case SYBINT4:
			memcpy(dest,&(any->i),4);
			return 4;
			break;
		case SYBFLT8:
			memcpy(dest,&(any->f),8);
			return 8;	
			break;
		case SYBREAL:
			memcpy(dest,&(any->r),4);
			return 4;	
			break;
		case SYBBIT:
			memcpy(dest,&(any->ti),1);
			return 1;
			break;
		case SYBMONEY:
			break;
		case SYBMONEY4:
			break;
		case SYBDATETIME:
			memcpy(dest,&(any->dt),sizeof(TDS_DATETIME));
			break;
		case SYBDATETIME4:
			memcpy(dest,&(any->dt4),sizeof(TDS_DATETIME4));
			break;
		case SYBNUMERIC:
		case SYBDECIMAL:
			break;
/*
		case SYBBOUNDRY:
			break;
		case SYBSENSITIVITY:
			break;
*/
	}
	return TDS_FAIL;
}
TDS_INT tds_convert(int srctype,
		TDS_CHAR *src,
		TDS_INT srclen,
		int desttype,
		TDS_CHAR *dest,
		TDS_INT destlen)
{
	switch(srctype) {
		case SYBCHAR:
		case SYBVARCHAR:
			return tds_convert_char(srctype,src,
				desttype,dest,destlen);
			break;
		case SYBMONEY:
		case SYBMONEYN:
			return tds_convert_money(srctype,src,
				desttype,dest,destlen);
			break;
		case SYBNUMERIC:
			return tds_convert_numeric(srctype,(TDS_NUMERIC *) src,srclen,
				desttype,dest,destlen);
			break;
		case SYBBIT:
			return tds_convert_bit(srctype,src,
				desttype,dest,destlen);
			break;
		case SYBINT1:
			return tds_convert_int1(srctype,src,
				desttype,dest,destlen);
			break;
		case SYBINT2:
			return tds_convert_int2(srctype,src,
				desttype,dest,destlen);
			break;
		case SYBINT4:
			return tds_convert_int4(srctype,src,
				desttype,dest,destlen);
			break;
		case SYBFLT8:
			return tds_convert_flt8(srctype,src,
				desttype,dest,destlen);
			break;
		case SYBDATETIMN:
		case SYBDATETIME:
			return tds_convert_datetime(srctype,src,
				desttype,dest,destlen);
			break;
		case SYBDATETIME4:
			return tds_convert_datetime4(srctype,src,
				desttype,dest,destlen);
			break;

	}
	return TDS_FAIL;
}
static int _string_to_tm(char *datestr, struct tm *t)
{
enum {TDS_MONTH = 1, TDS_DAY, TDS_YEAR, TDS_HOUR, TDS_MIN, TDS_SEC, TDS_MILLI};
int state = TDS_MONTH;
char last_char=0, *s;

	memset(t,'\0',sizeof(struct tm));

	for (s=datestr;*s;s++) {
		if (! isdigit(*s) && isdigit(last_char)) {
			state++;
		} else switch(state) {
			case TDS_MONTH:
				t->tm_mon = (t->tm_mon * 10) + (*s - '0');
				break;
			case TDS_DAY:
				t->tm_mday = (t->tm_mday * 10) + (*s - '0');
				break;
			case TDS_YEAR:
				t->tm_year = (t->tm_year * 10) + (*s - '0');
				break;
			case TDS_HOUR:
				t->tm_hour = (t->tm_hour * 10) + (*s - '0');
				break;
			case TDS_MIN:
				t->tm_min = (t->tm_min * 10) + (*s - '0');
				break;
			case TDS_SEC:
				t->tm_sec = (t->tm_sec * 10) + (*s - '0');
				break;
		}
		last_char=*s;
	}
	return 0;
}
