/* FreeTDS - Library of routines accessing Sybase and Microsoft databases
 * Copyright (C) 1998-1999  Brian Bruns
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "tds.h"
#include "tdsutil.h"
#include <unistd.h>
#include <stdlib.h>

static char  software_version[]   = "$Id: login.c,v 1.14 1999/08/11 01:53:59 camber Exp $";
static void *no_unused_var_warn[] = {software_version,
                                     no_unused_var_warn};


void tds_set_version(TDSLOGIN *tds_login, short major_ver, short minor_ver)
{
	tds_login->major_version=major_ver;
	tds_login->minor_version=minor_ver;
}
void tds_set_packet(TDSLOGIN *tds_login, short packet_size)
{ 
	tds_login->block_size=packet_size; 
}
void tds_set_port(TDSLOGIN *tds_login, int port)
{ 
	tds_login->port=port; 
}
void tds_set_passwd(TDSLOGIN *tds_login, char *password)
{ 
	if (password) {
		strncpy(tds_login->password, password, 
			sizeof(tds_login->password)); 
	}
}
void tds_set_user(TDSLOGIN *tds_login, char *username)
{ 
	strncpy(tds_login->user_name, username, sizeof(tds_login->user_name)); 
}
void tds_set_host(TDSLOGIN *tds_login, char *hostname)
{
	strncpy(tds_login->host_name, hostname, sizeof(tds_login->host_name));
}
void tds_set_app(TDSLOGIN *tds_login, char *application)
{
	strncpy(tds_login->app_name, application, sizeof(tds_login->app_name));
}
void tds_set_server(TDSLOGIN *tds_login, char *server)
{
	strncpy(tds_login->server_name, server, sizeof(tds_login->server_name));
}
void tds_set_library(TDSLOGIN *tds_login, char *library)
{
	strncpy(tds_login->library, library, sizeof(tds_login->library));
}
void tds_set_charset(TDSLOGIN *tds_login, char *charset)
{
	strncpy(tds_login->char_set, charset, sizeof(tds_login->char_set));
}
void tds_set_language(TDSLOGIN *tds_login, char *language)
{
	strncpy(tds_login->language, language, sizeof(tds_login->language));
}
extern void tds_set_capabilities(TDSLOGIN *tds_login, unsigned char *capabilities, int size)
{
	memcpy(tds_login->capabilities, capabilities, 
		size > TDS_MAX_CAPABILITY ? TDS_MAX_CAPABILITY : size);
}

TDSSOCKET *tds_connect(TDSLOGIN *login) 
{
TDSSOCKET	*tds;
struct sockaddr_in      sin;
char	ip_addr[255],ip_port[255];

   tdsdump_open("/tmp/freetds.log");
	tds = tds_alloc_socket(BUFSIZ);
	tds->major_version=login->major_version;
	tds->minor_version=login->minor_version;
	memcpy(tds->capabilities,login->capabilities,TDS_MAX_CAPABILITY);
	if (!login->port) {
		get_server_info(login->server_name, ip_addr, ip_port);
        	sin.sin_addr.s_addr = inet_addr(ip_addr);
        	sin.sin_family = AF_INET;
        	sin.sin_port = htons(atoi(ip_port));
	} else {
        	sin.sin_addr.s_addr = inet_addr(login->server_name);
        	sin.sin_family = AF_INET;
        	sin.sin_port = htons(login->port);
	}

        if ((tds->s = socket (AF_INET, SOCK_STREAM, 0)) < 0) {
                perror ("socket");
		return NULL;
        }

        if (connect(tds->s, (struct sockaddr *) &sin, sizeof(sin)) <0) {
                perror("connect");
		return NULL;
        }
	tds->out_flag=0x02;
	tds_send_login(tds,login);	
	/* get_incoming(tds->s);  */
	if (!tds_process_login_tokens(tds)) return NULL;
	return tds;
}
int tds_send_login(TDSSOCKET *tds, TDSLOGIN *login)
{	
   unsigned char magic1[]= {
      
#if defined(HW_LITTLE_ENDIAN)
      0x03,0x01,0x06,0x0a,0x09,
#elif defined(HW_BIG_ENDIAN)
      0x02,0x00,0x06,0x04,0x08,
#else
#error Endianness not defined!
#endif
      0x01};
      unsigned char magic2[]={0x00,0x00};
   
   unsigned char magic3[]= {0x00,0x00,0x00};
   
/* these seem to endian flags as well 13,17 on intel/alpha 12,16 on power */
   
#if defined(HW_LITTLE_ENDIAN)
   unsigned char magic4[]= {0x00,13,17};
#elif defined(HW_BIG_ENDIAN)
   unsigned char magic4[]= {0x00,12,16};
#endif
   
   /* 
   ** the former byte 0 of magic5 causes the language token and message to be 
   ** absent from the login acknowledgement if set to 1. There must be a way 
   ** of setting this in the client layer, but I am not aware of any thing of
   ** the sort -- bsb 01/17/99
   */
   unsigned char magic5[]= {0x00,0x00};
   unsigned char magic6[]= {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
   unsigned char magic7=   0x01;
   
   unsigned char magic42[]= {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
   unsigned char magic50[]= {0x00,0x00,0x00,0x00};
   unsigned char capabilities[]= {0x01,0x07,0x03,109,127,0xFF,0xFF,0xFF,0xFE,0x02,0x07,0x00,0x00,0x0A,104,0x00,0x00,0x00};
/*
** This is the original capabilities packet we were working with (sqsh)
   unsigned char capabilities[]= {0x01,0x07,0x03,109,127,0xFF,0xFF,0xFF,0xFE,0x02,0x07,0x00,0x00,0x0A,104,0x00,0x00,0x00};
** original with 4.x messages
   unsigned char capabilities[]= {0x01,0x07,0x03,109,127,0xFF,0xFF,0xFF,0xFE,0x02,0x07,0x00,0x00,0x00,120,192,0x00,0x0D};
** This is isql 11.0.3
   unsigned char capabilities[]= {0x01,0x07,0x00,96, 129,207, 0xFF,0xFE,62,  0x02,0x07,0x00,0x00,0x00,120,192,0x00,0x0D};
** like isql but with 5.0 messages
   unsigned char capabilities[]= {0x01,0x07,0x00,96, 129,207, 0xFF,0xFE,62,  0x02,0x07,0x00,0x00,0x00,120,192,0x00,0x00};
**
*/
   
   unsigned char protocol_version[4];
   unsigned char program_version[4];
   
   int rc;
   char blockstr[10], passwdstr[255];
   
   if (IS_TDS42(tds)) {
      memcpy(protocol_version,"\004\002\000\000",4);
      memcpy(program_version,"\004\002\000\000",4);
   } else if (IS_TDS46(tds)) {
      memcpy(protocol_version,"\004\006\000\000",4);
      memcpy(program_version,"\004\002\000\000",4);
   } else if (IS_TDS50(tds)) {
      memcpy(protocol_version,"\005\000\000\000",4);
      memcpy(program_version,"\005\000\000\000",4);
   } else {
      fprintf(stderr,"Unknown protocol version!");
      exit(1);
   }
   /*
   ** the following code is adapted from  Arno Pedusaar's 
   ** (psaar@fenar.ee) MS-SQL Client. His was a much better way to
   ** do this, (well...mine was a kludge actually) so here's mostly his
   */
   
   rc=tds_put_string(tds,login->host_name,30);   /* client host name */
   rc|=tds_put_string(tds,login->user_name,30);  /* account name */
   rc|=tds_put_string(tds,login->password,30);  /* account password */
   rc|=tds_put_string(tds,"37876",30);        /* host process */
   rc|=tds_put_n(tds,magic1,6);
   rc|=tds_put_byte(tds,login->bulk_copy);
   rc|=tds_put_n(tds,magic2,2);
   if (IS_TDS42(tds)) {
      rc|=tds_put_int(tds,512);
   } else {
      rc|=tds_put_int(tds,0);
   }
   rc|=tds_put_n(tds,magic3,3);
   rc|=tds_put_string(tds,login->app_name,30);
   rc|=tds_put_string(tds,login->server_name,30);
   if (IS_TDS42(tds)) {
      rc|=tds_put_string(tds,login->password,255);
   } else {
      sprintf(passwdstr,"%c%c%s",0,strlen(login->password),login->password);
      rc|=tds_put_buf(tds,passwdstr,255,strlen(login->password)+2);
   }
   
   rc|=tds_put_n(tds,protocol_version,4); /* TDS version; { 0x04,0x02,0x00,0x00 } */
   rc|=tds_put_string(tds,login->library,10);  /* client program name */
   if (IS_TDS42(tds)) { 
      rc|=tds_put_int(tds,0);
   } else {
      rc|=tds_put_n(tds,program_version,4); /* program version ? */
   }
   rc|=tds_put_n(tds,magic4,3);
   rc|=tds_put_string(tds,login->language,30);  /* language */
   rc|=tds_put_byte(tds,login->suppress_language);
   rc|=tds_put_n(tds,magic5,2);
   rc|=tds_put_byte(tds,login->encrypted);
   rc|=tds_put_n(tds,magic6,10);
   rc|=tds_put_string(tds,login->char_set,30);  /* charset */
   rc|=tds_put_byte(tds,magic7);
   sprintf(blockstr,"%d",login->block_size);
   rc|=tds_put_string(tds,blockstr,6); /* network packet size */
   if (IS_TDS42(tds)) {
      rc|=tds_put_n(tds,magic42,8);
   } else if (IS_TDS46(tds)) {
      rc|=tds_put_n(tds,magic42,4);
   } else if (IS_TDS50(tds)) {
      rc|=tds_put_n(tds,magic50,4);
      rc|=tds_put_byte(tds, TDS_CAP_TOKEN);
      rc|=tds_put_smallint(tds, 18);
      rc|=tds_put_n(tds,tds->capabilities,TDS_MAX_CAPABILITY);
   }
   
   rc|=tds_flush_packet(tds);
   /* get_incoming(tds->s); */

}
