/* FreeTDS - Library of routines accessing Sybase and Microsoft databases
 * Copyright (C) 1998-1999  Brian Bruns
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "tds.h"
#include "tdsutil.h"
#include <unistd.h>
#include <stdlib.h>


static char  software_version[]   = "$Id: write.c,v 1.6 1999/06/25 23:37:15 camber Exp $";
static void *no_unused_var_warn[] = {software_version,
                                     no_unused_var_warn};


int tds_put_n(TDSSOCKET *tds, unsigned char *buf, int n)
{
int i;

	for (i=0;i<n;i++)	
		tds_put_byte(tds,buf[i]);
}
int tds_put_string(TDSSOCKET *tds, unsigned char *buf, int n)
{
	return tds_put_buf(tds,buf,n,strlen(buf));
}
int tds_put_buf(TDSSOCKET *tds, unsigned char *buf, int dsize, int ssize)
{
char *tempbuf;
int  cpsize;

	tempbuf = (char *) malloc(dsize+1);
	memset(tempbuf,'\0',dsize);
	cpsize = ssize > dsize ? dsize : ssize;
	memcpy(tempbuf,buf, cpsize);
	tds_put_n(tds,tempbuf,dsize);
	free(tempbuf);
	tds_put_byte(tds,cpsize);
}
int tds_put_int(TDSSOCKET *tds, TDS_INT i)
{
	tds_put_n(tds,(unsigned char *)&i,sizeof(TDS_INT));
}
int tds_put_smallint(TDSSOCKET *tds, TDS_SMALLINT si)
{
	tds_put_n(tds,(unsigned char *)&si,sizeof(TDS_SMALLINT));
}
int tds_put_tinyint(TDSSOCKET *tds, TDS_TINYINT ti)
{
	tds_put_n(tds,(unsigned char *)&ti,sizeof(TDS_TINYINT));
}
int tds_put_byte(TDSSOCKET *tds, unsigned char c)
{
	tds->out_buf[tds->out_pos]=c;
	/* FIX ME -- add packet size support */
	if (++tds->out_pos>=512) {
		tds_write_packet(tds,0x0);
		tds_init_write_buf(tds);
	}
}
int tds_init_write_buf(TDSSOCKET *tds)
{
	memset(tds->out_buf,'\0',512);
	tds->out_pos=8;
}
int tds_write_packet(TDSSOCKET *tds,unsigned char final)
{
	tds->out_buf[0]=tds->out_flag;
	tds->out_buf[1]=final;
	tds->out_buf[2]=(tds->out_pos)/256;
	tds->out_buf[3]=(tds->out_pos)%256;

        tdsdump_log("Sending packet @ %L\n%D\n", tds->out_buf, tds->out_pos);

	write(tds->s,tds->out_buf,tds->out_pos);
	/* for (i=0;i<tds->out_pos;i++) {
		printf ("%d:%d",i,tds->out_buf[i]);
		if (tds->out_buf[i]>=' ' && tds->out_buf[i]<'z')
			printf(" %c",tds->out_buf[i]);
		printf("\n");
	} */
	/* fsync(tds->s); */
	/* sleep(1); * fsync doesn't flush the buffer ? */
	return 1;
}
int tds_flush_packet(TDSSOCKET *tds)
{
	tds_write_packet(tds,0x01);
	tds_init_write_buf(tds);
}
