/*
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   MODULE_NAME:		fsckmsge.h
 *
 *   COMPONENT_NAME: 	jfschk
 *
 */
#ifndef H_FSCKMSGT
#define H_FSCKMSGT

#ifndef _JFS_XCHKDMP
#include "xfsck.h"
#endif

/*
 * The following array contains the text for JFS fsck messages
 *
 * NOTE: the message contained in position i in this array
 *
 *	o is processed according to contents of position i in the
 *	  message protocol array (fsckmsgp.h)
 *
 *	o is translated to the local language in position i+50 in the
 *    JFS message file (source: jfs.txt  binary: jfs.msg, jfsh.msg)
 *	  if and only if it also appears in jfs.txt.
 *
 */

char *MsgText[]={
/*  0*/
    "Operation was successful.\n\r"
/*  1*/
   ,"FSCK  All observed inconsistencies have been repaired.\n\r"
/*  2*/
   ,"FSCK  Invalid data format detected in root directory.\n\r"
/*  3*/
   ,"FSCK  A combination of Minimum Free Blocks and Total Usable Blocks which is inval\
id for the filesystem size was detected in the superblock (%s).\n\r"
/*  4*/
   ,"FSCK  Invalid block number(s) (%s) detected for file system object %s%s%s.\n\r"
/*  5*/
   ,"FSCK  File system object %s%s%s has a corrupt backward sibling chain.\n\r"
/*  6*/
   ,"FSCK  File system object %s%s%s has a corrupt forward sibling chain.\n\r"
/*  7*/
   ,"FSCK  Inode %s%s has unrecognized type.\n\r"
/*  8*/
   ,"FSCK  File system object %s%s%s has invalid descriptor (%s).\n\r"
/*  9*/
   ,"FSCK  Inode %s%s has incorrect link count.\n\r"
/* 10*/
   ,"FSCK  Directory inode %s%s refers to a nonexistent inode %s%s (entry %s).\n\r"
/* 11*/
   ,"FSCK  Error (%s,%s) writing to the fsck service log (%s,%s,%s,%s).  \
Continuing.\n\r"
/* 12*/
   ,"FSCK  The boot sector has been refreshed.\n\r"
/* 13*/
   ,"FSCK  File system object %s%s%s has corrupt data (%s).\n\r"
/* 14*/
   ,"FSCK  Invalid data (%s) detected in the superblock (%s).\n\r"
/* 15*/
   ,"FSCK  Invalid allocation group size in the superblock (%s).\n\r"
/* 16*/
   ,"FSCK  Invalid filesystem block size in the superblock (%s).\n\r"
/* 17*/
   ,"FSCK  Invalid filesystem size in the superblock (%s).\n\r"
/* 18*/
   ,"FSCK  Superblock is corrupt and cannot be repaired since both primary and seconda\
ry copies are corrupt.  FSCK CANNOT CONTINUE.\n\r"
/* 19*/
   ,"FSCK  Primary superblock is corrupt and cannot be repaired without write access. \
Continuing. \n\r"
/* 20*/
   ,"Usage: xchklog [-L[:N|:P]] <device>\n\r"
/* 21 */
   ,"FSCK  Invalid magic number in the superblock (%s).\n\r"
/* 22 */
   ,"FSCK  Invalid version number in the superblock (%s).\n\r"
/* 23*/
   ,"FSCK  Incorrect maxbud AG detected in Block Map Control Page.\n\r"
/* 24*/
   ,"FSCK  Incorrect number of free blocks detected in Block Map Control Page.\n\r"
/* 25*/
   ,"FSCK  In superblock (%s) filesystem block size smaller than volume block size.\n\r"
/* 26*/
   ,"FSCK  Invalid format detected in Root directory.\n\r"
/* 27*/
   ,"FSCK  Device parm defaulting to current volume: %s\n\r"
/* 28*/
   ,"FSCK  Unable to write to boot sector Master Boot Record.  Continuing.\n\r"
/* 29*/
   ,"FSCK  Secondary file/directory allocation structure (%s) is not a \
correct redundant copy of primary structure.\n\r"
/* 30*/
   ,"FSCK  Unable to replicate primary file/directory allocation structure \
(%s) to secondary.  FUTURE RECOVERY CAPABILITY IS COMPROMISED.\n\r"
/* 31*/
   ,"XCHKLOG  fsck service log selected:  MOST RECENT\n\r"
/* 32*/
   ,"FSCK  MINOR: Cannot create directory lost+found in root directory.  mkdir \
lost+found in the root directory then run fsck with the -f parameter to reconnect\
lost files and/or directories.\n\r"
/* 33*/
   ,"FSCK  Fileset object %s%s%s:  No paths found.\n\r"
/* 34*/
   ,"FSCK  The path(s) refer to an unallocated file.\n\r "
/* 35*/
   ,"XCHKLOG  fsck service log selected:  PREVIOUS\n\r"
/* 36*/
   ,"FSCK  The path(s) refer to an unallocated file. Will remove.\n\r "
/* 37*/
   ,"FSCK  Unable to repair primary inode allocation structure (%s). Continuing.\n\r"
/* 38*/
   ,"FSCK  Root directory has a corrupt tree.\n\r"
/* 39*/
   ,"FSCK  Initialized tree created for root directory.\n\r"
/* 40*/
   ,"FSCK  Unable to read primary superblock.\n\r"
/* 41 */
   ,"fsck service log: INVALID LOG RECORD: SKIPPING ONE OR MORE LOG RECORDS.\n\r"
/* 42 */
   ,"FSCK  processing started: %s\n\r"
/* 43*/
   ,"\n********************************************************** \n\n\r"
/* 44*/
   ,"FSCK  Unable to write primary superblock.\n\r"
/* 45*/
   ,"FSCK  Fatal error (%s,%s) accessing the filesystem (%s,%s,%s,%s).\n\r"
/* 46*/
   ,"FSCK  Multiple parent directories for directory %s%s.\n\r"
/* 47*/
   ,"FSCK  External journal log not supported.\n\r"
/* 48*/
   ,"FSCK  Duplicate reference to %s block(s) beginning at offset %s found in \
file system object %s%s%s.\n\r"
/* 49*/
   ,"FSCK  File set metadata inode %s%s is corrupt.\n\r"
/* 50*/
   ,"FSCK  Fatal error (%s,%s) accessing the workspace (%s,%s,%s,%s).\n\r"
/* 51*/
   ,"FSCK  Insufficient dynamic storage available for required workspace \
(%s,%s). FSCK CANNOT CONTINUE\n\r"
/* 52*/
   ,"FSCK  IOCtl(...DSK_GETDEVICEPARAMS...) returned rc = %s\n\r"
/* 53*/
   ,"FSCK  Filesystem is currently mounted.\n\r"
/* 54*/
   ,"FSCK  Invalid data (%s) detected in file system object %s%s%s.\n\r"
/* 55*/
   ,"FSCK  Block size in bytes:  %s\n\r"
/* 56*/
   ,"FSCK  Filesystem size in blocks:  %s\n\r"
/* 57*/
   ,"FSCK  Filesystem Summary:\n\r"
/* 58*/
   ,"FSCK    Blocks in use for inodes:  %s\n\r"
/* 59*/
   ,"FSCK    Inode count:  %s\n\r"
/* 60*/
   ,"FSCK    File count:  %s\n\r"
/* 61 */
   ,"FSCK    Directory count:  %s\n\r"
/* 62 */
   ,"FSCK  Inode %s%s has references to cross linked blocks.\n\r"
/* 63*/
   ,"FSCK    Block count:  %s\n\r"
/* 64*/
   ,"FSCK    Free block count:  %s\n\r"
/* 65*/
   ,"FSCK  Directory inode %s%s entry %s refers to an illegal inode %s%s.\n\r"
/* 66*/
   ,"Usage: xchklog [-L[:N|:P]] [-F<filename>] <device>\n\r"
/* 67*/
   ,"FSCK  Unable to get path for link from directory %s%s to fileset object %s%s%s.\n\r"
/* 68*/
   ,"FSCK  Format error in Extended Attributes Space or descriptor.\n\r"
/* 69*/
   ,"FSCK  Discrepancies detected in the Free Inode Extent List for Allocation \
Group %s%s. (%s)\n\r"
/* 70*/
   ,"FSCK  MINOR: Unable to reconnect file inode %s%s.  Continuing.\n\r"
/* 71*/
   ,"FSCK  Directory %s%s entry \"..\" refers to an incorrect parent directory (%s%s).\n\r"
/* 72*/
   ,"FSCK  Directory inode %s%s entry \"..\" reference to incorrect inode \
corrected.\n\r"
/* 73*/
   ,"FSCK  Storage allocated to inode %s%s has been cleared.\n\r"
/* 74*/
   ,"FSCK  Storage allocated to extended attributes for inode \
%s%s has been cleared.\n\r"
/* 75*/
   ,"FSCK  File inode %s%s has been reconnected to /lost+found/.\n\r"
/* 76*/
   ,"FSCK  Link count for inode %s%s has been adjusted/corrected.\n\r"
/* 77*/
   ,"FSCK  IOCtl(...DSK_LOCKDRIVE...) returned rc = %s\n\r"
/* 78*/
   ,"FSCK  No paths were found for inode %s%s.\n\r"
/* 79*/
   ,"FSCK  File system object %s%s%s is linked as: %s\n\r"
/* 80*/
   ,"FSCK  Directory inode %s%s entry reference to inode %s%s removed.\n\r"
/* 81 */
   ,"FSCK  Invalid fwsp length detected in the superblock (%s).\n\r"
/* 82 */
   ,"FSCK  Invalid fwsp address detected in the superblock (%s).\n\r"
/* 83*/
   ,"FSCK  Open(...READONLY...) returned rc = %s\n\r"
/* 84*/
   ,"FSCK  MINOR: Insufficient dynamic storage to validate extended attributes \
format.\n\r"
/* 85*/
   ,"FSCK  logredo failed (rc=%s).  fsck continuing.\n\r"
/* 86*/
   ,"FSCK  logredo returned rc = %s\n\r"
/* 87*/
   ,"FSCK  Unable to create a lost+found directory in root  because root already \
contains a non-directory object named lost+found.  Rename the existing lost+found \
object in root, mkdir lost+found in the root directory, then run fsck with the \
-f parameter to reconnect lost files and/or directories.\n\r"
/* 88*/
   ,"FSCK  Checking a mounted filesystem does not produce dependable results.\n\r"
/* 89*/
   ,"FSCK **** Filesystem was modified. ****\n\r"
/* 90*/
   ,"FSCK  ujfs_redeterminemedia() returned rc = %s\n\r"
/* 91*/
   ,"FSCK  Superblock marked.\n\r"
/* 92*/
   ,"FSCK  %s blocks are missing.\n\r"
/* 93*/
   ,"FSCK  Unable to write to boot sector.  Continuing.\n\r"
/* 94*/
   ,"FSCK  No \\lost+found directory found in the filesystem.\n\r"
/* 95*/
   ,"FSCK  Incorrect link counts detected in the aggregate.\n\r"
/* 96*/
   ,"FSCK  The Inode Allocation Map control information has an incorrect number of \
backed inodes value for AG %s%s.\n\r"
/* 97*/
   ,"FSCK  The Inode Allocation Map control information has an incorrect number of \
free inodes value for AG %s%s.\n\r"
/* 98*/
   ,"FSCK  Unrecoverable error reading %s from %s. FSCK CANNOT CONTINUE.\n\r"
/* 99*/
   ,"FSCK **Phase 0 - Replay Journal Log\n\r"
/*100*/
   ,"FSCK **Phase 1 - Check Blocks, Files/Directories, and  Directory Entries\n\r"
/*101 */
   ,"FSCK **Phase 2 - Count links\n\r"
/*102 */
   ,"FSCK **Phase 3 - Duplicate Block Rescan and Directory Connectedness\n\r"
/*103*/
   ,"FSCK **Phase 4 - Report Problems\n\r"
/*104*/
   ,"FSCK **Phase 5 - Check Connectivity\n\r"
/*105*/
   ,"FSCK **Phase 6 - Perform Approved Corrections\n\r"
/*106*/
   ,"FSCK **Phase 7 - Rebuild File/Directory Allocation Maps\n\r"
/*107*/
   ,"FSCK **Phase 8 - Rebuild Disk Allocation Maps\n\r"
/*108*/
   ,"FSCK **Phase 9 - Reformat File System Log\n\r"
/*109*/
   ,"FSCK  Directory has entry for unallocated file %s%s. Will remove.\n\r"
/*110*/
   ,"FSCK  FATAL ERROR (%s,%s) ON READ Aggregate Inode Table (%s) first extent.\n\r"
/*111*/
   ,"FSCK  Format error in Extended Attributes Space or descriptor. Will clear.\n\r"
/*112*/
   ,"FSCK  The extent descriptor for inodes %s through %s is invalid.  (Inode Allocation Map %s%s,\
Inode Allocation Group %s, Extent Index %s).\n\r"
/*113*/
   ,"FSCK  Extended attributes for file set object %s%s%s have an invalid format.\n\r"
/*114*/
   ,"FSCK  Superblock marked dirty because repairs are about to be written.\n\r"
/*115*/
   ,"FSCK Mutually exclusive -f parameters specified.\n\r"
/*116*/
   ,"FSCK Usage: fsck.jfs [-a] [-c] [-d] [-f[:0|:1|:2]] [-o] [-r] <device>\n\r"
/*117*/
   ,"FSCK Unrecognized FSCK -f parameter value detected:   %s\n\r"
/*118*/
   ,"FSCK Unsupported FSCK parameter:   %s\n\r"
/*119*/
   ,"FSCK  logformat failed (rc=%s).  fsck continuing.\n\r"
/*120*/
   ,"FSCK  logformat returned rc = %s\n\r"
/*121 */
   ,"FSCK  Unable to read device characteristics.  Boot sector cannot be refreshed.  \
Continuing.\n\r"
/*122 */
   ,"FSCK  Primary superblock is corrupt.\n\r"
/*123 */
   ,"FSCK  Inode Allocation Group %s%s is inconsistent.\n\r"
/*124 */
   ,"FSCK  cannot repair an allocation error for files and/or directories %s through %s.\n\r"
/*125*/
   ,"FSCK  Root inode is not a directory.\n\r"
/*126*/
   ,"FSCK  Root inode is not allocated.\n\r"
/*127*/
   ,"FSCK  Root inode allocated.\n\r"
/*128*/
   ,"FSCK  Root inode changed to directory.\n\r"
/*129*/
   ,"FSCK  IOCtl(...DSK_UNLOCKDRIVE...) returned rc = %s\n\r"
/*130*/
   ,"FSCK  Primary superblock is valid.\n\r"
/*131*/
   ,"FSCK  processing terminated:  %s   with return code: %s.\n\r"
/*132*/
   ,"FSCK  Close returned rc = %s\n\r"
/*133*/
   ,"FSCK  Using default parameter:  -f:0\n\r"
/*134*/
   ,"FSCK  Open(...READ/WRITE EXCLUSIVE...) returned rc = %s\n\r"
/*135*/
   ,"FSCK  One or more directory entry found for unallocated inode %s%s.\n\r"
/*136*/
   ,"FSCK  cannot recover files and/or directories %s through %s.  \
FSCK CANNOT CONTINUE.\n\r"
/*137*/
   ,"FSCK  Unrecoverable error writing %s to %s. FSCK CANNOT CONTINUE.\n\r"
/*138*/
   ,"FSCK  The root directory has an invalid data format.  Will correct.\n\r"
/*139*/
   ,"FSCK  The root directory has an invalid format.  Will correct.\n\r"
/*140*/
   ,"FSCK  cannot recover files and/or directories %s through %s.  Will release.\n\r"
/*141 */
   ,"FSCK  File claims cross linked block(s).\n\r"
/*142 */
   ,"FSCK  cannot repair the data format error(s) in this file.\n\r"
/*143*/
   ,"FSCK  cannot repair the format error(s) in this file.\n\r"
/*144*/
   ,"FSCK  cannot repair %s%s%s.\n\r"
/*145*/
   ,"FSCK  The current hard disk drive is:  %s\n\r"
/*146*/
   ,"FSCK  The type of file system for the disk is JFS.\n\r"
/*147*/
   ,"FSCK  cannot repair %s%s%s.  Will release.\n\r"
/*148*/
   ,"FSCK  Secondary superblock is valid.\n\r"
/*149*/
   ,"FSCK  Unable to open for write access.  Proceeding in read-only mode.\n\r"
/*150 */
   ,"FSCK  Multiple parent directories for directory %s%s.  Will correct.\n\r"
/*151 */
   ,"FSCK  Directory %s%s entry \"..\" refers to an incorrect parent directory \
(%s%s). Will correct.\n\r"
/*152*/
   ,"FSCK  %s unexpected blocks detected.\n\r"
/*153*/
   ,"FSCK  Directories with illegal hard links have been detected.\n\r"
/*154*/
   ,"FSCK  Directory entries (entries \"..\") referring to incorrect parent \
directories have been detected.\n\r"
/*155*/
   ,"FSCK  Directory entries for unallocated files have been detected.\n\r"
/*156*/
   ,"FSCK  Unable to write secondary superblock.\n\r"
/*157*/
   ,"FSCK  Incorrect link counts have been detected. Will correct.\n\r"
/*158*/
   ,"FSCK  File set object %s%s%s has inline data conflict (type %s).\n\r"
/*159*/
   ,"FSCK  Duplicate block references have been detected in Metadata. FSCK CANNOT CONTINUE.\n\r"
/*160*/
   ,"FSCK  Multiple metadata references to %s blocks beginning at \
offset %s have been detected.\n\r"
/*161*/
   ,"FSCK  Directory inode %s%s has a node with empty freelist and nonzero freecount.\n\r"
/*162*/
   ,"FSCK  Unable to read entire first extent of AIT (%s).\n\r"
/*163*/
   ,"FSCK  Unable to read first extent of AIT (%s).\n\r"
/*164*/
   ,"FSCK  Unrecoverable error during UNLOCK processing.\n\r"
/*165*/
   ,"FSCK  Unrecoverable error during CLOSE processing.\n\r"
/*166*/
   ,"FSCK  The root directory reference (entry \"..\") has been corrected.\n\r"
/*167*/
   ,"FSCK  %s appears to be the correct path for directory %s%s.\n\r"
/*168*/
   ,"FSCK  Directory inode %s%s has illegal hard links.\n\r"
/*169*/
   ,"FSCK  Directory inode %s%s refers (entry \"..\") to an incorrect inode (%s%s).\n\r"
/*170*/
   ,"FSCK  One or more directory entry found for unallocated inode %s%s.\n\r"
/*171*/
   ,"FSCK  ERRORS HAVE BEEN DETECTED.  Run fsck with the -f parameter to repair.\n\r"
/*172*/
   ,"FSCK  The root directory refers (entry \"..\") to an incorrect inode.\n\r"
/*173*/
   ,"FSCK  %s directory reconnected to /lost+found/.\n\r"
/*174*/
   ,"FSCK  MINOR: Unable to reconnect %s directory.  Continuing.\n\r"
/*175*/
   ,"FSCK  Inode %s%s is not connected to the root directory tree.\n\r"
/*176*/
   ,"XCHKLOG  Most recent fsck service log extracted into:  %s\n\r"
/*177*/
   ,"XCHKLOG  Prior fsck service log extracted into:  %s\n\r"
/*178*/
   ,"XCHKLOG  Can't open output file:  %s\n\r"
/*179*/
   ,"FSCK  Invalid stamp detected in file system object %s%s%s.\n\r"
/*180*/
   ,"FSCK  Files and/or directories not connected to the root directory tree \
have been detected.\n\r"
/*181*/
   ,"FSCK  Directory entries for unallocated files have been detected.  \
Will remove.\n\r"
/*182*/
   ,"FSCK  Files and/or directories not connected to the root directory tree \
have been detected.  Will reconnect.\n\r"
/*183*/
   ,"FSCK  Directories with illegal hard links have been detected.  Will correct.\n\r"
/*184*/
   ,"FSCK  Directories (entries \"..\") referring to incorrect parent directories \
have been detected.  Will correct.\n\r"
/*185*/
   ,"XCHKDMP  Can't open input file:  %s\n\r"
/*186*/
   ,"FSCK  Filesystem is clean.\n\r"
/*187*/
   ,"FSCK  Filesystem is clean but is marked dirty.  Run fsck with the -f \
parameter to fix.\n\r"
/*188*/
   ,"FSCK  Filesystem is dirty.\n\r"
/*189*/
   ,"FSCK  Filesystem is dirty but is marked clean.  In its present state,\nthe \
results of accessing %s (except by this utility) are undefined.\n\r"
/*190*/
   ,"FSCK  Filesystem has been marked clean.\n\r"
/*191*/
   ,"FSCK  Filesystem has been marked dirty because it contains critical errors.\
Filesystem may be unrecoverable.\n\r"
/*192*/
   ,"FSCK  File system object %s%s%s has an illegal empty node.\n\r"
/*193*/
   ,"FSCK File system object %s%s%s -- extent at offset %s has an invalid size (%s).\n\r"
/*194*/
   ,"FSCK  Dense file (inode %s%s) begins with an unallocated section.\n\r"
/*195*/
   ,"FSCK  Dense file (inode %s%s) has an unallocated section after offset %s.\n\r"
/*196*/
   ,"FSCK  The  Free Inode Extent List is inconsistent for Allocation \
Group %s%s.\n\r"
/*197*/
   ,"FSCK  Discrepancies detected in the Free Inode List for Allocation \
Group %s%s. (%s) \n\r"
/*198*/
   ,"FSCK  The Free Inode List is inconsistent for Allocation Group %s%s.\n\r"
/*199*/
   ,"FSCK  Inode Allocation Group %s%s has an invalid Allocation Group (%s).\n\r"
/*200*/
   ,"FSCK  Directory has an entry for an unallocated file %s%s.\n\r"
/*201*/
   ,"FSCK  Directory inode %s%s has a node with incorrect size.\n\r"
/*202*/
   ,"FSCK  Directory inode %s%s has a node with invalid size.\n\r"
/*203*/
   ,"FSCK  Directory inode %s%s has a node with an invalid freelist.\n\r"
/*204*/
   ,"FSCK  Directory inode %s%s has a node with an incorrect freecount.\n\r"
/*205*/
   ,"FSCK  Directory inode %s%s has a node with an incorrect freelist.\n\r"
/*206*/
   ,"FSCK  Inode Allocation Group %s%s has an invalid AG Start.\n\r"
/*207*/
   ,"FSCK  Inode Allocation Group %s%s has an invalid Free Extent Summary.\n\r"
/*208*/
   ,"FSCK  Inode Allocation Group %s%s has an invalid Free Inode Summary.\n\r"
/*209*/
   ,"FSCK  Discrepancies detected in the Free IAG List. (%s,%s)\n\r"
/*210*/
   ,"FSCK  The Free Inode Allocation Group List is inconsistent (%s).\n\r"
/*211*/
   ,"FSCK  Inode Allocation Group %s%s has an incorrect IAG number value.\n\r"
/*212*/
   ,"FSCK  Inode Allocation Group %s%s has an inconsistent count for \
number of free extents.\n\r"
/*213*/
   ,"FSCK  Inode Allocation Group %s%s has an inconsistent count for \
number of free inodes.\n\r"
/*214*/
   ,"FSCK  Discrepancies detected in the pmap for Inode Allocation Group %s%s.\n\r"
/*215*/
   ,"FSCK  Errors detected in the Fileset File/Directory Allocation Map.\n\r"
/*216*/
   ,"FSCK  The Inode Allocation Map blocks per inode extent is incorrect (%s).\n\r"
/*217*/
   ,"FSCK  Errors detected in the Fileset File/Directory Allocation Map control information.\n\r"
/*218*/
   ,"FSCK  The Inode Allocation Map log2(blocks per inode extent) is incorrect (%s).\n\r"
/*219*/
   ,"FSCK  The Inode Allocation Map has an incorrect number of backed inodes value (%s).\n\r"
/*220*/
   ,"FSCK  The Inode Allocation Map has an incorrect number of free inodes value (%s).\n\r"
/*221*/
   ,"FSCK  The Inode Allocation Map has an incorrect next IAG value (%s).\n\r"
/*222*/
   ,"Usage: xchkdmp [-L[:N|:P]] [-F<filename>]\n\r"
/*223*/
   ,"FSCK  Correcting Inode Allocation Group %s%s invalid Allocation Group (%s).\n\r"
/*224*/
   ,"FSCK  Correcting Inode Allocation Group %s%s invalid AG Start.\n\r"
/*225*/
   ,"FSCK  Inconsistencies detected in leaf values (%s).\n\r"
/*226*/
   ,"FSCK  Inconsistencies detected in internal values (%s).\n\r"
/*227*/
   ,"FSCK  Incorrect data detected in pages (%s).\n\r"
/*228*/
   ,"FSCK  Descrepancies detected between observed block allocations and pmaps.\n\r"
/*229*/
   ,"FSCK  Incorrect data detected in disk allocation structures.\n\r"
/*230*/
   ,"FSCK  Incorrect data detected in disk allocation control structures.\n\r"
/*231*/
   ,"FSCK  Incorrect height detected in in page %s,%s.\n\r"
/*232*/
   ,"FSCK  Incorrect l2 number of leafs detected in in page %s,%s.\n\r"
/*233*/
   ,"FSCK  Incorrect leaf index detected in in page %s,%s.\n\r"
/*234*/
   ,"FSCK  Incorrect leaf (%s) value detected in %s page %s.\n\r"
/*235*/
   ,"FSCK  Incorrect internal (%s) value detected in %s page %s.\n\r"
/*236*/
   ,"FSCK  Incorrect budmin detected in in page %s,%s.\n\r"
/*237*/
   ,"FSCK  Incorrect number of leafs detected in page %s,%s.\n\r"
/*238*/
   ,"FSCK  Incorrect number of free blocks in AG %s detected in Block Map Control \
Page.\n\r"
/*239*/
   ,"FSCK  Incorrect aggregate size detected in Block Map Control Page.\n\r"
/*240*/
   ,"FSCK  Incorrect blocks per AG detected in Block Map Control Page.\n\r"
/*241*/
   ,"FSCK  Incorrect dmap control level detected in Block Map Control Page.\n\r"
/*242*/
   ,"FSCK  Incorrect dmap control height detected in Block Map Control Page.\n\r"
/*243*/
   ,"FSCK  Incorrect dmap control width detected in Block Map Control Page.\n\r"
/*244*/
   ,"FSCK  Incorrect l2 blocks per AG detected in Block Map Control Page.\n\r"
/*245*/
   ,"FSCK  Incorrect l2 blocks per page detected in Block Map Control Page.\n\r"
/*246*/
   ,"FSCK  Incorrect maximum active AGs detected in Block Map Control Page.\n\r"
/*247*/
   ,"FSCK  Incorrect maximum level detected in Block Map Control Page.\n\r"
/*248*/
   ,"FSCK  Incorrect number of AGs detected in Block Map Control Page.\n\r"
/*249*/
   ,"FSCK  Invalid preferred AG detected in Block Map Control Page.\n\r"
/*250*/
   ,"XCHKLOG  %s superblock is valid.\n\r"
/*251*/
   ,"FSCK  Incorrect number of blocks detected in dmap %s.\n\r"
/*252*/
   ,"FSCK  Incorrect number free detected in dmap %s.\n\r"
/*253*/
   ,"FSCK  Incorrect start detected in dmap %s.\n\r"
/*254*/
   ,"FSCK  %s consecutive blocks observed available but pmap (%s, %s, %s) \
indicates they are allocated.\n\r"
/*255*/
   ,"FSCK  %s consecutive blocks observed allocated but pmap (%s, %s, %s) \
indicates they are available.\n\r"
/*256*/
   ,"FSCK  Discrepancies detected in the Block Map Control Page AG free count list.\n\r"
/*257*/
   ,"FSCK  Incorrect data detected in the Block Map Control Page.\n\r"
/*258*/
   ,"FSCK  Incorrect dmap control start index detected in Block Map Control Page.\n\r"
/*259*/
   ,"FSCK  Incorrect fwsp length detected in the superblock (%s).\n\r"
/*260*/
   ,"FSCK  Incorrect jlog address detected in the superblock (%s).\n\r"
/*261*/
   ,"FSCK  Incorrect jlog length detected in the superblock (%s).\n\r"
/*262*/
   ,"    |........\r"
/*263*/
   ,"    .|.......\r"
/*264*/
   ,"    ..|......\r"
/*265*/
   ,"    ...|.....\r"
/*266*/
   ,"    ....|....\r"
/*267*/
   ,"    .....|...\r"
/*268*/
   ,"    ......|..\r"
/*269*/
   ,"    .......|.\r"
/*270*/
   ,"    ........|\r"
/*271*/
   ,"FSCK  Directory claims cross linked block(s).\n\r"
/*272*/
   ,"FSCK  File system object claims cross linked block(s).\n\r"
/*273*/
   ,"FSCK   File system is formatted for sparse files.\n\r"
/*274*/
   ,"FSCK  Directory inode %s%s incorrect DASD used value corrected.\n\r"
/*275*/
   ,"FSCK  %s directories reconnected to /lost+found/.\n\r"
/*276*/
   ,"FSCK  %s file reconnected to /lost+found/.\n\r"
/*277*/
   ,"FSCK  %s files reconnected to /lost+found/.\n\r"
/*278*/
   ,"FSCK cannot repair the data format error(s) in this directory.\n\r"
/*279*/
   ,"FSCK cannot repair the format error(s) in this directory.\n\r"
/*280*/
   ,"FSCK cannot repair the data format error(s) in this file system object.\n\r"
/*281*/
   ,"FSCK cannot repair the format error(s) in this file system object.\n\r"
/*282*/
   ,"FSCK **Phase 7 - Verify File/Directory Allocation Maps\n\r"
/*283*/
   ,"FSCK **Phase 8 - Verify Disk Allocation Maps\n\r"
/*284*/
   ,"FSCK parameter detected:  Omit logredo()\n\r"
/*285*/
   ,"FSCK   *undefined* \n\r"
/*286*/
   ,"FSCK   *undefined* \n\r"
/*287*/
   ,"FSCK   *undefined* \n\r"
/*288*/
   ,"FSCK   *undefined* \n\r"
/*289*/
   ,"FSCK   *undefined* \n\r"
/*290*/
   ,"FSCK  Primary metadata inode %s%s is corrupt.\n\r"
/*291*/
   ,"FSCK  Secondary metadata inode %s%s is corrupt.\n\r"
/*292*/
   ,"FSCK  Secondary superblock is corrupt.\n\r"
/*293*/
   ,"FSCK  Unable to read the Secondary File/Directory Allocation Table.\n\r"
/*294*/
   ,"FSCK  Errors detected in the File System File/Directory Allocation Map.\n\r"
/*295*/
   ,"FSCK  Errors detected in the File System File/Directory Allocation Map control information.\n\r"
/*296*/
   ,"FSCK  Errors detected in the Secondary File/Directory Allocation Table.\n\r"
/*297*/
   ,"FSCK  Unable to read secondary superblock.\n\r"
/*298*/
   ,"FSCK   *undefined* \n\r"
/*299*/
   ,"FSCK   *undefined* \n\r"
/*300*/
   ,"FSCK   *undefined* \n\r"
/*301*/
   ,"FSCK  MINOR: Unable to reconnect %s directories.  Continuing.\n\r"
/*302*/
   ,"FSCK  MINOR: Unable to reconnect %s file.  Continuing.\n\r"
/*303*/
   ,"FSCK  MINOR: Unable to reconnect %s files.  Continuing.\n\r"
/*304*/
   ,"FSCK   *undefined* \n\r"
/*305*/
   ,"FSCK   *undefined* \n\r"
/*306*/
   ,"FSCK   *undefined* \n\r"
/*307*/
   ,"FSCK   *undefined* \n\r"
/*308*/
   ,"FSCK   *undefined* \n\r"
/*309*/
   ,"FSCK  Directory inode %s%s has been reconnected to /lost+found/.\n\r"
/*310*/
   ,"FSCK  MINOR: Unable to reconnect directory inode %s%s.  Continuing.\n\r"
/*311*/
   ,"FSCK   *undefined* \n\r"
/*312*/
   ,"FSCK  Unable to read either superblock.\n\r"
/*313*/
   ,"%s kilobytes total disk space.\n\r"
/*314*/
   ,"%s kilobytes in %s directories.\n\r"
/*315*/
   ,"%s kilobytes in %s user files.\n\r"
/*316*/
   ,"%s kilobytes in extended attributes\n\r"
/*317*/
   ,"%s kilobytes reserved for system use.\n\r"
/*318*/
   ,"%s kilobytes are available for use.\n\r"
/*319*/
   ,"XCHKDMP Can't read input file:  %s\n\r"
/*320*/
   ,"XCHKDMP Input file (%s) not recognized as an extracted JFS fsck service log.\n\r"
/*321*/
   ,"XCHKLOG %s superblock is valid.\n\r"
/*322*/
   ,"XCHKLOG  Output file path and name must be less than 128 characters.\n\r"
/*323*/
   ,"XCHKDMP  Input file path and name must be less than 128 characters.\n\r"
/*324*/
   ,"FSCK  Unable to read the Primary File/Directory Allocation Table.\n\r"
/*325*/
  ,"FSCK  Errors detected in the Primary File/Directory Allocation Table.\n\r"
/*326*/
   ,"FSCK CANNOT CONTINUE.\n\r"
/*327*/
   ,"********** FSCK CANNOT INITIALIZE THIS SERVICE LOG.  DISREGARD RESIDUAL LOG \
MESSAGES WHICH MAY BE APPENDED. **********\n\r"
/*328*/
   ,"CHKLOG  Required parameter missing:  device specification\n\r"
/*329*/
   ,"XCHKLOG  Required parameter missing:  device specification\n\r"
/*330*/
   ,"FSCK parameter detected:  FixLevel: %s\n\r"
/*331*/
   ,"FSCK parameter detected:  IfDirty\n\r"
/*332*/
   ,"FSCK parameter detected:  VerboseMessaging\n\r"
/*333*/
   ,"FSCK parameter detected:  AutoCheck mode\n\r"
/*334*/
   ,"FSCK parameter detected:  PMchkdsk mode\n\r"
/*335*/
   ,"FSCK parameter detected:  Debug mode\n\r"
/*336*/
   ,"FSCK  CHKDSK.SYS returned %s bytes of high memory at %s\n\r"
/*337*/
   ,"FSCK  Open(CHKDSK.SYS,...) returned rc = %s\n\r"
/*338*/
   ,"FSCK  IOCtl( ... ) to call CHKDSK.SYS returned rc = %s, data.rc = %s\n\r"
/*339*/
   ,"FSCK  ujfs_beginformat() returned rc = %s\n\r"
/*340*/
   ,"FSCK parameter detected:  Clear LVM Bad Block List\n\r"
/*341*/
   ,"FSCK (JFSCTL_CHKDSK, ... ) returned rc = %s\n\r"
/*342*/
   ,"FSCK   FSCK warning: The LVM has detected bad blocks in the partition.  \
Run FSCK /B to transfer entries from the LVM bad block table to the JFS bad \
block table.\n\r"
/*343*/
   ,"FSCK   LVM GetBadBlockInformation returned rc = %s\n\r"
/*344*/
   ,"FSCK   LVM GetTableSize rc = %s\n\r"
/*345*/
   ,"FSCK  THE FILE SYSTEM IS NOW AVAILABLE.\n\r"
/*346*/
   ,"FSCK  Transferring entries from the LVM Bad Block Table for this file \
system to the JFS Bad Block Table for this file system.\n\r"
/*347*/
   ,"FSCK   INTERNAL ERROR (%s,%s,%s,%s). FSCK CANNOT CONTINUE.\n\r"
/*348*/
   ,"FSCK   CLRBBLKS:  relocated %s extents, for total %s relocated blocks.\n\r"
/*349*/
   ,"FSCK   CLRBBLKS: LVM List #%s  num entries = %s  num active entries = %s\n\r"
/*350*/
   ,"FSCK   CLRBBLKS: number of LVM Lists = %s\n\r"
/*351*/
   ,"FSCK   CLRBBLKS: Attempted to relocate bad blocks in range %s to %s.\n\r"
/*352*/
   ,"FSCK   LVM reports %s bad blocks.  Of these, %s have been transferred to \
the JFS Bad Block List.\n\r"
/*353*/
   ,"FSCK   CLRBBLKS rc = %s\n\r"
/*354*/
   ,"FSCK   DosExecPgm(...clrbblks...) rc = %s\n\r"
/*355*/
   ,"FSCK  Open(...OPEN_SHARE_DENYNONE|OPEN_ACCESS_READWRITE...) returned rc = %s\n\r"
/*356*/
   ,"FSCK  Device unavailable or locked by another process.  FSCK CANNOT CONTINUE.\n\r"
/*357*/
   ,"FSCK  File system object %s%s%s has a node with an invalid self field.\n\r"
/*358*/
   ,"FSCK  File system object %s%s%s is illegally linked as: %s\n\r"
/*359*/
   ,"FSCK  Insufficient storage (%s) available to continue reconnecting \
lost files and/or directories. Continuing.\n\r"
/*360*/
   ,"FSCK  Format error in Access Control List space or descriptor.\n\r"
/*361*/
   ,"FSCK  Format error in Access Control List space or descriptor. Will clear.\n\r"
/*362*/
   ,"FSCK  Storage allocated to Access Control List for inode \
%s%s has been cleared.\n\r"
/*363*/
   ,"%s kilobytes in access control lists\n\r"
/*364*/
   ,"FSCK  File system is full or too fragmented to allocated requested %s blocks.\n\r"
/*365*/
   ,"FSCK  Minor format error detected.\n\r"
/*366*/
   ,"FSCK   Minor format error in inode %s%s has been corrected. \n\r"
/*367*/
   ,"FSCK  Minor format error detected. Will fix.\n\r"
/*368*/
   ,"FSCK  File system object %s%s%s has invalid length in descriptor (%s).\n\r"
/*369*/
   ,"FSCK  File system object %s%s%s has invalid offset in descriptor (%s).\n\r"
/*370*/
   ,"FSCK  File system checked READ ONLY.\n\r"
/*371*/
   ,"FSCK  Device does not exist. \n\r"
/*372*/
   ,"FSCK  No device given. \n\r"
/*373*/
   ,"FSCK   *undefined* \n\r"
/*374*/
   ,"FSCK   *undefined* \n\r"
/*375*/
   ,"FSCK   *undefined* \n\r"
/*376*/
   ,"FSCK   *undefined* \n\r"
/*377*/
   ,"FSCK   *undefined* \n\r"
/*378*/
   ,"FSCK   *undefined* \n\r"
/*379*/
   ,"FSCK   *undefined* \n\r"
/*380*/
   ,"FSCK   *undefined* \n\r"
/*381*/
   ,"FSCK   *undefined* \n\r"
/*382*/
   ,"FSCK   *undefined* \n\r"
/*383*/
   ,"FSCK   *undefined* \n\r"
/*384*/
   ,"B"
/*385*/
   ,"A"
/*386*/
   ,"D"
/*387*/
   ,"DM"
/*388*/
   ,"E"
/*389*/
   ,"F"
/*390*/
   ,"I"
/*391*/
   ,"L0"
/*392*/
   ,"L1"
/*393*/
   ,"L2"
/*394*/
   ,"M"
/*395*/
   ,"C"
/*396*/
   ,"P"
/*397*/
   ,"S"
/*398*/
   ,"L"
/*399*/
   ,".RCN\0"
/*400*/
   ,"FSCK:LOGREDO:  Log already redone! \n\r"
/*401*/
   ,"FSCK:LOGREDO:  End of log found at logend = %s\n\r"
/*402*/
   ,"FSCK:LOGREDO:  Beginning to recover File System Extend processing.\n\r"
/*403*/
   ,"FSCK:LOGREDO:  Done recovering File System Extend processing.\n\r"
/*404*/
   ,"FSCK:LOGREDO:  File System Extend recovered to prior size.\n\r"
/*405*/
   ,"FSCK:LOGREDO:  File System Extend recovered and completed.\n\r"
/*406*/
   ,"FSCK:LOGREDO:  Recovery of File System Extend failed.  Error = %s\n\r"
/*407*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid magic number. \n\r"
/*408*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid version number. \n\r"
/*409*/
   ,"FSCK:LOGREDO:  Unable to find valid end of log.\n\r"
/*410*/
   ,"FSCK:LOGREDO:  Initialization failed.  rc = %s   error num = %s\n\r"
/*411*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid block size.\n\r"
/*412*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid log2(block size).\n\r"
/*413*/
   ,"FSCK:LOGREDO:  Log superblock contains invalid log size.\n\r"
/*414*/
   ,"FSCK:LOGREDO:  Log end is not in valid range.\n\r"
/*415*/
   ,"FSCK:LOGREDO:  Synch point record number:  %s \n\r"
/*416*/
   ,"FSCK:LOGREDO:  Synch point record address:  %s \n\r"
/*417*/
   ,"FSCK:LOGREDO:  Number of log records:    %s \n\r"
/*418*/
   ,"FSCK:LOGREDO:  Number of Do blocks:    %s \n\r"
/*419*/
   ,"FSCK:LOGREDO:  Number of NoDo blocks:    %s \n\r"
/*420*/
   ,"FSCK:LOGREDO:  Log record for Sync Point at:    %s \n\r"
/*421*/
   ,"FSCK:LOGREDO:  Log record for Volume Mount at:    %s \n\r"
/*422*/
   ,"FSCK:  Calling CHKDSK.SYS to allocate high memory.... \n\r"
/*423*/
   ,"FSCK   CHKDSK.SYS returned  addr= %s  length= %s \n\r"
/*424*/
   ,"FSCK:LOGREDO:  Allocating for BMap:  %s bytes \n\r"
/*425*/
   ,"FSCK:LOGREDO:  Allocating for IMap:  %s bytes \n\r"
/*426*/
   ,"FSCK:LOGREDO:  Allocating for DoBLk:  %s bytes  \n\r"
/*427*/
   ,"FSCK:LOGREDO:  Allocating for NoReDoFile:  %s bytes  \n\r"
/*428*/
   ,"FSCK:LOGREDO:  Allocating for ReDoPage:  %s bytes  \n\r"
/*429*/
   ,"FSCK:LOGREDO:  Allocating for NoDoFile:  %s bytes  \n\r"
/*430*/
   ,"FSCK:LOGREDO:  Allocating for ExtendDtPg:  %s bytes  \n\r"
/*431*/
   ,"FSCK:LOGREDO:   Failed trying to allocate for BMap:  %s bytes \n\r"
/*432*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for IMap:  %s bytes  \n\r"
/*433*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for DoBLk:  %s bytes   \n\r"
/*434*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for NoReDoFile:  %s bytes \n\r"
/*435*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for ReDoPage:  %s bytes \n\r"
/*436*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for NoDoFile:  %s bytes \n\r"
/*437*/
   ,"FSCK:LOGREDO:  Failed trying to allocate for ExtendDtPg:  %s bytes \n\r"
/*438*/
   ,"FSCK:LOGREDO:  Working IMap will occupy storage originally allocated for BMap.\n\r"
/*439*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for NoRedoFile records.\n\r"
/*440*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for DoBLock records.\n\r"
/*441*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for RedoPage records.\n\r"
/*442*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for NoDoFile records.\n\r"
/*443*/
   ,"FSCK:LOGREDO:  Some storage allocated for BMap now used for ExtendDtPage records.\n\r"
/*444*/
   ,"FSCK:LOGREDO:  Unable to read Journal Log superblock.\n\r"
/*445*/
   ,"FSCK:LOGREDO:  Unable to update Journal Log superblock.\n\r"
/*446*/
   ,"FSCK:LOGREDO:  Address of next log record is invalid.\n\r"
/*447*/
   ,"FSCK:LOGREDO:  Address (%s) of next log record is out of range.\n\r"
/*448*/
   ,"FSCK:LOGREDO:  Address (%s) of next log record is the same as address of current log record.\n\r"
/*449*/
   ,"FSCK:LOGREDO:  The Journal Log has wrapped around and written over itself.\n\r"
/*450*/
   ,"FSCK:LOGREDO:  Invalid Commit record at %s.\n\r"
/*451*/
   ,"FSCK:LOGREDO:  Invalid Mount record at %s.\n\r"
/*452*/
   ,"FSCK:LOGREDO:  Device open/read error\n\r"
/*453*/
   ,"FSCK:LOGREDO:  Invalid RedoPage record at %s. \n\r"
/*454*/
   ,"FSCK:LOGREDO:  Invalid NoRedoPage record at %s.\n\r"
/*455*/
   ,"FSCK:LOGREDO:  Invalid NoRedoInoExt record at %s.\n\r"
/*456*/
   ,"FSCK:LOGREDO:  Invalid UpdateMap record at %s.\n\r"
/*457*/
   ,"FSCK:LOGREDO:  Unrecognized log record type at %s.\n\r"
/*458*/
   ,"FSCK:LOGREDO:  Errors encountered imply the log is corrupt.  Reformat needed.\n\r"
/*459*/
   ,"FSCK:LOGREDO:  Errors encountered prevent logredo() from continuing. \n\r"
/*460*/
   ,"FSCK:LOGREDO:  Unable to update map(s).\n\r"
/*461*/
   ,"FSCK:LOGREDO:  Unable to update file system superblock.\n\r"
/*462*/
   ,"FSCK:LOGREDO:  Unable to write to log superblock.\n\r"
/*463*/
   ,"FSCK:LOGREDO:  Unable to read file system superblock. \n\r"
/*464*/
   ,"FSCK:LOGREDO:  File system superblock has invalid magic number.\n\r"
/*465*/
   ,"FSCK:LOGREDO:  File system superblock has invalid version number.\n\r"
/*466*/
   ,"FSCK:LOGREDO:  File system superblock has invalid log location.\n\r"
/*467*/
   ,"FSCK:LOGREDO:  File system superblock has invalid log serial number.\n\r"
/*468*/
   ,"FSCK:LOGREDO:  Unable to initialize map(s).\n\r"
/*469*/
   ,"FSCK:LOGREDO:  Attempt to read file system superblock failed.\n\r"
/*470*/
   ,"FSCK:LOGREDO:  Attempt to write file system superblock failed.\n\r"
/*471*/
   ,"FSCK:LOGREDO:  Attempt to read file system primary superblock failed.\n\r"
/*472*/
   ,"FSCK:LOGREDO:  Attempt to read file system secondary superblock failed.\n\r"
/*473*/
   ,"FSCK:LOGREDO:  Attempt to write file system primary superblock failed.\n\r"
/*474*/
   ,"FSCK:LOGREDO:  Attempt to write file system secondary superblock failed.\n\r"
/*475*/
   ,"FSCK:LOGREDO:  Attempt to flush buffers failed.\n\r"
/*476*/
   ,"FSCK:LOGREDO:  Not a valid file system device number.\n\r"
/*477*/
   ,"FSCK:LOGREDO:  Journal log must be inline. \n\r"
/*478*/
   ,"FSCK:LOGREDO:  Device is not a file system device.\n\r"
/*479*/
   ,"FSCK:LOGREDO:  Journal log is not inline.\n\r"
/*480*/
   ,"FSCK:LOGREDO:  Journal log is now open.  (major = %s, minor = %s) \n\r"
/*481*/
   ,"FSCK:LOGREDO:  Error in volume %s.\n\r"
/*482*/
   ,"FSCK:LOGREDO:  Device open failed.\n\r"
/*483*/
   ,"FSCK:LOGREDO:  Failed attempting to initialize map(s).\n\r"
/*484*/
   ,"FSCK:LOGREDO:  Invalid volume block number (%s).\n\r"
/*485*/
   ,"FSCK:LOGREDO:  Invalid inode number (%s).\n\r"
/*486*/
   ,"FSCK:LOGREDO:  Failed attempt to read block %s.\n\r"
/*487*/
   ,"FSCK:LOGREDO:  I/O error attempting to read block %s.\n\r"
/*488*/
   ,"FSCK:LOGREDO:  Invalid UpdateMap record (nxd = %s). \n\r"
/*489*/
   ,"FSCK:LOGREDO:  Invalid log serial number.\n\r"
/*490*/
   ,"FSCK:LOGREDO:  Failed attempt to find the current end of the Journal Log.\n\r"
/*491*/
   ,"FSCK:LOGREDO:  Failed attempting to read the Journal Log (logaddr = %s).\n\r"
/*492*/
   ,"FSCK:LOGREDO:  Unrecognized log record type (logaddr = %s).\n\r"
/*493*/
   ,"FSCK:LOGREDO:  I/O error on Journal Log (logaddr = %s).\n\r"
/*494*/
   ,"FSCK:LOGREDO:  The Journal Log has wrapped. \n\r"
/*495*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to read file system superblock failed.\n\r"
/*496*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to read block map inode failed.\n\r"
/*497*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (1).\n\r"
/*498*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (2).\n\r"
/*499*/
   ,"FSCK:LOGREDO:  RecovExtFS: Write aggregate block %s failed (1).\n\r"
/*500*/
   ,"FSCK:LOGREDO:  RecovExtFS: Write aggregate block %s failed (2).\n\r"
/*501*/
   ,"FSCK:LOGREDO:  RecovExtFS: Write aggregate block %s failed (3).\n\r"
/*502*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (3).\n\r"
/*503*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (4).\n\r"
/*504*/
   ,"FSCK:LOGREDO:  RecovExtFS: Error in initLogredo().\n\r"
/*505*/
   ,"FSCK:LOGREDO:  RecovExtFS: Read aggregate block %s failed (5).\n\r"
/*506*/
   ,"FSCK:LOGREDO:  RecovExtFS: Write aggregate block %s failed (4).\n\r"
/*507*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to write file system superblock failed.\n\r"
/*508*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to read Journal Log superblock failed.\n\r"
/*509*/
   ,"FSCK:LOGREDO:  RecovExtFS: Attempt to write Journal Log superblock failed. \n\r"
/*510*/
   ,"FSCK:LOGREDO:   Read Block Map inode failed.\n\r"
/*511*/
   ,"FSCK:LOGREDO:   Read Block Map failed.\n\r"
/*512*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map inode failed.\n\r"
/*513*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map failed.\n\r"
/*514*/
   ,"FSCK:LOGREDO:   Read Block Map leftmost leaf failed.\n\r"
/*515*/
   ,"FSCK:LOGREDO:   Read Block Map data extents failed.\n\r"
/*516*/
   ,"FSCK:LOGREDO:   Read Block Map next leaf failed.\n\r"
/*517*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map leftmost leaf failed.\n\r"
/*518*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map control page failed.\n\r"
/*519*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map next leaf failed.\n\r"
/*520*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map data extents failed.\n\r"
/*521*/
   ,"FSCK:LOGREDO:   Read Inode Alloc Map inode failed in UpdateMaps().\n\r"
/*522*/
   ,"FSCK:LOGREDO:  Write Inode Alloc Map control page failed in UpdateMaps().\n\r"
/*523*/
   ,"FSCK:LOGREDO:  Read Block Map inode failed in UpdateMaps().\n\r"
/*524*/
   ,"FSCK:LOGREDO:  Write Block Map control page failed in UpdateMaps().\n\r"
/*525*/
   ,"FSCK:LOGREDO:  Not rebuilding the Inode Alloc Map because fsck will be doing it.\n\r"
/*526*/
   ,"FSCK:LOGREDO:  Write Inode Alloc Map, rXtree() failed.\n\r"
/*527*/
   ,"FSCK:LOGREDO:  Write block (blk=%s) failed when updating the Inode Alloc Mapl.\n\r"
/*528*/
   ,"FSCK:LOGREDO:  Read next leaf (addr=%s) failed when updating the Inode Alloc Map.\n\r"
/*529*/
   ,"FSCK:LOGREDO:  Incorrect npages detected when updating the Inode Alloc Map.\n\r"
/*530*/
   ,"FSCK:LOGREDO:  Done updating the Inode Allocation Map.\n\r"
/*531*/
   ,"FSCK:LOGREDO:  Beginning to update the Inode Allocation Map.\n\r"
/*532*/
   ,"FSCK:LOGREDO:  Done updating the Block Map.\n\r"
/*533*/
   ,"FSCK:LOGREDO:  Beginning to update the Block Map.\n\r"
/*534*/
   ,"FSCK:LOGREDO:  Not rebuilding the Block Map because fsck will be doing it.\n\r"
/*535*/
   ,"FSCK:LOGREDO:  Error for pmap and inoext when rebuilding the Inode Allocation Map (1).\n\r"
/*536*/
   ,"FSCK:LOGREDO:  Inconsistent map size in Block Map.\n\r"
/*537*/
   ,"FSCK:LOGREDO:  Incorrect leaf index detected (k=%s, j=%s, idx=%s) while writing Block Map.\n\r"
/*538*/
   ,"FSCK:LOGREDO:  Error rebuilding DMap page (k=%s, j=%s, i=%s).\n\r"
/*539*/
   ,"FSCK:LOGREDO:  rXtree() failed when called while writing Block Map.\n\r"
/*540*/
   ,"FSCK:LOGREDO:  Write block (at %s) failed while writing Block Map.\n\r"
/*541*/
   ,"FSCK:LOGREDO:  Read next leaf (at %s) failed while writing Block Map.\n\r"
/*542*/
   ,"FSCK:LOGREDO:  Incorrect total pages while writing Block Map.\n\r"
/*543*/
   ,"FSCK:LOGREDO:  Invalid leaf index detected while updating dmap page.\n\r"
/*544*/
   ,"FSCK:LOGREDO:  rXtree() Read first leaf failed.\n\r"
/*545*/
   ,"FSCK:LOGREDO:  bread() Invalid block number specified (%s).\n\r"
/*546*/
   ,"FSCK:LOGREDO:  bread() Read block (%s) failed.\n\r"
/*547*/
   ,"FSCK:LOGREDO:  Error for pmap and inoext when rebuilding the Inode Allocation Map (2).\n\r"
/*548*/
   ,"FSCK:LOGREDO:   doAfter: updatePage failed.  (logaddr = %s, rc = %s)\n\r"
/*549*/
   ,"FSCK:LOGREDO:   doAfter: markBmap failed.  (logaddr = %s, rc = %s)\n\r"
/*550*/
   ,"FSCK:LOGREDO:   doExtDtPg: bread failed.  (offset = %s, rc = %s)\n\r"
/*551*/
   ,"FSCK:LOGREDO:   doNoRedoPage: type dtpage: findPageRedo failed.  (rc = %s)\n\r"
/*552*/
   ,"FSCK:LOGREDO:   doNoRedoPage: type dtroot: findPageRedo failed.  (rc = %s)\n\r"
/*553*/
   ,"FSCK:LOGREDO:   doNoRedoPage: type xtroot: findPageRedo failed.  (rc = %s)\n\r"
/*554*/
   ,"FSCK:LOGREDO:   doNoRedoPage: type xtpage: findPageRedo failed.  (rc = %s)\n\r"
/*555*/
   ,"FSCK:LOGREDO:   doNoRedoPage: Unknown NoRedoPage record type.\n\r"
/*556*/
   ,"FSCK:LOGREDO:   doNoRedoInoExt: findPageRedo failed.  (rc = %s)\n\r"
/*557*/
   ,"FSCK:LOGREDO:   doUpdateMap: Unknown updateMap record type.\n\r"
/*558*/
   ,"FSCK:LOGREDO:   dtpg_resetFreeList: Invalid stbl entry.\n\r"
/*559*/
   ,"FSCK:LOGREDO:   dtpg_resetFreeList: Invalid slot next index.\n\r"
/*560*/
   ,"FSCK:LOGREDO:   dtrt_resetFreeList: Invalid stbl entry.\n\r"
/*561*/
   ,"FSCK:LOGREDO:   dtrt_resetFreeList: Invalid slot next index.\n\r"
/*562*/
   ,"FSCK:LOGREDO:   markBmap: Block number(s) out of range (start=%s, length=%s). \n\r"
/*563*/
   ,"FSCK:LOGREDO:   updatePage: findPageRedo failed.  (rc = %s)\n\r"
/*564*/
   ,"FSCK:LOGREDO:   updatePage: type=INODE.  Invalid segment offset. (offset = %s)\n\r"
/*565*/
   ,"FSCK:LOGREDO:   updatePage: bread failed (1).  (rc = %s)\n\r"
/*566*/
   ,"FSCK:LOGREDO:   updatePage: bread failed (2).  (rc = %s)\n\r"
/*567*/
   ,"FSCK:LOGREDO:   updatePage: bread failed (3).  (rc = %s)\n\r"
/*568*/
   ,"FSCK:LOGREDO:   updatePage: bread failed (4).  (rc = %s)\n\r"
/*569*/
   ,"FSCK:LOGREDO:   updatePage: markImap failed.  (rc = %s)\n\r"
/*570*/
   ,"FSCK:LOGREDO:   updatePage: markBmap failed.  (rc = %s)\n\r"
/*571*/
   ,"FSCK:LOGREDO:   updatePage: dtrt_resetFreeList failed.  (rc = %s)\n\r"
/*572*/
   ,"FSCK:LOGREDO:   updatePage: dtpg_resetFreeList failed.  (rc = %s)\n\r"
/*573*/
   ,"FSCK:LOGREDO:   updatePage: saveExtDtPg failed.  (rc = %s)\n\r"
/*574*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[1] failed (rc = %s).\n\r"
/*575*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[2] failed (rc = %s).\n\r"
/*576*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[3] failed (rc = %s).\n\r"
/*577*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[4] failed (rc = %s).\n\r"
/*578*/
   ,"FSCK:LOGREDO:   fineEndOfLog: pageVal[4(a)] failed (rc = %s).\n\r"
/*579*/
   ,"FSCK:LOGREDO:   pageVal: getLogpage failed (pno = %s, rc = %s).\n\r"
/*580*/
   ,"FSCK:LOGREDO:   setLogpage: Write log page failed (pno = %s, rc = %s).\n\r"
/*581*/
   ,"FSCK:LOGREDO:   logRead: Log wrapped over itself (lognumread = %s).\n\r"
/*582*/
   ,"FSCK:LOGREDO:   logRead: Read log page failed (pno = %s, rc = %s).\n\r"
/*583*/
   ,"FSCK:LOGREDO:   logRead: MoveWords[1] failed (rc = %s).\n\r"
/*584*/
   ,"FSCK:LOGREDO:   logRead: MoveWords[2] failed (rc = %s).\n\r"
/*585*/
   ,"FSCK:LOGREDO:   moveWords: getLogpage failed (pno = %s, rc = %s).\n\r"
/*586*/
   ,"FSCK  DASD Limit has been primed for directories on the volume.\n\r"    /* @F1*/
/*587*/
   ,"FSCK  DASD Used has been primed for directories on the volume.\n\r"    /* @F1*/
/*588*/
   ,"FSCK:LOGREDO:   logRead: Log data must not exceed LOGPSIZE (pno = %s).\n\r"      /* @D1 */
/*589*/
   ,"FSCK   *undefined* \n\r"
/*590*/
   ,"FSCK   *undefined* \n\r"
/*591*/
   ,"FSCK   *undefined* \n\r"
/*592*/
   ,"FSCK   *undefined* \n\r"
/*593*/
   ,"FSCK   *undefined* \n\r"
/*594*/
   ,"FSCK   *undefined* \n\r"
/*595*/
   ,"FSCK   *undefined* \n\r"
/*596*/
   ,"FSCK   *undefined* \n\r"
/*597*/
   ,"FSCK   *undefined* \n\r"
/*598*/
   ,"FSCK   *undefined* \n\r"
/*599*/
   ,"FSCK   *undefined* \n\r"
/*600*/
   ,"FSCK   No device given \n\r"
   };

#endif
