/*
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, S3 GRAPHICS, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
#include <linux/ioport.h>
#include <asm/io.h>

#include "iface.h"
#include "debug.h"

/* Get frame buffer size from VGA BIOS */ 

extern  int memsize;
unsigned int get_memsize(void)
{
	unsigned int m;

        /* If memory size provided by user */
	if (memsize)
		m = memsize * Mb;
	else 
	{
		outb(0x34, 0x3c4);    // for register CR34 (Memory Size)
		m = inb(0x3c5);
		if (m > 16 && m <= 128)
		   m = (inb(0x3c5)+1)<<19;
		else 
		{
		   outb(0x39, 0x3c4);
		   m = inb(0x3c5);
		   if (m > 16 && m <= 128)
		      m = (m + 1) << 19;
		   else if (m > 0 && m < 31)
		      m = m << 22;
		   else
		      m = 16 * Mb;
		}
	}
	DEBUG_MSG(KERN_INFO "framebuffer size = %d Mb\n", m/Mb);
	return m;
}



