/*
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, S3 GRAPHICS, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
#include <linux/config.h>
#include <linux/ioport.h>
#include <asm/io.h>

#include "tv.h"
#include "chip.h"
#include "share.h"
#include "debug.h"

/* TV Encoder Extern Function */
extern void vt1622_tv_disable(void);
extern void vt1622_tv_enable(void);
extern void load_vt1622_regs(int TVModeIndex);
extern int  vt1622_tv_encoder_identify(void);

extern void vt1622a_tv_disable(void);
extern void vt1622a_tv_enable(void);
extern void load_vt1622a_regs(int TVModeIndex);
extern int  vt1622a_tv_encoder_identify(void);


extern void SetVCLK(u32 CLK, int set_iga);
extern inline void write_reg(u8 index, u16 io_port, u8 data);
extern void write_reg_mask(u8 index, int io_port, u8 data, u8 mask);
extern int i2cWriteByte(u8 bSlaveAddress, u8 bIndex, u8 bData);
extern int i2cReadByte(u8 bSlaveAddress, u8 bIndex, u8 *pbData);
extern void set_output_path(int device, int set_iga, int output_interface);


// extern struct
extern struct chip_information  	chip_info;
extern struct tv_setting_information	tv_setting_info;


int tv_encoder_identify(void)
{
    chip_info.tv_chip_info.tv_chip_name = VT1622;
    chip_info.tv_chip_info.tv_chip_slave_addr = VT1622_TV_I2C_ADDR;
    
    if (vt1622_tv_encoder_identify()!= FAIL)
    {
        DEBUG_MSG(KERN_INFO "\n VT1622 VT1622 ! \n");  	    
	    DEBUG_MSG(KERN_INFO "\n %2d", chip_info.tv_chip_info.tv_chip_name);
	    DEBUG_MSG(KERN_INFO "\n %2d", chip_info.tv_chip_info.tv_chip_name);
        return(OK);  
    }
    
    chip_info.tv_chip_info.tv_chip_name = VT1622A;
    chip_info.tv_chip_info.tv_chip_slave_addr = VT1622A_TV_I2C_ADDR;
    
    if (vt1622a_tv_encoder_identify()!= FAIL)
    {
        DEBUG_MSG(KERN_INFO "\n VT1622A VT1622A ! \n");  	    
	    DEBUG_MSG(KERN_INFO "\n %2d", chip_info.tv_chip_info.tv_chip_name);
	    DEBUG_MSG(KERN_INFO "\n %2d", chip_info.tv_chip_info.tv_chip_name);
        return(OK);  
    }
    
   
    chip_info.tv_chip_info.tv_chip_name = NON_TV_ENCODER;
    chip_info.tv_chip_info.tv_chip_slave_addr = NON_TV_ENCODER;  
    return(FAIL);
}  

void tv_disable(void)
{

     // Disable HW Reset
     //outb(0x17,VIACR);outb(0x63,VIACR+1);	
     outb(0x6b,VIACR);outb(0,VIACR+1);      // clear CR6B=0
     outb(0x6c,VIACR);outb(0,VIACR+1);      // clear CR6C=0
     
     switch(chip_info.tv_chip_info.tv_chip_name) {
        case VT1622:
                vt1622_tv_disable();
                break;
        case VT1622A:
                vt1622a_tv_disable();
                break;
     }
     
    
} 

void tv_load_timing_init(void)
{
    switch(chip_info.tv_chip_info.tv_chip_name) {
        
        case VT1622:
                break;                
        case VT1622A:
                break;
     }    
} 

void tv_load_timing(int TVModeIndex)
{
        
    
    switch(chip_info.tv_chip_info.tv_chip_name) {
        case VT1622:
                load_vt1622_regs(TVModeIndex);
                break;
        case VT1622A:
                load_vt1622a_regs(TVModeIndex);
                break;
    }
                                              
}

void tv_load_timing_modify(void)
{
     switch(chip_info.tv_chip_info.tv_chip_name) {
        case VT1622:
                break;
        case VT1622A:
                break;
  
    }
}

void tv_patch(void)
{
}

void tv_enable(void)
{
    
    switch(tv_setting_info.iga_path) 
    {
        case IGA1:
            set_output_path(DEVICE_TV, IGA1, chip_info.tv_chip_info.output_interface);       
            break;
        case IGA2:
            set_output_path(DEVICE_TV, IGA1, chip_info.tv_chip_info.output_interface);
            break;        
        case IGA1_IGA2:
            break;    
 
    }
 
       
    switch(chip_info.tv_chip_info.tv_chip_name) {
        case VT1622:
                vt1622_tv_enable();
		break;
        case VT1622A:
                 vt1622a_tv_enable();
                break;
     }
   
}

void tv_register_write(int index, u8 data)
{
    i2cWriteByte(chip_info.tv_chip_info.tv_chip_slave_addr, index, data);        
}  

int tv_register_read(int index)
{
    u8 data;
    int status;
    
    status = i2cReadByte(chip_info.tv_chip_info.tv_chip_slave_addr, index, &data);    
    return(data); 
}

void load_tv_output_signal(u16 *tv_func_reg)
{
    int i=0;

    while(tv_func_reg[i]!= 0xFFFF)
    { 
        tv_register_write(GET_LOW_BYTE(tv_func_reg[i]),GET_HIGH_BYTE(tv_func_reg[i]));
        i++;
    }
   
}


/* TV Set Mode */
void tv_set_mode(int video_index)
{
    tv_encoder_identify();
    tv_disable();
    tv_load_timing_init();
    tv_load_timing(video_index);
    tv_load_timing_modify();
    tv_patch();
    tv_enable();
  
  
}
