/*
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, S3 GRAPHICS, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */
 
#ifndef __TV_H__
#define __TV_H__

#include <linux/ioport.h>
#include <asm/io.h>

// Definition TV System 
#define     NTSC    1
#define     PAL     2

// Definition TV Ouput Signal
#define     TV_OUTPUT_COMPOSITE                 1
#define     TV_OUTPUT_SVIDEO                    2
#define     TV_OUTPUT_COMPOSITE_SVIDEO          3
#define     TV_OUTPUT_RGB                       4
#define     TV_OUTPUT_YPBPR                     5
#define     TV_OUTPUT_RGB_COMPOSITE             6
#define     TV_OUTPUT_YPBPR_COMPOSITE           7
#define     TV_OUTPUT_SDTV_PROGRESSIVE_RGB      8
#define     TV_OUTPUT_SDTV_PROGRESSIVE_YPBPR    9
#define     TV_OUTPUT_HDTV_720P_RGB             10
#define     TV_OUTPUT_HDTV_720P_YPBPR           11
#define     TV_OUTPUT_HDTV_1080I_RGB            12
#define     TV_OUTPUT_HDTV_1080I_YPBPR          13
#define     TV_OUTPUT_HDTV_1080P_RGB            14
#define     TV_OUTPUT_HDTV_1080P_YPBPR          15
#define     TV_OUTPUT_DEDOTCRAWL                16    


 
// Define TV Function Index
#define TV_BASE_FUNC                0
#define TV_RGB_FUNC                 1
#define TV_YPBPR_FUNC               2
#define TV_SDTV_RGB_FUNC            3
#define TV_SDTV_YPBPR_FUNC          4
#define TV_HDTV_720P_RGB_FUNC       5
#define TV_HDTV_720P_YPBPR_FUNC     6
#define TV_HDTV_1080I_RGB_FUNC      7
#define TV_HDTV_1080I_YPBPR_FUNC    8
#define TV_HDTV_1080P_RGB_FUNC      9
#define TV_HDTV_1080P_YPBPR_FUNC    10
#define TV_DeDotCrawl_FUNC          11  




#define NUM_CRTC_TIMING		    12

/* TV Table Relative Definition */
//#define     TV_ENCODER_REG_NUM          75              // number of setting register of tv encoder in TV table
#define     VT1622A_REG_NUM             75
                  
#define     GFX_IGA1_CRT_NUM            14              // number of setting CRTC's registers on IGA1 in TV table
#define     GFX_IGA2_CRT_NUM            16              // number of setting CRTC's registers on IGA2 in TV table

// define TV DeDotCrawl Register
#define     VT1622_DEDOTCRAWL_REG       0x11
#define     VT1622A_DEDOTCRAWL_REG      0x11

//define TV Version register
#define     VT1622_VERSION_REG          0x1B
#define     VT1622_VERSION              0x03

#define     VT1622A_VERSION_REG         0x1B
#define     VT1622A_VERSION             0x10            

// Define TV DAC
#define     VT1622_DAC_REG              0x0E
#define     VT1622_DAC_A                BIT3
#define     VT1622_DAC_B                BIT2
#define     VT1622_DAC_C                BIT1
#define     VT1622_DAC_D                BIT0

#define     VT1622A_DAC_REG             0x0E
#define     VT1622A_DAC_A               BIT3
#define     VT1622A_DAC_B               BIT2
#define     VT1622A_DAC_C               BIT1
#define     VT1622A_DAC_D               BIT0



 

/* TV MACRO */
#define     GET_HIGH_BYTE(x)       (unsigned char)((x) >> 8)
#define     GET_LOW_BYTE(x)        (unsigned char)((x) & 0x00FF)  



/* TV Common Function */
int  tv_encoder_identify(void);
void tv_disable(void);
void tv_load_timing_init(void);
void tv_load_timing(int TVModeIndex);
void tv_load_timing_modify(void);
void tv_patch(void);
void tv_enable(void);
void tv_register_write(int, u8);
int tv_register_read(int);

#endif /* __TV_H__ */
  
