/*
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * VIA, S3 GRAPHICS, AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __VIAMODE_H__
#define __VIAMODE_H__

//#include "hw.h"
#include "share.h"


struct VPITTable {
  unsigned char  Misc;
  unsigned char  SR[StdSR];
  unsigned char  GR[StdGR];
  unsigned char  AR[StdAR];
};

struct io_reg{
  int   port;
  u8    index;
  u8    mask;
  u8    value;
};

struct VideoModeTable {
  int                               ModeIndex;
  struct crt_mode_table             *crtc;
  int                               mode_array;  
};

struct patch_table {
  int           mode_index;  
  int           table_length;
  struct io_reg *io_reg_table;
};

struct res_map_refresh {
  int		hres;
  int		vres;
  int		pixclock;
  int		vmode_refresh;
};

struct res_map_refresh res_map_refresh_tbl[] = {
//hres, vres, vclock, vmode_refresh 	
  {640, 480, RES_640X480_60HZ_PIXCLOCK,   60},
  {640, 480, RES_640X480_75HZ_PIXCLOCK,   75},
  {640, 480, RES_640X480_85HZ_PIXCLOCK,   85},
  {640, 480, RES_640X480_100HZ_PIXCLOCK,  100},
  {640, 480, RES_640X480_120HZ_PIXCLOCK,  120},
  {720, 480, RES_720X480_60HZ_PIXCLOCK,   60},
  {720, 576, RES_720X576_60HZ_PIXCLOCK,   60},
  {800, 600, RES_800X600_60HZ_PIXCLOCK,   60},
  {800, 600, RES_800X600_75HZ_PIXCLOCK,   75},
  {800, 600, RES_800X600_85HZ_PIXCLOCK,   85},
  {800, 600, RES_800X600_100HZ_PIXCLOCK,  100},
  {800, 600, RES_800X600_120HZ_PIXCLOCK,  120},
  {848, 480, RES_848X480_60HZ_PIXCLOCK,   60},
  {856, 480, RES_856X480_60HZ_PIXCLOCK,   60},
  {1024,512, RES_1024X512_60HZ_PIXCLOCK,  60},
  {1024,768, RES_1024X768_60HZ_PIXCLOCK,  60},
  {1024,768, RES_1024X768_75HZ_PIXCLOCK,  75},
  {1024,768, RES_1024X768_85HZ_PIXCLOCK,  85},
  {1024,768, RES_1024X768_100HZ_PIXCLOCK, 100},
  {1152,864, RES_1152X864_70HZ_PIXCLOCK,  70},
  {1152,864, RES_1152X864_75HZ_PIXCLOCK,  75},
  {1280,768, RES_1280X768_60HZ_PIXCLOCK,  60},
  {1280,960, RES_1280X960_60HZ_PIXCLOCK,  60},
  {1280,1024,RES_1280X1024_60HZ_PIXCLOCK, 60},
  {1280,1024,RES_1280X1024_75HZ_PIXCLOCK, 75},
  {1280,1024,RES_1280X768_85HZ_PIXCLOCK,  85},
  {1440,1050,RES_1440X1050_60HZ_PIXCLOCK, 60},
  {1600,1200,RES_1600X1200_60HZ_PIXCLOCK, 60},
  {1600,1200,RES_1600X1200_75HZ_PIXCLOCK, 75}
};
#define NUM_TOTAL_RES_MAP_REFRESH ARRAY_SIZE(res_map_refresh_tbl)


/* Video Mode Table */
/* Common Setting for Video Mode */
struct io_reg CLE266_ModeXregs[] = {
  {VIASR,0x1E,0xF0,0xF0},	
  {VIASR,0x2A,0x0F,0x0F},	
  {VIASR,0x15,0x02,0x02},
  {VIASR,0x16,0xBF,0x08},
  {VIASR,0x17,0xFF,0x1F},
  {VIASR,0x18,0xFF,0x4E},
  {VIASR,0x1A,0xFB,0x08},

  {VIACR,0x32,0xFF,0x00},
  {VIACR,0x33,0xFF,0x08}, // for K800 prefetch mode
  {VIACR,0x34,0xFF,0x00},
  {VIACR,0x35,0xFF,0x00},
  {VIACR,0x36,0x08,0x00},
  {VIACR,0x6A,0xFF,0xC0},

  {VIAGR,0x20,0xFF,0x00},
  {VIAGR,0x21,0xFF,0x00},
  {VIAGR,0x22,0xFF,0x00},
                            // LCD Parameters   
  {VIACR,0x7A,0xFF,0x01},   // LCD Parameter 1
  {VIACR,0x7B,0xFF,0x02},   // LCD Parameter 2
  {VIACR,0x7C,0xFF,0x03},   // LCD Parameter 3
  {VIACR,0x7D,0xFF,0x04},   // LCD Parameter 4
  {VIACR,0x7E,0xFF,0x07},   // LCD Parameter 5
  {VIACR,0x7F,0xFF,0x0A},   // LCD Parameter 6
  {VIACR,0x80,0xFF,0x0D},   // LCD Parameter 7
  {VIACR,0x81,0xFF,0x13},   // LCD Parameter 8
  {VIACR,0x82,0xFF,0x16},   // LCD Parameter 9
  {VIACR,0x83,0xFF,0x19},   // LCD Parameter 10
  {VIACR,0x84,0xFF,0x1C},   // LCD Parameter 11
  {VIACR,0x85,0xFF,0x1D},   // LCD Parameter 12
  {VIACR,0x86,0xFF,0x1E},   // LCD Parameter 13
  {VIACR,0x87,0xFF,0x1F},   // LCD Parameter 14
  
};

#define NUM_TOTAL_ModeXregs ARRAY_SIZE(CLE266_ModeXregs)


/* Mode:1024X768 */
static struct io_reg PM1024x768[] __initdata={
  {VIASR,0x16,0xBF,0x0C},
  {VIASR,0x18,0xFF,0x4C}
};

struct patch_table res_patch_table[]= {
  {VIA_RES_1024X768, ARRAY_SIZE(PM1024x768), PM1024x768}
};
#define NUM_TOTAL_PATCH_MODE ARRAY_SIZE(res_patch_table)

// struct VPITTable {
//  unsigned char  Misc;
//  unsigned char  SR[StdSR];
//  unsigned char  CR[StdCR];
//  unsigned char  GR[StdGR];
//  unsigned char  AR[StdAR];
// };

struct VPITTable VPIT = {
    // Msic
    0xC7,
    // Sequencer
    {0x01,0x0F,0x00,0x0E },
    // Graphic Controller
    {0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x0F,0xFF},
    // Attribute Controller
    {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
     0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
	 0x01,0x00,0x0F,0x00}
};

/********************/
/* Mode Table       */       
/********************/

static struct crt_mode_table CRTM640x480[] __initdata = {
  //r_rate,vlck,     HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_25_175M ,{800, 640, 648, 144, 656, 96,  525, 480, 480, 29,  490, 2}},
  //{ 72,CLK_31_500M ,{832, 640, 648, 176, 664, 40,  520, 480, 480, 24,  489, 3}},
  { 75,CLK_31_500M ,{840, 640, 640, 200, 656, 64,  500, 480, 480, 20,  481, 3}},
  { 85,CLK_36_000M ,{832, 640, 640, 192, 696, 56,  509, 480, 480, 29,  481, 3}},
  {100,CLK_43_163M ,{848, 640, 640, 208, 680, 64,  509, 480, 480, 29,  481, 3}}, //GTF
  {120,CLK_52_406M ,{848, 640, 640, 208, 680, 64,  515, 480, 480, 35,  481, 3}}  //GTF
  
};

//720x480 (GTF)
static struct crt_mode_table CRTM720x480[] __initdata = {
  //r_rate,vlck,      HT, HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_26_880M ,{896, 720, 720, 176, 736, 72,  497, 480, 480, 17,  481, 3}}
  
};

//720x576 (GTF)
static struct crt_mode_table CRTM720x576[] __initdata = {
  //r_rate,vlck,     HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_32_668M ,{912, 720, 720, 192, 744, 72,  597, 576, 576, 21,  577, 3}}
};

//800x480 (GTF)
/*static struct crt_mode_table CRTM800x480[] __initdata = {
  //r_rate,vlck,     HT,  HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_29_581M ,{992, 800, 800, 192, 816, 80,  497, 480, 480, 17,  481, 3}}
  
};*/


static struct crt_mode_table CRTM800x600[] __initdata = {
  //r_rate,vlck,     HT,   HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_40_000M ,{1056, 800, 800, 256, 840, 128, 628, 600, 600, 28,  601, 4}},
  //{ 72,CLK_50_000M ,{1040, 800, 800, 240, 856, 120, 666, 600, 600, 66,  637, 6}},
  { 75,CLK_49_500M ,{1056, 800, 800, 256, 816, 80,  625, 600, 600, 25,  601, 3}},
  { 85,CLK_56_250M ,{1048, 800, 800, 248, 832, 64,  631, 600, 600, 31,  601, 3}},
  {100,CLK_68_179M ,{1072, 800, 800, 272, 848, 88,  636, 600, 600, 36,  601, 3}}, //GTF
  {120,CLK_83_950M ,{1088, 800, 800, 288, 856, 88,  643, 600, 600, 43,  601, 3}}  //GTF
};

//848x480 (GTF)
static struct crt_mode_table CRTM848x480[] __initdata = {
  //r_rate,vlck,     HT,   HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_31_490M ,{1056, 848, 848, 208, 864, 88,  497, 480, 480, 17,  481, 3}}
  
};

//856x480 (GTF) convert to 852x480 
static struct crt_mode_table CRTM852x480[] __initdata = {
  //r_rate,vlck,     HT,   HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_31_728M ,{1064, 856, 856, 208, 872, 88,  497, 480, 480, 17,  481, 3}}
  
};

//1024x512 (GTF) 
static struct crt_mode_table CRTM1024x512[] __initdata = {
  //r_rate,vlck,     HT,   HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_41_291M ,{1296, 1024,1024,272, 1056,104, 531, 512, 512, 19,  513, 3}}
  
};

//1024x576 (GTF) 
/*static struct crt_mode_table CRTM1024x576[] __initdata = {
  //r_rate,vlck,     HT,   HA,  HBS, HBE, HSS, HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_46_996M ,{1312, 1024,1024,288, 1064,104, 597, 576, 576, 21,  577, 3}}
  
};*/

static struct crt_mode_table CRTM1024x768[] __initdata = {
  //r_rate,vlck,      HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_65_000M ,{1344, 1024, 1024, 320, 1048, 136, 806, 768, 768, 38,  771, 6}},
  //{ 70,CLK_75_000M ,{1328, 1024, 1024, 304, 1048, 136, 806, 768, 768, 38,  771, 6}},
  { 75,CLK_78_750M ,{1312, 1024, 1024, 288, 1040, 96,  800, 768, 768, 32,  769, 3}},
  { 85,CLK_94_500M ,{1376, 1024, 1024, 352, 1072, 96,  808, 768, 768, 40,  769, 3}},
  {100,CLK_133_308M,{1392, 1024, 1024, 368, 1096, 112, 814, 768, 768, 40,  769, 3}} //GTF
};

static struct crt_mode_table CRTM1152x864[] __initdata = {
  //r_rate,vlck,      HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 75,CLK_108_000M ,{1600, 1152,1152, 448, 1216, 128, 900, 864, 864, 36,  865, 3}}
  
};

//1280x768 (GTF)
static struct crt_mode_table CRTM1280x768[] __initdata = {
  //r_rate,vlck,     HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_80_136M ,{1680,1280, 1280, 400, 1344, 136, 795, 768, 768, 27,  769, 3}}
};

static struct crt_mode_table CRTM1280x960[] __initdata = {
  //r_rate,vlck,      HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_108_000M ,{1800,1280, 1280, 520, 1376, 112, 1000,960, 960, 40,  961, 3}} 
  //{ 85,CLK_148_500M ,{1728,1280, 1280, 448, 1344, 160, 1011,960, 960, 51,  961, 3}}
};

static struct crt_mode_table CRTM1280x1024[] __initdata = {
  //r_rate,vlck,      HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_108_000M ,{1688,1280, 1280, 408, 1328, 112, 1066,1024,1024,42,  1025,3}},
  { 75,CLK_135_000M ,{1688,1280, 1280, 408, 1296, 144, 1066,1024,1024,42,  1025,3}},
  { 85,CLK_157_500M ,{1728,1280, 1280, 448, 1344, 160, 1072,1024,1024,48,  1025,3}}
};

//1368x768 (GTF)
/*static struct crt_mode_table CRTM1368x768[] __initdata = {
  //r_rate,vlck,     HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_85_860M ,{1800,1368, 1368, 432, 1440, 144, 795, 768, 768, 27,  769, 3}}
};*/

//1440x1050 (GTF)
static struct crt_mode_table CRTM1440x1050[] __initdata = {
  //r_rate,vlck,      HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_125_104M ,{1936,1440, 1440, 496, 1536, 152, 1077,1040,1040,37,  1041,3}}
};

static struct crt_mode_table CRTM1600x1200[] __initdata = {
  //r_rate,vlck,      HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_162_000M ,{2160,1600, 1600, 560, 1664, 192, 1250,1200,1200,50,  1201,3}},
  { 75,CLK_202_500M ,{2160,1600, 1600, 560, 1664, 192, 1250,1200,1200,50,  1201,3}}
  
};

static struct crt_mode_table CRTM1920x1440[] __initdata = {
  //r_rate,vlck,      HT,  HA,   HBS,  HBE, HSS,  HSE, VT,  VA,  VBS, VBE, VSS, VSE
  { 60,CLK_234_000M ,{2600,1920, 1920, 680, 2048, 208, 1500,1440,1440,60,  1441,3}},
  { 75,CLK_297_500M ,{2640,1920, 1920, 720, 2064, 224, 1500,1440,1440,60,  1441,3}}
  
};

/* Video Mode Table */
// struct VideoModeTable {
//  int                               ModeIndex;
//  struct crt_mode_table             *crtc;
//  int                               mode_array;  
// };    
struct VideoModeTable CLE266Modes[] __initdata= {
   /* Display : 640x480 */
   { VIA_RES_640X480,  CRTM640x480, ARRAY_SIZE(CRTM640x480)},
   
   /* Display : 720x480 (GTF)*/
   { VIA_RES_720X480,  CRTM720x480, ARRAY_SIZE(CRTM720x480)},
   
   /* Display : 720x576 (GTF)*/
   { VIA_RES_720X576,  CRTM720x576, ARRAY_SIZE(CRTM720x576)},

   /* Display : 800x600 */
   { VIA_RES_800X600,  CRTM800x600, ARRAY_SIZE(CRTM800x600)},
   
   /* Display : 800x480 (GTF)*/
  //{ M800x480,  CRTM800x480, ARRAY_SIZE(CRTM800x480)},
   
   /* Display : 848x480 (GTF)*/
   { VIA_RES_848X480,  CRTM848x480, ARRAY_SIZE(CRTM848x480)},
   
   /* Display : 852x480 (GTF)*/
   { VIA_RES_856X480,  CRTM852x480, ARRAY_SIZE(CRTM852x480)},
   
   /* Display : 1024x512 (GTF)*/
   { VIA_RES_1024X512, CRTM1024x512, ARRAY_SIZE(CRTM1024x512)},
   
    /* Display : 1024x576 (GTF)*/
   //{ VIA_RES_1024X576, CRTM1024x576, ARRAY_SIZE(CRTM1024x576)},

   /* Display : 1024x768 */
   { VIA_RES_1024X768, CRTM1024x768, ARRAY_SIZE(CRTM1024x768)},
   
   /* Display : 1152x864 */
   { VIA_RES_1152X864, CRTM1152x864, ARRAY_SIZE(CRTM1152x864)},
   
   /* Display : 1280x768 (GTF)*/
   { VIA_RES_1280X768, CRTM1280x768, ARRAY_SIZE(CRTM1280x768)},
   
   /* Display : 1280x800 (GTF)*/
   //{ M1280x800, CRTM1280x800, ARRAY_SIZE(CRTM1280x800)},
   
   /* Display : 1280x960 */
   { VIA_RES_1280X960, CRTM1280x960, ARRAY_SIZE(CRTM1280x960)},
   
   /* Display : 1280x1024 */
   { VIA_RES_1280X1024, CRTM1280x1024,ARRAY_SIZE(CRTM1280x1024)},
   
   /* Display : 1368x768 (GTF)*/
   //{ M1368x768,CRTM1368x768,ARRAY_SIZE(CRTM1368x768)},
   
   /* Display : 1440x1050 (GTF)*/
   { VIA_RES_1440X1050, CRTM1440x1050, ARRAY_SIZE(CRTM1440x1050)},
   
   /* Display : 1600x1200 */
   { VIA_RES_1600X1200, CRTM1600x1200, ARRAY_SIZE(CRTM1600x1200)},
   
   /* Display : 1920x1440 */
   { VIA_RES_1920X1440, CRTM1920x1440, ARRAY_SIZE(CRTM1920x1440)}
};

#define NUM_TOTAL_MODETABLE ARRAY_SIZE(CLE266Modes)


#endif /* __VIAMODE_H__ */
