/*
 * Copyright (C) 2004 Zaheer Abbas Merali <zaheerabbas at merali.org>
 *                    Mahmood Rehemtulla  <mhr at blueyonder.co.uk>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#ifndef _GSTSAVE_GSTSTUFF_H
#define _GSTSAVE_GSTSTUFF_H

#include "config.h"

#include <gst/gst.h>

#include <gtk/gtk.h>

struct pipeline_elements
{
  GHashTable* table;
  GstElement *pipeline;
  GstElement *vis_thread;
  GstElement *tee, *tee2, *src, *sink1, *sinkweb, *enc1, *enc2;
  GstElement *sink2, *enc3, *sink3;
  GstElement *s2m, *vis, *queue, *color, *vsink;
  GstPad *tee1_src1, *tee1_src2, *tee1_src3, *tee1_src4, *tee2_src1, *tee2_src2, *tee1_src5;
  GstElement* level;
  GstElement* filedec;
  GstElement* audiosink,  *listen_thread, *listen_queue, *tee3;
  GstElement* record_thread, *record_queue;
  GstElement* webcast_encoder_thread, *webcast_encoder_queue;
  GstElement* tempas1, *tempas2, *tempac1, *tempac2, *tempas3, *tempas4;
};

struct gstsave_gui;

struct stream_details
{
  struct gstsave_gui* gsgui;
  struct pipeline_elements* pe;
  char* recordstream_fname;
  char* webcaststream_fname;
  char* wavstream_fname;
  gboolean gui;
  int curcounter;
  int active;
  int sub_stream_status[6];
  char* dirname;
  int mode[2];
  int bitrate[2];
  int quality[2];
  char* iceip;
  int iceport;
  char* icemount;
  char* icepass;
  GIOChannel* ioc;
  GMainLoop* mainloop;
  char datestr[256];
  char* str;
  char* audiosrc;
  char* audiodevice;
  char* webcastserver;
  char* recordtype;
  char* webcasttype;
  char* visplugin;
  char* config_fname;
  GHashTable* relays;
};


#define FNSIZE 256

/* gst methods */
static void level_callback (GstElement * element, gdouble time, gint channel,
    gdouble rms, gdouble peak, gdouble decay, gpointer user_data);
GstElement *element_create (char *name, char *element);
gboolean continue_pipeline(gpointer data);
/* substream start and stops */
int stop_record_stream(struct stream_details* sd);
int stop_webcast_record_substream2(struct stream_details* sd);
int stop_webcast_substream(struct stream_details* sd);
int stop_visualisation_substream(struct stream_details* sd);
int stop_wav_substream1(struct stream_details* sd);
int stop_listen_substream(struct stream_details* sd);
int add_record_stream(struct stream_details* sd);
int add_webcast_record_stream(struct stream_details* sd, gboolean start);
int add_webcast_substream(struct stream_details* sd,gboolean start);
int add_visualisation_substream(struct stream_details* sd);
int add_wav_substream1(struct stream_details* sd);
int add_listen_substream(struct stream_details* sd);
int switch_file(struct stream_details* sd);

void acast_init(struct stream_details* sd);
int do_live_stream (struct stream_details* sd);


#endif
