/*
 * Copyright (C) 2004 Zaheer Abbas Merali <zaheerabbas at merali.org>
 *                    Mahmood Rehemtulla  <mhr at blueyonder.co.uk>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <glib.h>

#include "parser.h"
#include "gststuff.h"
#include "relay.h"

int acast_parse_configfile(struct stream_details* sd)
{
	xmlDocPtr doc;
	xmlNodePtr curnode,tempnode;
	xmlChar* temp = NULL;
	
	doc=xmlParseFile(sd->config_fname);
	
	if (doc==NULL) {
    	g_print("Config file not valid: %s\n",sd->config_fname);
        return -1;
	}
                                                                                
  curnode=xmlDocGetRootElement(doc);
                                                                                
  if (curnode == NULL) {
        g_print("Config file empty: %s\n",sd->config_fname);
        xmlFreeDoc(doc);
        return -1;
  }
  
  if (xmlStrcasecmp(curnode->name, (const xmlChar *) "acast")) {
        g_print("Config file of the wrong type: %s\n",sd->config_fname);
        xmlFreeDoc(doc);
        return -1;
  }
  
  curnode=curnode->xmlChildrenNode;
  
  while (curnode!=NULL) {
  	if (!xmlStrcasecmp(curnode->name, (const xmlChar*) "directory")) {
  		temp = xmlNodeGetContent(curnode);
  		sd->dirname=g_strdup(temp);
  		xmlFree(temp);
  	}
  	else if (!xmlStrcasecmp(curnode->name, (const xmlChar*) "basefile")) {
  		temp = xmlNodeGetContent(curnode);
  		sd->str=g_strdup(temp);
  		xmlFree(temp);
  	}
  	else if (!xmlStrcasecmp(curnode->name, (const xmlChar*) "visualisation")) {
  		g_print("Visualisation\n");
  		tempnode=curnode->xmlChildrenNode;
  		while (tempnode!=NULL) {
  			if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "plugin")) {
  				temp = xmlNodeGetContent(tempnode);
  				sd->visplugin=g_strdup(temp);
		  		xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name,(const xmlChar*) "active")) {
  				temp=xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"yes")) {
  					sd->sub_stream_status[3]=1;
  				}
  				else {
  					sd->sub_stream_status[3]=0;
  				}
  				xmlFree(temp);
  			}
  			tempnode=tempnode->next;
  		}
  	}
  	else if (!xmlStrcasecmp(curnode->name, (const xmlChar*) "recordstream")) {
  		g_print("Record Stream\n");
  		tempnode=curnode->xmlChildrenNode;
  		while(tempnode!=NULL) {
  			if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "type")) {
  				//g_print("Type: %s\n",xmlNodeGetContent(tempnode));
  				/* for the moment, we will assume mp3 and ignore this option */
  				temp = xmlNodeGetContent(tempnode);
  				sd->recordtype=g_strdup(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "bitrate")) {
  				temp = xmlNodeGetContent(tempnode);
  				sd->bitrate[0]=atoi(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "channels")) {
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"stereo")) {
  					sd->mode[0]=0;
  				}
  				else if (!xmlStrcasecmp(temp,"mono")) {
  					sd->mode[0]=3;
  				}
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "active")) {
  				//g_print("Active: %s\n",xmlNodeGetContent(tempnode));
  				/* For the moment, ignore */
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"yes")) {
  					sd->sub_stream_status[0]=1;
  				}
  				else {
  					sd->sub_stream_status[0]=0;
  				}
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "quality")) {
  				temp = xmlNodeGetContent(tempnode);
  				sd->quality[0]=atoi(temp);
  				xmlFree(temp);
  			}
  			tempnode=tempnode->next;
  		}
  	}
  	else if (!xmlStrcasecmp(curnode->name, (const xmlChar*) "webcaststream")) {
  		g_print("Webcast Stream\n");
  		tempnode=curnode->xmlChildrenNode;
  		while(tempnode!=NULL) {
  			if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "server")) {
  				//g_print("Type: %s\n",xmlNodeGetContent(tempnode));
  				/* for the moment, we will assume mp3 and ignore this option */
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"icecast2")) {
  				#ifdef HAVE_SHOUT2
  					sd->webcastserver=g_strdup("icecast2");
  				#else
  					sd->webcastserver=g_strdup("icecast1");
  				#endif
  				}
  				else {
  					sd->webcastserver=g_strdup(temp);
  				}
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "type")) {
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"ogg")) {
  				#ifdef HAVE_SHOUT2
  					sd->webcasttype=g_strdup("ogg");
  				#else
  					sd->webcasttype=g_strdup("mp3");
  				#endif
  				}
  				else {
  					sd->webcasttype=g_strdup(temp);
  				}
  				xmlFree(temp);
  			}
  				
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "bitrate")) {
  				temp = xmlNodeGetContent(tempnode);
  				sd->bitrate[1]=atoi(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "channels")) {
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"stereo")) {
  					sd->mode[1]=0;
  				}
  				else if (!xmlStrcasecmp(temp,"mono")) {
  					sd->mode[1]=3;
  				}
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "record")) {
  				//g_print("Record: %s\n",xmlNodeGetContent(tempnode));
  				/* temporarily ignore */
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"yes")) {
  					sd->sub_stream_status[1]=1;
  				}
  				else {
  					sd->sub_stream_status[1]=0;
  				}
  				xmlFree(temp);
  				
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "active")) {
  				//g_print("Active: %s\n",xmlNodeGetContent(tempnode));
  				/* temporarily ignore */
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"yes")) {
  					sd->sub_stream_status[2]=1;
  				}
  				else {
  					sd->sub_stream_status[2]=0;
  				}
  				xmlFree(temp);
  				
  			} 
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "ip")) {
  				temp=xmlNodeGetContent(tempnode);
  				sd->iceip=g_strdup(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "port")) {
				temp=xmlNodeGetContent(tempnode);
				sd->iceport=atoi(temp);
				xmlFree(temp);
			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "mount")) {
  				temp=xmlNodeGetContent(tempnode);
  				sd->icemount=g_strdup(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "password")) {
  				temp=xmlNodeGetContent(tempnode);
  				sd->icepass=g_strdup(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "quality")) {
  				temp = xmlNodeGetContent(tempnode);
  				sd->quality[1]=atoi(temp);
  				xmlFree(temp);
  			}
  			
  			tempnode=tempnode->next;
  		}
  	}
  	else if (!xmlStrcasecmp(curnode->name, (const xmlChar*) "wavestream")) {
  		g_print("Wave Stream\n");
  		tempnode=curnode->xmlChildrenNode;
  		while(tempnode!=NULL) {
  			if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "active")) {
  				//g_print("Active: %s\n",xmlNodeGetContent(tempnode));
  				/* temporarily ignore */
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"yes")) {
  					sd->sub_stream_status[4]=1;
  				}
  				else {
  					sd->sub_stream_status[4]=0;
  				}
  				xmlFree(temp);
  			}
  			tempnode=tempnode->next;
  		}
  	}
  	else if (!xmlStrcasecmp(curnode->name, (const xmlChar*) "input")) {
  		g_print("Audio Input\n");
  		tempnode=curnode->xmlChildrenNode;
  		while(tempnode!=NULL) {
  			if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "type")) {
  				//g_print("Type: %s\n",xmlNodeGetContent(tempnode));
  				/* for the moment, we will assume oss and ignore this option */
  				temp=xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"oss")) {
  					sd->audiosrc=g_strdup("osssrc");
  				}
  				else if (!xmlStrcasecmp(temp,"alsa")) {
  					sd->audiosrc=g_strdup("alsasrc");
  				}
  				else if (!xmlStrcasecmp(temp,"file")) {
  					sd->audiosrc=g_strdup("filesrc");
  				}
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "device")) {
  				temp=xmlNodeGetContent(tempnode);
  				sd->audiodevice=g_strdup(temp);
  				xmlFree(temp);
  			}
  			tempnode=tempnode->next;
  		}
  	}
	else if (!xmlStrcasecmp(curnode->name, (const xmlChar*) "relay")) {
		gchar *ip, *mount, *password, *name, *servertype, *webcasttype;
		gint port, bitrate, channels;

		ip=mount=password=name=servertype=webcasttype=NULL;
		port=bitrate=channels=0;
				tempnode=curnode->xmlChildrenNode;
		while (tempnode!=NULL) {
			temp=xmlNodeGetContent(tempnode);
			if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "server")) {
  				//g_print("Type: %s\n",xmlNodeGetContent(tempnode));
  				/* for the moment, we will assume mp3 and ignore this option */
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"icecast2")) {
#ifdef HAVE_SHOUT2
  					servertype=g_strdup("icecast2");
#else
  					servertype=g_strdup("icecast1");
#endif
  				}
  				else {
  					servertype=g_strdup(temp);
  				}
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "type")) {
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"ogg")) {
#ifdef HAVE_SHOUT2
  					webcasttype=g_strdup("ogg");
#else
  					webcasttype=g_strdup("mp3");
#endif
  				}
  				else {
  					webcasttype=g_strdup(temp);
  				}
  				xmlFree(temp);
  			}
  				
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "bitrate")) {
  				temp = xmlNodeGetContent(tempnode);
  				bitrate=atoi(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "channels")) {
  				temp = xmlNodeGetContent(tempnode);
  				if (!xmlStrcasecmp(temp,"stereo")) {
  					channels=2;
  				}
  				else if (!xmlStrcasecmp(temp,"mono")) {
  					channels=1;
  				}
  				xmlFree(temp);
  			}

			if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "ip")) {
  				temp=xmlNodeGetContent(tempnode);
  				ip=g_strdup(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "port")) {
				temp=xmlNodeGetContent(tempnode);
				port=atoi(temp);
				xmlFree(temp);
			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "mount")) {
  				temp=xmlNodeGetContent(tempnode);
  				mount=g_strdup(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "password")) {
  				temp=xmlNodeGetContent(tempnode);
  				password=g_strdup(temp);
  				xmlFree(temp);
  			}
  			else if (!xmlStrcasecmp(tempnode->name, (const xmlChar*) "name")) {
  				temp=xmlNodeGetContent(tempnode);
  				name=g_strdup(temp);
  				xmlFree(temp);
  			}

			tempnode=tempnode->next;
		}
		if (name!=NULL && ip!=NULL && mount!=NULL && password!=NULL && webcasttype!=NULL && servertype!=NULL && port>0 && bitrate>0 && channels>0) {
			acast_add_relay(sd, name, ip, port, mount, password, servertype, webcasttype, bitrate, channels);
			g_print("relay added\n");
		}

		
	}
  	else if (!xmlStrcasecmp(curnode->name, (const xmlChar*) "active")) {
  		temp=xmlNodeGetContent(curnode);
  		if (!xmlStrcasecmp(temp,"yes")) {
  			sd->active=1;
  		}
  		else {
  			sd->active=0;
  		}
  		xmlFree(temp);
  	}
  	curnode=curnode->next;
  }
  
  xmlFreeDoc(doc);
	
}
