# Note that this is NOT a relocatable package
%define ver     0.9.9
%define rel     0
%define prefix  /usr
%define name    xine-lib

Name:        %{name}
Summary:     A Free Video Player.
Summary(ko):   ÷̾
Version:     %{ver}
Release:     %{rel}
Copyright:   GPL
Group:       Development/Libraries
Source:      http://xine.sourceforge.net/files/xine-lib-0.9.9.tar.gz
URL:         http://xine.sourceforge.net
Packager:    Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
Requires:    zlib
BuildRoot:   /tmp/%{name}-root

%package oss
Summary:     XINE - oss support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}

%package alsa09
Summary:     XINE - alsa >= 0.9.x support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}

%package arts
Summary:     XINE - arts support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}

%package esd
Summary:     XINE - esd support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}, esound

#%package dxr3
#Summary:     XINE - DXR3 support.
#Group:       Development/Libraries
#Requires:    xine-lib >= %{ver}

%package xv
Summary:     XINE - XFree XVideo support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}

%package sdl
Summary:     XINE - SDL (Simple DirectMedia Layer) video support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}, libSDL

%package aa
Summary:     XINE - Ascii Art support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}

%package opengl
Summary:     XINE - OpenGL support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}

%package w32dll
Summary:     XINE - win32dll decoder support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}

%package oggvorbis
Summary:     XINE - ogg/vorbis decoder/demuxer support.
Group:       Development/Libraries
Requires:    xine-lib >= %{ver}, libogg, libvorbis

%package docs
Summary:     XINE - html API documentation.
Group:       Documentation

%description
xine is a free gpl-licensed video player for unix-like systems.
We support mpeg-2 and mpeg-1 system (audio + video multiplexed) streams,
eventually mpeg-4 and other formats might be added.

xine plays the video and audio data of mpeg-2 videos and synchronizes
the playback of both. Depending on the properties of the mpeg stream,
playback will need more or less processor power, 100% frame rate
has been seen on a 400 MHz P II system.

%description -l fr
xine est un lecteur vido libre sous license GPL pour les systmes de
type unix. Nous supportons les flux mpeg-2 et mpeg-1 (audio + vido 
multiplexs), ventuellement le mpeg-4 et d'autres formats peuvent
tres ajouts.

xine joue les donnes vido et audio de vido mpeg-2 et synchronise
la lecture des deux. En fonction des proprites du flux mpeg,
la lecture aura besoin de plus ou moins de puissance du processeur, 
100% de restitution de trame a t vus sur un systme PII 400MHz.

%description -l ko
xine  GPL̼  UNIX   ÷̾Դϴ. 
÷̾ mpeg-2  mpeg 1 Ʈ ϸ,  
 ߿ mpeg-4  ٸ    Դϴ.

%description -l pt
O xine  um leitor de vdeo livre ao abrigo da GPL para sistemas tipo 
Unix. L ficheiros MPEG-2 e MPEG-1, bem como AVIs que contenham
MS MPEG-4 / OpenDivX Video.

O xine l o contedo vdeo e udio e sincroniza-os em tempo-real. As 
necessidades de processador dependem das propriedades de cada ficheiro.
Em princpio, um sistema equipado com um Pentium-II a 400 MHz consegue 
ler qualquer vdeo com mximo desempenho.

%description oss
audio plugin with oss support.

%description alsa09
audio plugin with alsa >= 0.9.x support.

%description arts
audio plugin with arts support.

%description esd
audio plugin with esd support.

#%description dxr3
#video/decoder plugins for DXR3 card support.

%description xv
video plugin using XFree XVideo extension.

%description sdl
video plugin using SDL (Simple DirectMedia Layer) library.

%description aa
video plugin using Ascii Art library.

%description opengl
video plugin using OpenGL library.

%description w32dll
win32dll decoder support.

%description oggvorbis
ogg/vorbis decoder/demuxer support.

%description docs
HTML documentation of XINE API.

%prep
%setup -n xine-lib-0.9.9

%build
./configure --prefix=%{prefix}
make

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -rf $RPM_BUILD_ROOT; fi
#mkdir -p $RPM_BUILD_ROOT/usr/include/X11/pixmaps
make install-strip DESTDIR=$RPM_BUILD_ROOT LIBRARY_PATH=$RPM_BUILD_ROOT%{prefix}/lib
#cp doc/*.xpm $RPM_BUILD_ROOT/usr/include/X11/pixmaps

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{prefix}/bin/xine-config
%{prefix}/man/man1/xine-config.1*
%{prefix}/man/man3/xine-lib.3*
%{prefix}/man/man3/ao_driver_t.3*
%{prefix}/man/man3/ao_functions_t.3*
%{prefix}/man/man3/demux_strategy.3*
%{prefix}/man/man3/video_cap.3*
%{prefix}/man/man3/vo_overlay_t.3*
%{prefix}/man/man3/autoplay_group.3*
%{prefix}/man/man3/event_group.3*
%{prefix}/man/man3/video_group.3*
%{prefix}/man/man3/xine.h.3*
%{prefix}/man/man3/browse_group.3*
%{prefix}/man/man3/loadplugins_group.3*
%{prefix}/man/man3/video_prop.3*
%{prefix}/man/man3/xine_api.3*
%{prefix}/man/man3/build_info.3*
%{prefix}/man/man3/mrl_t.3*
%{prefix}/man/man3/video_ratio.3*
%{prefix}/man/man3/xine_init.3*
%{prefix}/man/man3/cfg_data_t.3*
%{prefix}/man/man3/mrl_types.3*
%{prefix}/man/man3/visual_types.3*
%{prefix}/man/man3/xine_management.3*
%{prefix}/man/man3/config_group.3*
%{prefix}/man/man3/status_group.3*
%{prefix}/man/man3/vo_driver_s.3*
%{prefix}/man/man3/xine_t.3*
%{prefix}/man/man3/config_values_s.3*
%{prefix}/man/man3/ui_callbacks.3*
%{prefix}/man/man3/vo_driver_t.3*
%{prefix}/man/man3/xine_version.3*
%{prefix}/man/man3/config_values_t.3*
%{prefix}/man/man3/version_group.3*
%{prefix}/man/man3/vo_frame_t.3*
%{prefix}/man/man3/audio_cap.3*
%{prefix}/man/man3/audio_group.3*
%{prefix}/man/man3/audio_prop.3*
%{prefix}/include/xine/*.h
%{prefix}/include/xine.h
#/xine.m4
# input plugins
%{prefix}/lib/xine/plugins/xineplug_inp_dvd.la
%{prefix}/lib/xine/plugins/xineplug_inp_dvd.so
%{prefix}/lib/xine/plugins/xineplug_inp_file.la
%{prefix}/lib/xine/plugins/xineplug_inp_file.so
%{prefix}/lib/xine/plugins/xineplug_inp_http.la
%{prefix}/lib/xine/plugins/xineplug_inp_http.so
%{prefix}/lib/xine/plugins/xineplug_inp_mms.la
%{prefix}/lib/xine/plugins/xineplug_inp_mms.so
%{prefix}/lib/xine/plugins/xineplug_inp_net.la
%{prefix}/lib/xine/plugins/xineplug_inp_net.so
%{prefix}/lib/xine/plugins/xineplug_inp_rtp.la
%{prefix}/lib/xine/plugins/xineplug_inp_rtp.so
%{prefix}/lib/xine/plugins/xineplug_inp_stdin_fifo.la
%{prefix}/lib/xine/plugins/xineplug_inp_stdin_fifo.so
%{prefix}/lib/xine/plugins/xineplug_inp_vcd.la
%{prefix}/lib/xine/plugins/xineplug_inp_vcd.so
%{prefix}/lib/xine/plugins/xineplug_inp_cda.la
%{prefix}/lib/xine/plugins/xineplug_inp_cda.so
# demuxer plugins
%{prefix}/lib/xine/plugins/xineplug_dmx_asf.la
%{prefix}/lib/xine/plugins/xineplug_dmx_asf.so
%{prefix}/lib/xine/plugins/xineplug_dmx_avi.la
%{prefix}/lib/xine/plugins/xineplug_dmx_avi.so
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg.la
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg.so
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_audio.la
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_audio.so
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_block.la
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_block.so
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_elem.la
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_elem.so
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_pes.la
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_pes.so
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_ts.la
%{prefix}/lib/xine/plugins/xineplug_dmx_mpeg_ts.so
%{prefix}/lib/xine/plugins/xineplug_dmx_qt.la
%{prefix}/lib/xine/plugins/xineplug_dmx_qt.so
%{prefix}/lib/xine/plugins/xineplug_dmx_cda.la
%{prefix}/lib/xine/plugins/xineplug_dmx_cda.so
# decoder plugins
%{prefix}/lib/xine/plugins/xineplug_decode_a52.la
%{prefix}/lib/xine/plugins/xineplug_decode_a52.so
%{prefix}/lib/xine/plugins/xineplug_decode_ff.so
%{prefix}/lib/xine/plugins/xineplug_decode_ff.la
%{prefix}/lib/xine/plugins/xineplug_decode_lpcm.so
%{prefix}/lib/xine/plugins/xineplug_decode_lpcm.la
%{prefix}/lib/xine/plugins/xineplug_decode_mad.so
%{prefix}/lib/xine/plugins/xineplug_decode_mad.la
%{prefix}/lib/xine/plugins/xineplug_decode_mpeg2.la
%{prefix}/lib/xine/plugins/xineplug_decode_mpeg2.so
#%{prefix}/lib/xine/plugins/xineplug_decode_mpg123.la
#%{prefix}/lib/xine/plugins/xineplug_decode_mpg123.so
%{prefix}/lib/xine/plugins/xineplug_decode_spu.la
%{prefix}/lib/xine/plugins/xineplug_decode_spu.so
%{prefix}/lib/xine/plugins/xineplug_decode_spucc.la
%{prefix}/lib/xine/plugins/xineplug_decode_spucc.so
%{prefix}/lib/xine/plugins/xineplug_decode_sputext.la
%{prefix}/lib/xine/plugins/xineplug_decode_sputext.so
%{prefix}/lib/xine/plugins/xineplug_decode_dts.la
%{prefix}/lib/xine/plugins/xineplug_decode_dts.so
#%{prefix}/lib/xine/plugins/xineplug_decode_vfill.la
#%{prefix}/lib/xine/plugins/xineplug_decode_vfill.so
%{prefix}/lib/xine/plugins/xineplug_decode_divx4.la
%{prefix}/lib/xine/plugins/xineplug_decode_divx4.so
# audio driver plugins
# see other packages.
#
# video driver plugins
%{prefix}/lib/xine/plugins/xineplug_vo_out_syncfb.la
%{prefix}/lib/xine/plugins/xineplug_vo_out_syncfb.so
%{prefix}/lib/xine/plugins/xineplug_vo_out_xshm.la
%{prefix}/lib/xine/plugins/xineplug_vo_out_xshm.so
# lib, logo and fonts.
%{prefix}/bin/xine-logoconv
%{prefix}/lib/libxine*.la
%{prefix}/lib/libxine*.so*
%{prefix}/share/xine/skins/xine_logo.png
%{prefix}/share/xine/skins/xine_logo.zyuy2
%{prefix}/share/xine/fonts/*
## intl files
%{prefix}/share/locale/fr/LC_MESSAGES/xine-lib.mo
%{prefix}/share/locale/de/LC_MESSAGES/xine-lib.mo
%{prefix}/share/locale/pt_BR/LC_MESSAGES/xine-lib.mo
%{prefix}/share/locale/sk/LC_MESSAGES/xine-lib.mo
%{prefix}/share/locale/es/LC_MESSAGES/xine-lib.mo

%files oss
%defattr(-,root,root)
%{prefix}/lib/xine/plugins/xineplug_ao_out_oss.la
%{prefix}/lib/xine/plugins/xineplug_ao_out_oss.so

%files alsa09
%defattr(-,root,root)
%{prefix}/lib/xine/plugins/xineplug_ao_out_alsa.la
%{prefix}/lib/xine/plugins/xineplug_ao_out_alsa.so

%files arts
%defattr(-,root,root)
%{prefix}/lib/xine/plugins/xineplug_ao_out_arts.la
%{prefix}/lib/xine/plugins/xineplug_ao_out_arts.so

%files esd
%defattr(-,root,root)
%{prefix}/lib/xine/plugins/xineplug_ao_out_esd.la
%{prefix}/lib/xine/plugins/xineplug_ao_out_esd.so

#%files dxr3
#%defattr(-,root,root)
#%{prefix}/lib/xine/plugins/xineplug_decode_dxr3.la
#%{prefix}/lib/xine/plugins/xineplug_decode_dxr3.so
#%{prefix}/lib/xine/plugins/xineplug_vo_out_dxr3.la
#%{prefix}/lib/xine/plugins/xineplug_vo_out_dxr3.so
#%{prefix}/include/dxr3_video_out.h
#%{prefix}/include/dxr3_vo_encoder.h

%files xv
%defattr(-,root,root)
%{prefix}/lib/xine/plugins/xineplug_vo_out_xv.la
%{prefix}/lib/xine/plugins/xineplug_vo_out_xv.so

%files sdl
%defattr(-,root,root)
%{prefix}/lib/xine/plugins/xineplug_vo_out_sdl.la
%{prefix}/lib/xine/plugins/xineplug_vo_out_sdl.so

%files aa
%defattr(-,root,root)
%{prefix}/lib/xine/plugins/xineplug_vo_out_aa.la
%{prefix}/lib/xine/plugins/xineplug_vo_out_aa.so

%files opengl
%defattr(-,root,root)
%{prefix}/lib/xine/plugins/xineplug_vo_out_opengl.la
%{prefix}/lib/xine/plugins/xineplug_vo_out_opengl.so

%files w32dll
%defattr(-,root,root)
%{prefix}/lib/xine/plugins/xineplug_decode_w32dll.la
%{prefix}/lib/xine/plugins/xineplug_decode_w32dll.so

%files oggvorbis
%{prefix}/lib/xine/plugins/xineplug_dmx_ogg.la
%{prefix}/lib/xine/plugins/xineplug_dmx_ogg.so
%{prefix}/lib/xine/plugins/xineplug_decode_vorbis.la
%{prefix}/lib/xine/plugins/xineplug_decode_vorbis.so


%files docs
%defattr(-,root,root)
%{prefix}/share/doc/xine/xine-lib-API/*

%changelog
* Sun Mar 31 2002 Matthias Dahl <matthew2k@web.de>
- added mms input plugin, spucc decoder and missing xine_logo.zyuy2.
- commented out video fill decoder for now as it seems to be no longer built
* Wed Feb 6 2002 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- added 'de,fr,pt_BR' translation catalogs.
* Sat Dec 26 2001 Matthias Dahl <matthew2k@web.de>
- added sputext decode plugin and fonts.
* Sat Dec 8 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- ASF plugin is optional.
* Thu Dec 6 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add cda plugins.
* Wed Nov 14 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- fixed dxr3 header files inclusion, aalib deps: thanks to Andrew Meredith <andrew@anvil.org>.
* Mon Oct 29 2001 Matthias Dahl <matthew2k@web.de>
- added http input plugin
* Thu Oct 18 2001 Matthias Dahl <matthew2k@web.de>
- added asf demuxer plugin
* Sun Oct 14 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- move vorbis in separate package. Add DivX4 decoder plugin.
* Wed Oct 10 2001 Matthias Dahl <matthew2k@web.de>
- added vorbis files and missing man pages to filelist.
* Thu Sep 27 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add desktop stuff from patches by Miguel Freitas <miguel@cetuc.puc-rio.br>
- Fixed xine.m4 installation from Andrew Meredith <andrew@anvil.org>
* Fri Sep 21 2001 Matthias Dahl <matthew2k@web.de>
- added two missing files (xine-config man page and xine.m4)
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Merge patch from Jos Carlos Monteiro <jcm@netcabo.pt>:
  - Filelist and other minor updates,
  - Fixed some SuSE compatibility issues,
  - Added Portuguese summary.
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add missing files.
* Sun Aug 19 2001 Matthias Dahl <matthew2k@web.de>
- The usual update to the filelist :)
- temporarily removed mpg123 decoder plugin from filelist cause it is not
  built with the recent CVS tree
* Thu Jul 26 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Made oss, aa, xv, esd, w32dll, documentation as separate packages.
* Thu Jul 26 2001 Matthias Dahl <matthew2k@web.de>
- added seperate arts package and one missing demuxer plugin to filelist
* Wed Jul 18 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- list all plugins to avoid *strange* inclusion ;-).
* Sun Jun 10 2001 Matthias Dahl <matthew2k@web.de>
- updated filelist
- re-activated execution of /sbin/ldconfig as post install script
* Thu Mar 28 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- add korean summary, patch from Louis JANG <louis@ns.mizi.com>
* Thu Jan 11 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- patch from Sung-Hyun Nam <namsh@lgic.co.kr> applied.
* Fri Oct 17 2000 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- first spec file.
