#!/bin/sh

if [ -z "$1" ]; then
  echo "Usage: update.sh /path/to/boost/tree"
  echo "Example: update.sh ~/boost_1_33_0"
  exit
fi

find boost -type f ! -regex '.*/\(\.\|CVS/\|Makefile\|SConscript\).*' -exec \
sh -c "if [ -e '$1/{}' ]; then cp -fp '$1/{}' '{}'; chmod u+w '{}'; else rm -f '{}'; fi" \;

for dst_dir in `find libs -type d -mindepth 1 -maxdepth 1 ! -name CVS`; do
  src_dir="$1/$dst_dir/src"
  for fname in `find $dst_dir -type f ! -regex '.*/\(\.\|CVS/\|Makefile\|SConscript\).*' -printf "%P\n"`; do
    src="$src_dir/$fname"
    dst="$dst_dir/$fname"
    if [ -e "$src" ]; then
      cp -fp "$src" "$dst"
      chmod u+w "$dst"
    else
      rm -f "$dst"
    fi
  done
done
