/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NfaChar.h"

NfaChar::NfaChar(uint8_t ch)
{
	m_states[0].setSymbolTransition(ch, 1);
}

NfaChar::~NfaChar()
{
}

int
NfaChar::length() const
{
    return 1;
}

NfaState const*
NfaChar::statesBegin() const
{
    return m_states;
}

NfaState const*
NfaChar::statesEnd() const
{
    return m_states + 2;
}

int
NfaChar::getStartPos() const
{
    return 0;
}

int
NfaChar::getFinishPos() const
{
    return 1;
}
