/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ASYNCCONNECTION_H_
#define ASYNCCONNECTION_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "AsyncConnectionListener.h"
#include "Reactor.h"
#include "EventHandler.h"
#include "InetAddr.h"
#include <ace/SOCK_Stream.h>
#include <ace/Time_Value.h>

class AsyncConnection : public EventHandlerBase
{
	DECLARE_NON_COPYABLE(AsyncConnection)
public:
	enum Status { NOT_CONNECTED, IN_PROGRESS, ESTABLISHED };
	
	AsyncConnection();
	
	~AsyncConnection();
	
	void setListener(AsyncConnectionListener* listener) { m_pListener = listener; }
	
	void removeListener() { m_pListener = 0; }
	
	void initiate(Reactor& reactor, InetAddr const& addr,
		ACE_Time_Value const* timeout = 0);
	
	void abort();
	
	Status getStatus() const { return m_status; }
	
	InetAddr const& getAddress() const { return m_addr; }
	
	bool isSameAddress(InetAddr const& addr) const { return addr == m_addr; }
	
	ACE_SOCK_Stream& peer() { return m_peer; }
	
	void setTcpNoDelay() { setTcpNoDelay(peer()); }
	
	static void setTcpNoDelay(ACE_SOCK_Stream& strm);
protected:
	virtual void onNewConnection() {}
private:
	virtual void handleRead(ACE_HANDLE);
	
	virtual void handleWrite(ACE_HANDLE);
	
	virtual void handleExcept(ACE_HANDLE);
	
	virtual void handleTimeout(ReactorTimerId const&);
	
	virtual void ref();
	
	virtual bool unref();
	
	void unregisterHandlers();
	
	void handleCompletion();
	
	void onConnEstablished();
	
	void onConnFailed(AsyncConnectionListener::FailureCode code, int errnum);

	AsyncConnectionListener* m_pListener;
	Status m_status;
	InetAddr m_addr;
	ACE_SOCK_Stream m_peer;
	Reactor* m_pReactor;
	ReactorHandlerId m_handlerId;
	ReactorTimerId m_timerId;
	int m_refCounter;
};

#endif
