/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "Date.h"
#include "SBOutStream.h"
#include "SplittableBuffer.h"
#include "BString.h"
#include <ace/OS_NS_time.h>

using namespace std;

BString
Date::formatCurrentTime(Style style)
{
	static char const wdays[][4] = {
		"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
	};
	static char const months[][4] = {
		"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
	};
	
	if (style == RFC822) {
		// We can't just use strftime here,
		// because its output is locale-dependent.
		time_t tt = time(NULL);
		struct tm tmval = {};
		ACE_OS::gmtime_r(&tt, &tmval);
		SBOutStream strm(30); // chunk size
		strm.fill('0');
		strm.width(2);
		strm << wdays[tmval.tm_wday] << ", ";
		strm << tmval.tm_mday << ' ';
		strm << months[tmval.tm_mon] << ' ';
		strm << (1900 + tmval.tm_year) << ' ';
		strm << tmval.tm_hour << ':';
		strm << tmval.tm_min << ':';
		strm << tmval.tm_sec << " GMT";
		return strm.data().toBString();
	}
	return BString();
}
