/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ERRORDESCRIPTOR_H_
#define ERRORDESCRIPTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "CraftedResponse.h"
#include "CraftedResponseGenerator.h"
#include "ErrorCodes.h"
#include <string>
#include <memory>

class ErrorDescriptor
{
public:
	ErrorDescriptor(int code, std::string const& message,
		CraftedResponseGenerator const& generator);
	
	ErrorDescriptor(CraftedResponseGenerator const& generator);
	
	ErrorDescriptor(int code, std::string const& message);
	
	ErrorDescriptor(int code);
	
	~ErrorDescriptor();
	
	int getErrorCode() const { return m_errorCode; }
	
	std::string const& getErrorMessage() const { return m_errorMessage; }
	
	CraftedResponseGenerator& responseGenerator() { return m_responseGenerator; }
private:
	int m_errorCode;
	std::string m_errorMessage;
	CraftedResponseGenerator m_responseGenerator;
};

#endif
