/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ERRORRESPONSE_H_
#define ERRORRESPONSE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <memory>
#include <string>
#include <map>

class CraftedResponse;
class SplittableBuffer;
class BString;

class ErrorResponse
{
public:
	static std::auto_ptr<CraftedResponse> errConnectionFailed(
		std::string url, std::string host, int port, char const* syserr);
	
	static std::auto_ptr<CraftedResponse> errConnectionTimeout(
		std::string url, std::string host, int port);
	
	static std::auto_ptr<CraftedResponse> errHostNameResolution(
		std::string url, std::string host);
	
	static std::auto_ptr<CraftedResponse> errServerTimeout(std::string url);
	
	static std::auto_ptr<CraftedResponse> errParsingRequest(std::string url, std::string problem);
	
	static std::auto_ptr<CraftedResponse> errParsingResponse(std::string url, std::string problem);
	
	static std::auto_ptr<CraftedResponse> errUnsupportedProtocol(std::string url, std::string protocol);
	
	static std::auto_ptr<CraftedResponse> errUnsupportedMethod(std::string url, std::string method);
	
	static std::auto_ptr<CraftedResponse> errExpectationFailed(std::string url, std::string expectation);
	
	static std::auto_ptr<CraftedResponse> errGenericError(std::string url, std::string error, int status_code);
	
	static std::auto_ptr<CraftedResponse> errUrlForbidden(std::string url);
	
	static std::auto_ptr<CraftedResponse> errDummyError();
private:
	typedef std::map<BString, std::string> MacroMap;
	
	static void prepareCommonMacros(MacroMap& m);
	
	static void prepareBody(SplittableBuffer& body,
		char const* templ[], MacroMap const& macros);
	
	static std::string getFullHostName();
};

#endif
