/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef FILTERTRYLIST_H_
#define FILTERTRYLIST_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "IntrusivePtr.h"
#include "SharedPtr.h"
#include "RegexFilterDescriptor.h"
#include <sigc++/sigc++.h>
#include <deque>

class ResponseFilterChain;
class HttpResponseMetadata;
class RegexFilterDescriptor;

class FilterTryList
{
public:
	enum ContentType { CTYPE_OTHER, CTYPE_HTML, CTYPE_XHTML };
	
	typedef sigc::slot<void, ResponseFilterChain&, HttpResponseMetadata const&> FilterConstructor;
	typedef SharedPtr<FilterConstructor, ACE_NULL_SYNCH> FilterConstructorPtr;
	
	FilterTryList();
	
	~FilterTryList();
	
	void append(FilterConstructorPtr const& ctor) { m_constructors.push_back(ctor); }
	
	void prepend(FilterConstructorPtr const& ctor) { m_constructors.push_front(ctor); }
	
	bool empty() const { return m_constructors.empty(); }
	
	FilterConstructorPtr& front() { return m_constructors.front(); }
	
	void shift() { return m_constructors.pop_front(); }
	
	void clear() { m_constructors.clear(); }
	
	static ContentType resolveContentType(HttpResponseMetadata const& metadata);
	
	static bool isContentFilterApplicable(
		ResponseFilterChain& chain, HttpResponseMetadata const& metadata);
	
	static bool isHtmlFilterApplicable(
		ResponseFilterChain& chain,
		HttpResponseMetadata const& metadata, ContentType* ctype = 0);
	
	static void tryHtmlFilter(
		ResponseFilterChain& chain, HttpResponseMetadata const& metadata);
	
	static void tryAnalyzeFilter(
		ResponseFilterChain& chain, HttpResponseMetadata const& metadata,
		bool ignore_size);
	
	static void tryRegexFilter(
		ResponseFilterChain& chain, HttpResponseMetadata const& metadata,
		IntrusivePtr<RegexFilterDescriptor const> filter_desc);
	
	static void tryCompressorFilter(
		ResponseFilterChain& chain, HttpResponseMetadata const& metadata);
	
	static void ensureTransferEncodingUnderstood(
		ResponseFilterChain& chain, HttpResponseMetadata const& metadata);
	
	static void ensureContentEncodingUnderstood(
		ResponseFilterChain& chain, HttpResponseMetadata const& metadata);
	
	static bool removeAllEncodings(
		ResponseFilterChain& chain, HttpResponseMetadata const& metadata);
private:
	std::deque<FilterConstructorPtr> m_constructors;
};

#endif
