/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2004  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef WORKERTHREADPOOL_H_
#define WORKERTHREADPOOL_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "RefCountableSAP.h"
#include "IntrusivePtr.h"
#include <ace/SOCK_Stream.h>
#include <ace/Thread_Manager.h>
#include <ace/Synch.h>
#include <ace/Time_Value.h>
#include <deque>
#include <list>
#include <utility>

class Reactor;
class ACE_INET_Addr;

class WorkerThreadPool
{
public:
	typedef IntrusivePtr<RefCountableSAP<ACE_SOCK_Stream> > SocketPtr;
	
	WorkerThreadPool();
	
	~WorkerThreadPool();
	
	void handleConnection(
		SocketPtr const& socket, ACE_INET_Addr const& client_addr);
private:
	enum { WAIT_FOR_NEW_TASK = 10 }; // seconds
	enum { WAITERS_KEEP_ALIVE = 4 };
	
	typedef std::pair<SocketPtr, ACE_INET_Addr> Connection;
	typedef ACE_Thread_Mutex Mutex;
	typedef std::list<Reactor*> ReactorList;
	
	class ReactorRegistration;
	
	int wait();
	
	void runService();
	
	static ACE_THR_FUNC_RETURN runThread(void *arg);
	
	ACE_Thread_Manager m_threadManager;
	Mutex m_mutex;
	ACE_Condition<Mutex> m_cond;
	std::deque<Connection> m_requestQueue;
	ReactorList m_runningReactors;
	ACE_Time_Value m_lastThreadCreateTime;
	volatile int m_numWaiters;
	volatile bool m_isClosing;
};

/*
If we decide to make this class a singleton, we'll have
to make sure it gets destroyed before JsRuntimeSingleton.
*/

#endif
