/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ANIMATEDTRAYICON_H_
#define ANIMATEDTRAYICON_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ace/config.h>
#include <wx/taskbar.h>
#include <wx/icon.h>
#include <wx/timer.h>
#include <wx/string.h>
#include <vector>

class AnimatedTrayIcon : public wxTaskBarIcon
{
public:
	enum { LOOP = 1 << 0, FINISH_CURRENT_ITERATION = 1 << 1 };
	
	AnimatedTrayIcon();
	
	virtual ~AnimatedTrayIcon();
	
	struct Frame
	{
		wxIcon icon;
		int delay_ms;
		
		Frame() : icon(), delay_ms(0) {}
		
		Frame(wxIcon const& icon, int delay_ms)
		: icon(icon), delay_ms(delay_ms) {}
	};
	
	void setIcon(
		wxIcon const& icon, wxString const& tooltip,
		int flags = FINISH_CURRENT_ITERATION);
	
	template<typename It>
	void setAnimation(
		It frames_begin, It frames_end, wxString const& tooltip,
		int flags = LOOP|FINISH_CURRENT_ITERATION);
	
	void removeIcon();
private:
	struct Animation
	{
		std::vector<Frame> frames;
		unsigned int curFrame; 
		wxString tooltip;
		int flags;
		
		Animation() : curFrame(0), flags(0) {}
		
		bool isFinalFrame() const;
		
		void clear();
		
		void swap(Animation& other);
	};
	
	class Timer : public wxTimer
	{
	public:
		Timer(AnimatedTrayIcon& owner);
		
		virtual ~Timer();
		
		virtual void Notify();
	private:
		AnimatedTrayIcon& m_rOwner;
	};
	friend class AnimatedTrayIcon::Timer;
	
	using wxTaskBarIcon::SetIcon;
	using wxTaskBarIcon::RemoveIcon;
	
	void onTimer();
	
	void switchToFrame(int frame);
	
	void switchToNextAnimation();
	
	Timer m_timer;
	Animation m_curAnimation;
	Animation m_nextAnimation;
};


template<typename It>
void
AnimatedTrayIcon::setAnimation(
	It frames_begin, It frames_end, wxString const& tooltip, int flags)
{
	m_nextAnimation.clear();
	m_nextAnimation.frames.assign(frames_begin, frames_end);
	m_nextAnimation.tooltip = tooltip;
	m_nextAnimation.flags = flags;
	if (!(flags & FINISH_CURRENT_ITERATION)
	    || m_curAnimation.isFinalFrame()) {
		switchToNextAnimation();
	}
}

#endif
