/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CONTENTFILTERGROUP_H_
#define CONTENTFILTERGROUP_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "RefCountable.h"
#include "RefCounter.h"
#include "ContentFilters.h"
#include "ContentFiltersFile.h"
#include "FilterGroupTag.h"
#include <ace/Synch_Traits.h>
#include <wx/string.h>

class ContentFilterGroup :
	public RefCountable<RefCounter<ACE_NULL_SYNCH> >
{
public:
	// Default copy ctor and assignment operator are OK.
	
	ContentFilterGroup(
		FilterGroupTag const& tag, wxString const& fname);
	
	virtual ~ContentFilterGroup();
	
	FilterGroupTag const& getTag() const { return m_tag; }
	
	wxString& fileName() { return m_fileName; }
	
	wxString const& fileName() const { return m_fileName; }
	
	ContentFiltersFile& fileStructure() { return m_fileStructure; }
	
	ContentFiltersFile const& fileStructure() const { return m_fileStructure; }
	
	ContentFilters& filters() { return m_filters; }
	
	ContentFilters const& filters() const { return m_filters; }
	
	void swap(ContentFilterGroup& other);
private:
	FilterGroupTag m_tag;
	wxString m_fileName;
	ContentFiltersFile m_fileStructure;
	ContentFilters m_filters;
};


inline void swap(ContentFilterGroup& one, ContentFilterGroup& other)
{
	one.swap(other);
}

#endif
