/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef LOGDIALOG_H_
#define LOGDIALOG_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractLogView.h"
#include <wx/dialog.h>

class LogWidget;
class wxActivateEvent;
class wxCloseEvent;
class wxCommandEvent;

class LogDialog : public wxDialog, private AbstractLogView
{
public:
	LogDialog();
	
	virtual ~LogDialog();
	
	static void show();
private:
	void onWindowActivate(wxActivateEvent& evt);
	
	void onWindowClose(wxCloseEvent& evt);
	
	void onClearLog(wxCommandEvent& evt);
	
	static LogDialog* m_spInstance;
	LogWidget* m_pLogWidget;
	
	DECLARE_EVENT_TABLE()
};

#endif
