/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "OperationLog.h"
#include "TextStyle.h"
#include "StyledText.h"
#include "IntrusivePtr.h"
#include "StringUtils.h"
#include <ace/Synch.h>
#include <ace/Singleton.h>
#include <wx/font.h>
#include <vector>

using namespace std;

OperationLog::OperationLog()
{
	m_ptrMonospacedStyle.reset(new TextStyle);
	wxFont font(10, wxFONTFAMILY_MODERN, wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL);
	m_ptrMonospacedStyle->SetFont(font);
	m_ptrMonospacedStyle->SetTextColour(wxColour(0x00, 0x00, 0x00));
}

OperationLog::~OperationLog()
{
}

OperationLog*
OperationLog::instance()
{
	return ACE_Singleton<OperationLog, ACE_Null_Mutex>::instance();
}

void
OperationLog::appendJsError(
	std::string const& msg, int lineno,
	std::string const& linebuf, int linepos)
{
	if (linebuf.empty()) {
		wxString str;
		str << _T('[') << lineno << _T("] ") << msg.c_str();
		appendRecord(str, getWarningStyle());
		return;
	}
	
	char const* line_begin = StringUtils::ltrim(
		linebuf.c_str(), linebuf.c_str()+linebuf.size()
	);
	linepos -= line_begin - linebuf.c_str();
	char const* line_end = StringUtils::rtrim(
		line_begin, linebuf.c_str()+linebuf.size()
	);
	string line(line_begin, line_end);
	string pointer(linepos, ' ');
	pointer += '^';
	
	wxString str1;
	str1 << _T('[') << lineno << _T("] ") << msg.c_str();
	wxString str2;
	str2 << _T("\n") << line.c_str() << _T("\n") << pointer.c_str();
	vector<StyledText> text;
	text.reserve(2);
	text.push_back(StyledText(str1, getWarningStyle()));
	text.push_back(StyledText(str2, m_ptrMonospacedStyle));
	appendRecord(text.begin(), text.end());
}
