/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef EVENTHANDLER_H_
#define EVENTHANDLER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ace/config-lite.h> // for ACE_HANDLE

class ReactorTimerId;

class EventHandlerBase
{
public:
	virtual ~EventHandlerBase() {}
	
	virtual void ref() = 0;
	
	virtual bool unref() = 0;
	
	virtual void handleRead(ACE_HANDLE handle) {}
	
	virtual void handleWrite(ACE_HANDLE handle) {}
	
	virtual void handleExcept(ACE_HANDLE handle) {}
	
	virtual void handleTimeout(ReactorTimerId const& timer) {}
};


template<typename RC>
class EventHandler : public EventHandlerBase
{
public:
	virtual void ref() { m_refCounter.ref(); }
	
	virtual bool unref() {
		if (m_refCounter.unref()) {
			return true;
		} else {
			delete this;
			return false;
		}
	}
private:
	RC m_refCounter;
};

#endif
