/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "WakeupPipe.h"
#include "Reactor.h"
#include <ace/IPC_SAP.h>
#include <ace/OS_NS_unistd.h>
#include <ace/OS_NS_sys_socket.h>
#include <ace/os_include/netinet/os_tcp.h> // FOR TCP_NODELAY

#ifdef ACE_WIN32
#  define READ_FUN  ACE_OS::recv
#  define WRITE_FUN ACE_OS::send
#  define CLOSE_FUN ACE_OS::closesocket
#else
#  define READ_FUN  ACE_OS::read
#  define WRITE_FUN ACE_OS::write
#  define CLOSE_FUN ACE_OS::close
#endif

static void setNonBlockingMode(ACE_HANDLE handle);

#ifdef ACE_WIN32
static int createSocketPairWin32(ACE_HANDLE handles[2]);
#endif

namespace ReactorHelpers {

WakeupPipe::WakeupPipe()
{
#ifdef ACE_WIN32
	if (createSocketPairWin32(m_handles) == -1) {
		throw Reactor::Exception("creating a socket pair failed");
	}
#else
	if (ACE_OS::pipe(m_handles) == -1) {
		throw Reactor::Exception("pipe() failed");
	}
#endif
	setNonBlockingMode(m_handles[0]);
	setNonBlockingMode(m_handles[1]);
}

WakeupPipe::~WakeupPipe()
{
	CLOSE_FUN(m_handles[0]);
	CLOSE_FUN(m_handles[1]);
}

void
WakeupPipe::activate()
{
	char const data = '\0';
	WRITE_FUN(m_handles[1], &data, 1);
}

void
WakeupPipe::deactivate()
{
	char buf[128];
	while (READ_FUN(m_handles[0], buf, sizeof(buf)) == sizeof(buf)) {}
}

} // namespace ReactorHelpers


void setNonBlockingMode(ACE_HANDLE handle)
{
	// ACE_IPC_SAP has a protected ctor.
	class SAP : public ACE_IPC_SAP {};
	
	SAP sap;
	sap.set_handle(handle);
	sap.enable(ACE_NONBLOCK);
}


#ifdef ACE_WIN32

#include <ace/INET_Addr.h>
#include <ace/SOCK_Acceptor.h>
#include <ace/SOCK_Connector.h>
#include <ace/SOCK_Stream.h>

int createSocketPairWin32(ACE_HANDLE handles[2])
{
	int res = 0;
	ACE_INET_Addr my_addr;
	ACE_SOCK_Acceptor acceptor;
	ACE_SOCK_Connector connector;
	ACE_SOCK_Stream reader;
	ACE_SOCK_Stream writer;
	int const reuse_addr = 1;
	
	if (acceptor.open(ACE_Addr::sap_any, reuse_addr) == -1 ||
	    acceptor.get_local_addr(my_addr) == -1) {
		res = -1;
	} else {
		ACE_INET_Addr sv_addr(my_addr.get_port_number(), ACE_LOCALHOST);
		if (connector.connect(writer, sv_addr) == -1) {
			res = -1;
		} else if (acceptor.accept(reader) == -1) {
			writer.close();
			res = -1;
		}
	}
	
#if !defined(ACE_LACKS_TCPNODELAY)
	int one = 1;
	writer.set_option(ACE_IPPROTO_TCP, TCP_NODELAY, &one, sizeof(one));
#endif
	
	acceptor.close();
	handles[0] = reader.get_handle();
	handles[1] = writer.get_handle();	
	return res;
}

#endif // ACE_WIN32
