#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "daemon.h"

void daemon_init (void)
{
  pid_t pid;
  if ((pid = fork ()) < 0)
  {
    printf("Daemon could not start.\n");
    exit ( 1 );
  }
  else if (pid != 0)
  {
    printf ("Daemon started.  PID - %d\n", pid);
    exit ( 0 );
  }

  // pid > 0
  // pid is the process of the child (the current process at this
  // point, because the parent has already quit.)

  // Set session and group ID.  Become its own process.
  setsid();
  setpgrp();

  // You could change to a directory that the daemon needs
  // to use too.  This is just to prevent the daemon from
  // holding a directory it doesn't need.
  chdir ("/"); 

  umask (0);

  // Close input, output, error output so the daemon runs quiet.
  fclose(stdout);
  fclose(stdin);
  fclose(stderr);
}


