//////////////////////////////////////////////////////////////////
//
// GkClient.h
//
// Copyright (c) Citron Network Inc. 2001-2002
//
// This work is published under the GNU Public License (GPL)
// see file COPYING for details.
// We also explicitely grant the right to link this code
// with the OpenH323 library.
//
// initial author: Chih-Wei Huang <cwhuang@linux.org.tw>
// initial version: 02/27/2002
//
//////////////////////////////////////////////////////////////////

#ifndef GKCLIENT_H
#define GKCLIENT_H "#(@) $Id: GkClient.h,v 1.6.4.18 2004/05/24 13:39:15 zvision Exp $"

#include <map>
#include "gk_const.h"
#include "RasTbl.h"
#include "Toolkit.h"

class H225_AliasAddress;
class H225_ArrayOf_AliasAddress;
class H225_TransportAddress;
class H225_EndpointIdentifier;
class H225_EndpointType;
class H225_CallIdentifier;
class H225_RasMessage;
class H225_GatekeeperRequest;
class H225_GatekeeperConfirm;
class H225_GatekeeperReject;
class H225_RegistrationRequest;
class H225_RegistrationConfirm;
class H225_RegistrationReject;
class H225_AdmissionRequest;
class H225_AdmissionConfirm;
class H225_AdmissionReject;
class H225_DisengageRequest;
class H225_UnregistrationRequest;
class H225_LocationRequest;
class H225_LocationConfirm;
class H225_InfoRequest;
class H225_Setup_UUIE;
class H225_ArrayOf_ClearToken;
class H225_ArrayOf_CryptoH323Token;
class Q931;
class H323RasSrv;
class PendingARQ;
class GKPendingList;
class AlternateGKs;
class NATHandlingThread;
class HandlerList;
class ReceivedLCF;
class CallSignalSocket;

class GkClient {
public:
	GkClient(H323RasSrv *);
	~GkClient();
	
	void SendGRQ();
	void SendRRQ();
	void SendURQ();
	void SendARQ(const H225_AdmissionRequest &, const endptr &, long callDurationLimit = -1);
	void SendARQ(const H225_Setup_UUIE &, unsigned, const callptr &);
	void SendDRQ(H225_RasMessage &);
	void SendLRQ(const PString &, ReceivedLCF * = 0);

	bool SendInfo(CallSignalSocket *, int);

	void OnGCF(const H225_GatekeeperConfirm &);
	void OnGRJ(const H225_GatekeeperReject &);
	bool OnRCF(const H225_RegistrationConfirm &, const PIPSocket::Address &);
	bool OnRRJ(const H225_RegistrationReject &, const PIPSocket::Address &);
	void OnACF(const H225_RasMessage &, const PIPSocket::Address &);
	void OnARJ(const H225_RasMessage &, const PIPSocket::Address &);
	bool OnDRQ(const H225_DisengageRequest &, const PIPSocket::Address &);
	bool OnURQ(const H225_UnregistrationRequest &, const PIPSocket::Address &);
	bool OnIRQ(const H225_InfoRequest &);
	bool OnLCF(const H225_LocationConfirm &);
	bool OnRIP(const H225_RequestInProgress& rip, const PIPSocket::Address& gkip);

	bool IsRegistered() const { return !m_endpointId; }
	bool IsNATed() const { return m_natThread != 0; }

	bool RewriteE164(H225_AliasAddress & alias, bool);
	bool RewriteE164(H225_ArrayOf_AliasAddress & alias, bool);
	bool RewriteE164(Q931 &, H225_Setup_UUIE &, bool);

	void CheckRegistration();
	bool CheckGKIP(const PIPSocket::Address & gkip) { return m_gkaddr == gkip; }
	bool CheckGKIPVerbose(const PIPSocket::Address &);

	PString GetParent() const;

	template<class RAS> void SetPassword(RAS & rasmsg, const PString & id)
	{
		if (!m_password) {
			rasmsg.IncludeOptionalField(RAS::e_cryptoTokens), SetCryptoTokens(rasmsg.m_cryptoTokens, id);
			rasmsg.IncludeOptionalField(RAS::e_tokens), SetClearTokens(rasmsg.m_tokens, id);
		}
	}
	template<class RAS> void SetPassword(RAS & rasmsg)
	{
		SetPassword(rasmsg, !m_e164 ? m_e164 : m_h323Id);
	}

private:
	typedef std::map<int, callptr>::iterator iterator;
	typedef std::map<int, callptr>::const_iterator const_iterator;

	void SendRas(const H225_RasMessage &);
	void BuildFullRRQ(H225_RegistrationRequest &);
	void BuildLightWeightRRQ(H225_RegistrationRequest &);
	int  BuildARQ(H225_AdmissionRequest &);
	bool GetAdmission(H225_RasMessage &, H225_RasMessage &);
	bool RewriteString(PString &, bool) const;
	void SetClearTokens(H225_ArrayOf_ClearToken &, const PString &);
	void SetCryptoTokens(H225_ArrayOf_CryptoH323Token &, const PString &);
	void Unregister();
	void RemoveNATThread();

	H323RasSrv *m_rasSrv;

	PIPSocket::Address m_gkaddr;
	WORD m_gkport;
	H225_TransportAddress *m_callAddr, *m_rasAddr;

	PString m_h323Id, m_e164, m_password;
	PString m_endpointId, m_gatekeeperId;

	PMutex rasMutex;

	int m_ttl, m_retry, m_resend, m_gkfailtime;
	PTime m_registeredTime;

	GKPendingList *m_arqPendingList;
	std::map<int, callptr> m_arqAnsweredList;

	AlternateGKs *m_gkList;
	bool m_useAltGKPermanent;

	Toolkit::RewriteData *m_rewriteInfo;

	NATHandlingThread *m_natThread;
	// this is not a good implementation,
	// but it's already enough for now
	ReceivedLCF *m_lcfHook;

	H235AuthSimpleMD5 auth;
};

#endif // __gkclient_h_
