//////////////////////////////////////////////////////////////////
//
// addpasswd.cxx
//
// $Id: addpasswd.cxx,v 1.3.10.3 2004/05/12 17:46:39 zvision Exp $
//
// This work is published under the GNU Public License (GPL)
// see file COPYING for details.
// We also explicitely grant the right to link this code
// with the OpenH323 library.
//
// History:
//      2001/09/27      initial version (Chih-Wei Huang)
//
//////////////////////////////////////////////////////////////////

#include <algorithm>
#include <ptlib.h>
#include <ptclib/cypher.h>

class Client : public PProcess
{       
  PCLASSINFO(Client, PProcess)
  public:
    void Main();
};      


PCREATE_PROCESS(Client)

int keyFilled = 0;

PString Encrypt(const PString &key, const PString &clear)
{
	PTEACypher::Key thekey;
	memset(&thekey, keyFilled, sizeof(PTEACypher::Key));
	memcpy(&thekey, const_cast<PString &>(key).GetPointer(), min(sizeof(PTEACypher::Key), size_t(key.GetLength())));
	PTEACypher cypher(thekey);
	return cypher.Encode(clear);
}

PString Decrypt(const PString &key, const PString &encrypt)
{
	PTEACypher::Key thekey;
	memset(&thekey, keyFilled, sizeof(PTEACypher::Key));
	memcpy(&thekey, const_cast<PString &>(key).GetPointer(), min(sizeof(PTEACypher::Key), size_t(key.GetLength())));
	PTEACypher cypher(thekey);
	return cypher.Decode(encrypt);
}

void Client::Main()
{
	PArgList args(GetArguments());
	if (args.GetCount() < 4) {
		cout << "Usage: addpasswd config section userid password\n\n";
		return;
	}

	PConfig config(args[0],args[1]);
	
	if( config.GetSections().GetStringsIndex(args[1]) == P_MAX_INDEX ) {
	    cerr << "Error: the specified config file does not contain a section named "
		<< args[1] << endl;
	    return;
	}
	if( !config.HasKey(args[1], "KeyFilled") ) {
	    cerr << "Error: the specified config section does not contain KeyFilled parameter\n";
	    return;
	}
	
	config.SetDefaultSection(args[1]);
	keyFilled=(config.GetString("KeyFilled", "0")).AsInteger();
	PString userid = args[2], passwd = args[3];
	PString encrypt = Encrypt(userid, passwd);
	config.SetString(userid, encrypt);
}

