//////////////////////////////////////////////////////////////////
//
// gk_const.h	constants for gatekeeper ports etc.
//
// This work is published under the GNU Public License (GPL)
// see file COPYING for details.
// We also explicitely grant the right to link this code
// with the OpenH323 library.
//
// History:
// 	991002	initial version (Jan Willamowius)
//  990127  moved all to config file (towi)
//
//////////////////////////////////////////////////////////////////

#ifndef GK_CONST_H
#define GK_CONST_H "#(@) $Id: gk_const.h,v 1.3.2.6 2004/05/12 17:46:39 zvision Exp $"

/* all values can be set in the config file, section [Gatekeeper::<InstanceName>]
 * these are just the defaults
 */

extern WORD GK_DEF_UNICAST_RAS_PORT;
extern WORD GK_DEF_MULTICAST_PORT;
extern WORD GK_DEF_CALL_SIGNAL_PORT;
extern WORD GK_DEF_ENDPOINT_SIGNAL_PORT;
extern WORD GK_DEF_STATUS_PORT;
extern unsigned GK_DEF_LISTEN_QUEUE_LENGTH;
extern const char* const GK_DEF_MULTICAST_GROUP;

extern const char* const H225_ProtocolID;
extern const char* const H235_OID_MD5;
extern const char* const H235_OID_U;

extern const char* const RoutedSection;
extern const char* const LRQFeaturesSection;
extern const char* const ProxySection;
extern const char* const CallTableSection;
extern const char* const NeighborSection;

#endif

