#include "str_util.h"

char *Strdup(const char *str) {
    char *r;
	
    if(str == NULL) {
	fprintf(stderr, "strdup failed for %s\n", str);
	exit(1);
    }

    r = strdup(str);

    if(r == NULL) {
	fprintf(stderr, "strdup failed for %s\n", str);
	exit(1);
    }
    
    return r;
}

/* malloc enough space for the return character and concat 2 strings
   together */
char *Strconcat(const char *s1, const char *s2) {
    char *ret;
    int total_len;

    total_len = strlen(s1) + strlen(s2);

    // ret = calloc(sizeof(char), total_len + 1);
    ret = malloc(total_len + 1);

    if(ret == NULL) {
  	fprintf(stderr, "malloc failed for %s + %s\n", s1, s2);
	exit(1);
    }

    strncpy(ret, s1, strlen(s1));
    ret[strlen(s1)] = '\0';
    
    strncat(ret, s2, strlen(s2));
    ret[total_len] = '\0';
    return ret;
}

/*
  remove the trailing \r or \n

  this function is destrcutive to the original char slightly

  returns 1 on success.
*/

int chomp(char *line) {
    int len;
    int end;
    //printf("chomp: line = %s\n", line);
    len = strlen(line);
    end = len - 1;

    if(end <= 0) return 0;
    
    while(end > 1 && ((line[end] == '\n') || (line[end] == '\r'))) {
	line[end] = '\0';
	end--;
    }
    
    return 1;
}
