#include "tcp_client.h"

#include <iostream.h>
#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <sys/types.h>

TcpClient::TcpClient(char* host, int port, FILE* init_log)
 {
  status = 0;
  log = init_log ;
  setbuf(log, NULL);
  struct hostent *h = gethostbyname(host);

  if(!h)
   {
    error("Host name lookup failure for %s", host);
    return;
   }

  memset((char *) &serv_addr, 0, sizeof(serv_addr));
  
  serv_addr.sin_family            = AF_INET;
  memcpy(&(serv_addr.sin_addr.s_addr), h->h_addr, h->h_length);
  serv_addr.sin_port              = htons(port);

        /* 
         * Open a TCP socket (an Internet stream socket).
         */
        
  if ( (socket_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    { 
      error("TcpClient: can't open stream socket");
      return;
    }

  status = 1;
 }

void TcpClient::connect()
 {
  if (::connect(socket_fd, (struct sockaddr *) &serv_addr, 
        sizeof(serv_addr)) < 0)
    
    error("TcpClient: can't connect to server : %s", strerror(errno ));
 }

int TcpClient::send(char* data, int num_bytes)
 {
  return write(socket_fd, data, num_bytes);
 }

int TcpClient::receive(char* data, int num_bytes)
 {
   fd_set rfds;
   struct timeval tv;
   int ret_select;

   FD_ZERO(&rfds);
   FD_SET(socket_fd, &rfds);
  
   tv.tv_sec = 5;
   tv.tv_usec = 0;

   //fprintf(stderr, "socket_fd = %d\n", socket_fd);

   ret_select = select(socket_fd + 1, &rfds, NULL, NULL, NULL);
   //fprintf(stderr, "ret_select = %d\n", ret_select);
   
   if(ret_select == -1)
     warn("Select error: %s\n", strerror(errno));

   if(ret_select < 1)
     return 0;

   return read(socket_fd, data, num_bytes);
 }

TcpClient::~TcpClient()
 {
  close(socket_fd);
 }

#ifdef DEBUG

int main(int c, char** argv)
 {
  char* host = "www.direct1.com";
  int port = 80;
  char* log_file = NULL;
  FILE* log;


  if(c > 4)  c = 4;

  switch(c)
   {
    case 4: log_file = argv[3];
    case 3: port = atoi(argv[2]);
    case 2: host = argv[1];
   }

   if(log_file)
    {
     log =  fopen(log_file, "a");
     if(!log)
      {
       fprintf(stderr, "Could not open log file %s: %s\n", log_file,
        strerror(errno));
       exit(1);
      }
    }
    else
     log = stderr;

    char buffer[2048];
    TcpClient client(host,port, log);
    if(!client)
     exit(1);

    client.connect();
    if(!client)
     {
      exit(1);
     }
    client.send("GET / HTTP/1.0\n\n", strlen("GET / HTTP/1.0\n\n"));
    int bytes_read;
    bytes_read =  client.receive(buffer, 2048);

    do
     {
      int i;
      for(i = 0; i < bytes_read; i++)
       {
        cout << (char)(buffer[i]);
       }
 
      bytes_read =  client.receive(buffer, 2048);

     } while(bytes_read > 0);

   
 }

#endif
