#ifndef TCP_CLIENT_H
#define TCP_CLIENT_H

#include <fstream.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <errno.h>
#include <time.h>

#include        <sys/types.h>
#include        <sys/socket.h>
#include        <netinet/in.h>
#include        <arpa/inet.h>
#include 	<netdb.h>


class TcpClient
 {
  protected:
   int socket_fd;
   struct sockaddr_in  serv_addr;
   int status;
   FILE *log;

   void print_time(FILE* fp)
    {
     time_t now;
     time(&now);
     char* time_str = ctime(&now);
     time_str[strlen(time_str) - 1] = 0;
     fprintf(fp, "[%s] ", time_str);
    }

  public:
   TcpClient(char* host, int port, FILE* init_log = stderr);
   ~TcpClient();
   void connect();
   int send(char* data, int num_bytes);
   int receive(char* data, int num_bytes);

   operator void*() { return (void*)status;}
   int operator !() { return !status;}
   void set_log(FILE* new_log) { log = new_log;}

   virtual void error(char* fmt, ...)
    {
     va_list ap;
     va_start( ap, fmt);
     print_time(log);
     fprintf(log, "TCP Client error:");
     vfprintf(log, fmt, ap);
     fprintf(log, ": errno = '%s'\n", strerror(errno));
     status = 0;
    }
   virtual void warn(char* fmt, ...)
    {
     va_list ap;
     va_start( ap, fmt);
     print_time(log);
     fprintf(log, "TCP Client warning:");
     vfprintf(log, fmt, ap);
     fprintf(log, ": errno = '%s'\n", strerror(errno));
    }
 };

#endif
