/* LinPopUp - A Linux enhanced port of Winpopup, running over Samba.
 * Copyright (c)1998-2000 Jean-Marc Jacquet <jm@littleigloo.org>  
 * Little Igloo Org  http://www.LittleIgloo.org
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "protos.h"
#include <stdio.h>
#include <string.h>
#include "version.h"

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE (!FALSE)
#endif


char *
many_version_infos (char *buf)
{
  sprintf (buf, _("LINPOPUP V%s - (c)LittleIgloo.org 1998-%s.\nCompiled by %s on %s the %s at %s,\nUsing %s and %s."), PROG_VERSION, VERSION_DATE, COMPILE_BY, COMPILE_HOST, COMPILE_DATE, COMPILE_TIME, CC_VERSION, GTK_VERSION);
  return buf;
}



char *
a_little_version_infos (char *buf)
{
  sprintf (buf, "LINPOPUP  V%s - (c)Little Igloo Org 1998-%s", PROG_VERSION, VERSION_DATE);
  return buf;
}



char *
what_is_this_stupid_programm_that_have_crashed (char *buf)
{
  sprintf (buf, "LINPOPUP  V%s", PROG_VERSION);
  return buf;
}



char *
version (char *buf)
{
  strcpy (buf, PROG_VERSION);
  return buf;
}

char *
compile_host (char *buf)
{
  strcpy (buf, COMPILE_HOST);
  return buf;
}

int
how_many_lines_of_code (void)
{
  return CODE_LINES;
}

char
samba_info (char *buf)
{
  FILE *output;
  char version_found = FALSE;


  buf[0] = 0;
  if ((output = popen ("smbclient -V 2> /dev/null", "r")) == NULL)
    return FALSE;

  while (fgets (buf, 80, output))
    if (strstr (buf, "ersion"))
      {
	version_found = TRUE;
	*strrchr (buf, '\n') = 0;
	memmove (buf, strstr (buf, "ersion") + 6, 80);
	break;
      }

  pclose (output);
  return version_found;
}

/* EOF */
