/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: billing.h,v 1.56.4.3 2005/02/18 18:02:55 anton Exp $ */

#define S_BILLING_DEF_delay	60

typedef struct Billing_cfg;
typedef struct bUlist;
typedef struct FeeCounters;

void sBiInit(Service *s);
void sBiObtainDbData(NetUnit *u, Billing_cfg *c);
void sBiProcessCfg(char *param[], Connection *conn, u_char no_flag);
void sBiListCfg(Service *s, FILE *f);
void cShowBillingAccount(Connection *conn, char *param[]);
void cShowBillingPlan(Connection *conn, char *param[]);
FeeCounters* PrepareFeeCounters();

class PlansL;
class SubPlansL;
class AccountsL;

class Plan;
class SubPlan;
class Account;

extern PlansL *bPlans;
extern SubPlansL *bSubPlans;
extern AccountsL *bAccounts;

extern Service *Billing;
extern Billing_cfg *BillingCfg;

typedef struct Billing_cfg {
	unsigned delay;
	u_char storage;
	storage_category st_cat;
	Service *st;
	FIFO *fifo;
	pthread_rwlock_t *rwlock; // for multiple threads access same config data 
	char *bfilename;
	char *sfilename;
	} Billing_cfg;

//////////////////////////////////////////////////////////////////////////
class PlansL {
	public:
		PlansL() { root=NULL; num_plans=0; } ;
		~PlansL();
		Plan *root;
		void Add(Plan *s);
		void Delete(Plan *s);
		u_char Check(Plan *s);
		void Delete(oid id);
		Plan *Check(oid id);
		unsigned num_plans;
		};
//////////////////////////////////////////////////////////////////////////
class SubPlansL {
	public:
		SubPlansL() { root=NULL; num_subplans=0; };
		~SubPlansL();
		SubPlan *root;
		void Add(SubPlan *s);
		void Delete(SubPlan *s);
		u_char Check(SubPlan *s);
		SubPlan *Add(oid id);
		void Delete(oid id);
		SubPlan *Check(oid id);
		unsigned num_subplans;
		};
//////////////////////////////////////////////////////////////////////////
// sure there is no interaction with POLICY_FLAG_*
#define UNLIM_IN	0x04   
#define UNLIM_OUT	0x08 

class SubPlan {
	public:
		SubPlan(oid newid);
		~SubPlan();
		oid id;
		float fee;
		char spread;
		unsigned long long inc_in;
		unsigned long long inc_out;
		unsigned inc_adjust; // we allow 'slow adjustment' of included traffic? default is NO=0
		policy_flag flags;
		oid pid;
		float pay_in, pay_out;
		double overdraft_in;
		double overdraft_out;
		SubPlan *next;
		u_short connected_plans;
		};
//////////////////////////////////////////////////////////////////////////

// subplan  representation
typedef struct bSPlist {
        SubPlan *sp;
        bSPlist *next;
        } bSPlist;

class Plan {
	public:
		Plan(oid newid);
		~Plan();
		oid id;
		char *name;
		char *description;
		bSPlist *root;
		u_char num_subplans;
		unsigned connected_accounts;
		u_char AddSubPlan(SubPlan *sp, u_char flag); //ADD|REMOVE
		void SetAccountData(Account *ac); //set preincluded traffic for account
		Plan *next;
		};
//////////////////////////////////////////////////////////////////////////
class AccountsL {
	public:
		AccountsL();
		~AccountsL();
		Account *root;
		void Add(Account *s);
		Account *Check(char *name);
		time_t last_charge;
		void ChargeFees();
		time_t last_update;
		void RestoreAccounts();
		void UpdateAccounts();
		unsigned num_accounts;
		unsigned max_accounts_number_set;
		};
//////////////////////////////////////////////////////////////////////////
typedef struct bstat {
	double pay_in;
	double pay_out;
	long long in;
	long long out;
	time_t from;
	} bstat;

#define	BDATA_NEED_SYNC	0x01

typedef struct biling_data {
	bstat flow;
	bstat h,d,w,m;
	u_char flags;
} billing_data;

// this using unit representation
typedef struct bUlist {
	NetUnit *u;
	bUlist *next;
	} bUlist;

//this is for fee multipliers and time counters
typedef struct FeeCounters {
	time_t now;
	time_t ht;
	time_t dt;
	time_t wt;
	time_t mt;
	double hour_mult;
	double day_mult;
	double month_mult;
	double traf_mult;
} FeeCounters;

extern Connection *cInternal;
enum balance_action	{ BAL_ADD, BAL_REMOVE, BAL_SET };
enum status_action	{ AC_BLOCK, AC_BEBLOCK, AC_UNBLOCK, AC_DENY, AC_PASS };

#define ACCOUNT_NEED_SYNC	0x01
#define ACCOUNT_DENIED		0x02
#define ACCOUNT_BLOCKED		0x04
#define ACCOUNT_DELETED		0x08
#define ACCOUNT_BEBLOCKED	0x10
#define ACCOUNT_BDATA_NEED_SYNC	0x20

class Account {
	public:
		oid id;
		Account *next;
		char *name;
		char *password;
		char *email;
		char *description;
		time_t blocked;
		time_t created;
		time_t changed;
		time_t last_fee_ch;
		time_t plan_ch;
		time_t nextplan_ch;
		u_char status;
		Plan *plan;
		Plan *nextplan;
		bUlist *bUroot;  //Units that belongs to account
		u_char num_units;
		billing_data *data;
		u_char AddUnit(NetUnit *u, u_char flag); //ADD|REMOVE
		void Update(Plan *pl);
		void SetUnitAccountPolicy(NetUnit *u, u_char flag); 
		void UpdateStatus(status_action action, time_t change_t); //BLOCK PASS 
		void AccountMessage(Message_Store *msg);
		void ChargeFee();
		void setName(char *name);
		void SyncAccount(FILE *f);
		unsigned SyncBdata(FILE *f);
		Account();
		~Account();
		void Balance(float amount, balance_action action);
		double balance;
	};
//////////////////////////////////////////////////////////////////////////
