/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: bw.c,v 1.13.4.1 2005/02/21 17:44:57 jura Exp $ */

#include "netams.h"

typedef struct BW BW;

//this is to check bw for apropriate unit
BWdata::BWdata(BW *bw) {
	limit_in=bw->in/8; // bits/s -> bytes/s
	limit_out=bw->out/8; // bits/s -> bytes/s
	num_flows=0;

	struct timeval tv;
	gettimeofday(&tv, NULL);
	end_t[0]=tv.tv_sec*1000+tv.tv_usec/1000;
	end_t[1]=end_t[0];
	start_t[0]=end_t[0]-1000;
	start_t[1]=start_t[0];
	total_bytes[0]=limit_out; total_bytes[1]=limit_in;
}

BWdata::~BWdata() {
}

u_char BWdata::Check(u_short size, match mf, struct timeval *tv) {

	//printf("[%10s] t_b=%ld, st=%lu, et=%lu, bw=%lu\n", u->name, total_bytes, start_t, end_t, 1000*total_bytes/(end_t-start_t));
	
	int verdict;
	//unsigned long shift=0;
	unsigned long rate=0;

	/*
	// first algorithm
	rate=1000*(total_bytes[mf-1]+size)/(tv->tv_sec*1000 + tv->tv_usec/1000-start_t[mf-1]);
	if (mf==2 && limit_in==0) verdict=0;
	else if (mf==1 && limit_out==0) verdict=0;
	else if ((mf==2 && limit_in>rate) || (mf==1 && limit_out>rate)) {
		verdict=0;
		end_t[mf-1] = tv->tv_sec*1000 + tv->tv_usec/1000;
		shift = (end_t[mf-1]-start_t[mf-1])/10; // decrease time window to 10% 
		start_t[mf-1] += shift;
		total_bytes[mf-1]=total_bytes[mf-1]+size-rate*shift/1000;
		} else verdict=1;

	//printf("[%10s] {%d} %s bytes=%d, %lu.%06lu | shift=%lu, t_b=%lu, st=%lu, et=%lu | %lu\n", u->name, mf, verdict?"DROP":"PASS", size, tv->tv_sec, tv->tv_usec, shift, total_bytes, start_t[mf-1], end_t[mf-1], rate); fflush(stdout);
	return verdict;
	*/

	// second algorithm
	// 1. adjust tocken buckets for both directions
	rate = (tv->tv_sec*1000 + tv->tv_usec/1000 - end_t[1])*limit_in/1000;
	total_bytes[1]+=rate; if ((unsigned long)total_bytes[1]>limit_in) total_bytes[1]=limit_in;
	rate = (tv->tv_sec*1000 + tv->tv_usec/1000 - end_t[0])*limit_out/1000;
	total_bytes[0]+=rate; if ((unsigned long)total_bytes[0]>limit_out) total_bytes[0]=limit_out;
	// 2. adjust end_t
	end_t[0]=end_t[1]=tv->tv_sec*1000 + tv->tv_usec/1000;
	// 3. check if number of tokens is enough
	if (mf==2 && limit_in==0) verdict=0;
	else if (mf==1 && limit_out==0) verdict=0;
	else if (mf==2 && limit_in>0) {
		if (total_bytes[1]>=size) {
			total_bytes[1]-=size;
			verdict=0;
			} else verdict=1;
		}
	else if (mf==1 && limit_out>0) {
		if (total_bytes[0]>=size) {
			total_bytes[0]-=size;
			verdict=0;
			} else verdict=1;
		} 
	else verdict=1;
	return verdict;
}
//////////////////////////////////////////////////////////////////////////////////////////
u_char BWCheck(entry *e, u_short size, struct timeval *tv) {
	bwUlist *bwu;
	for(bwu=e->bwRoot; bwu!=NULL; bwu=bwu->next) {
		if(bwu->bw->Check(size, bwu->mf, tv)) return 1;
	}
        return 0;
}
//////////////////////////////////////////////////////////////////////////////////////////
BW* setBW(BW* bw, char **param, u_char *i) {
	
	u_char j=*i+1;
	unsigned long tmp, bw_in, bw_out;
	bw_in=bw_out=tmp=0;
	
	while(param[j]!=empty) {
		if(isdigit(param[j][0]))
			tmp=(unsigned long)bytesT2Q(param[j]);
		else {
			j-=2;
			break;
		}
		if(!strncasecmp("in", param[j+1], 2)) 
			bw_in=tmp;
		else if(!strncasecmp("out", param[j+1], 3))
			bw_out=tmp;
		else {
			bw_in=bw_out=tmp;
			j--;
		}
		j+=2;
	}

	*i=j;
	if(bw_in || bw_out) {
		if(bw==NULL) bw=(BW*)aMalloc(sizeof(BW));
		bw->in=bw_in;
		bw->out=bw_out;
	} 
	
	if(bw && bw->in==0 && bw->out==0) {
		aFree(bw);
		bw=NULL;
	}
	
	return bw;
}

char* getBW(BW *bw, char *buf) {
	char tmp[64];
	buf[0]=0;
	
	if(bw != NULL) {
		if(bw->in==bw->out && bw->in) 
			sprintf(buf, "%s ", bytesQ2T((unsigned long long)bw->in, tmp));
		else {
			if(bw->in) sprintf(buf, "%s in ", bytesQ2T((unsigned long long)bw->in, tmp));
			if(bw->out) sprintf(buf+strlen(buf), "%s out ", bytesQ2T((unsigned long long)bw->out, tmp));
		}
	}
	return buf;
}
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
