/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: connections.h,v 1.10 2005/01/17 13:13:21 jura Exp $ */

#define CONN_FD_NULL	-2
#define CONN_FD_VIRT	-1

#ifdef LINUX
ssize_t conn_write(void *conn, const char *buf, unsigned i);
#else 
int conn_write(void *conn, const char *buf, int i);
#endif

//////////////////////////////////////////////////////////////////////////
class Connection {
	public:
		pthread_t t_id;
		char *name;
		unsigned conn_id;
		FILE *stream_r;
		FILE *stream_w;
		Connection *next;
		Connection(char *name, int fd);
		char *getName() { return name; }
		~Connection();
		Service *service;
		User *user;
		unsigned permissions;
		struct sockaddr_in *addr;
		Debug debug;
		time_t t_connected;
		time_t t_lastcmd;
		char *buffer;
		void Flush();
		int socket;
	};

class ConnectionsList {
	private:
		unsigned num_connections;
		unsigned last_conn_id;
		pthread_mutex_t *lock;
		char *unknown_service;
	public:
		Connection *root;
		Connection *last;
		ConnectionsList();
		~ConnectionsList();
		unsigned getConnectionsNum() { return num_connections; }
		unsigned getConnectionsLastId() { return last_conn_id; }
		Connection *getConnection(unsigned conn_id); 
		void Insert(Connection *t);
		void Delete(unsigned conn_id);
		void Delete(Connection *t);
		void DeleteAll(Connection *except);
		void listConnections(Connection *watcher);
		Connection *getConnectionByThr(pthread_t t);
		};

//////////////////////////////////////////////////////////////////////////
void cShowConnections(Connection *conn);

//////////////////////////////////////////////////////////////////////////

