/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ds_ulog.c,v 1.5 2005/01/17 13:13:21 jura Exp $ */

#if defined(LINUX) && !defined(IPTBL_NONE)

#include "netams.h"
#include "libipulog.h"

/////////////////////////////////////////////////////////////////////////////////////
void ds_ulog_cancel(void *ptr);
/////////////////////////////////////////////////////////////////////////////////////
void* ds_ulog(void *ss) {
	Service *s=(Service*)ss;
	ServiceDS_cfg *cfg=(ServiceDS_cfg*)s->cfg;
	
	struct ipulog_handle *ulog_h; /* our libipulog handle */
	ulog_packet_msg_t *m;
	Flow *flow=cfg->flow;
        struct timeval start;
	unsigned char *packet=cfg->packet;
	int status;
	
	/* create ipulog handle */
        ulog_h = ipulog_create_handle(cfg->nlmask);
        if (!ulog_h) {
		aLog(D_ERR, "linux ulog handle failed: %s!\n", ipulog_strerror(ipulog_errno));
		return NULL;
	}
	SET_POLL(ulog_h->fd);

        pthread_cleanup_push(ds_ulog_cancel, (void*)ulog_h);
        pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

	aLog(D_INFO,"ULOG packet processing for data-source:%u initialized\n",s->instance);
        
	while(1) {
		CHECK_POLL(status);
		if(status==0) {
                        gettimeofday(&start, NULL);
                        cfg->flow->Expiresearch(&start);
			continue;
                }

		status=ipulog_read(ulog_h, packet, MAX_PKT_SIZE, 1000);
		if(status <0) {
			aLog(D_WARN, "ds:%u : %s\n", cfg->id, ipulog_strerror(ipulog_errno));
			continue;
		}
		
		while((m=ipulog_get_packet(ulog_h, packet, status))) {
			gettimeofday(&start, NULL);
			flow->Expiresearch(&start);
			flow->Processpacket((struct ip*)m->payload);
			sDSMeasure(cfg, &start, m->data_len);
		}
	}
	pthread_cleanup_pop(1);
	return NULL;
}
/////////////////////////////////////////////////////////////////////////////////////
void ds_ulog_cancel(void *ptr) {
	ipulog_destroy_handle((struct ipulog_handle*)ptr);
}
#endif
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
