/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: libipulog.h,v 1.2 2005/01/17 13:13:21 jura Exp $ */


/*  libipulog.h,v 1.7 2003/05/04 10:00:10 laforge Exp $ */


#if defined(LINUX) and not defined(IPTBL_NONE)

#ifndef _LIBIPULOG_H
#define _LIBIPULOG_H

#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <asm/types.h>
#include <linux/netlink.h>
#include <net/if.h>
#include <linux/netfilter_ipv4/ipt_ULOG.h>

/* FIXME: glibc sucks */
#ifndef MSG_TRUNC 
#define MSG_TRUNC	0x20
#endif

struct ipulog_handle
{
        int fd;
        u_int8_t blocking;
        struct sockaddr_nl local;
        struct sockaddr_nl peer;
        struct nlmsghdr* last_nlhdr;
};

extern int ipulog_errno;

u_int32_t ipulog_group2gmask(u_int32_t group);

struct ipulog_handle *ipulog_create_handle(u_int32_t gmask);

void ipulog_destroy_handle(struct ipulog_handle *h);

ssize_t ipulog_read(struct ipulog_handle *h,
		    unsigned char *buf, size_t len, int timeout);

ulog_packet_msg_t *ipulog_get_packet(struct ipulog_handle *h,
				     const unsigned char *buf,
				     size_t len);

char *ipulog_strerror(int errcode);

void ipulog_perror(const char *s);

enum 
{
	IPULOG_ERR_NONE = 0,
	IPULOG_ERR_IMPL,
	IPULOG_ERR_HANDLE,
	IPULOG_ERR_SOCKET,
	IPULOG_ERR_BIND,
	IPULOG_ERR_RECVBUF,
	IPULOG_ERR_RECV,
	IPULOG_ERR_NLEOF,
	IPULOG_ERR_TRUNC,
	IPULOG_ERR_INVGR,
	IPULOG_ERR_INVNL,
};
#define IPULOG_MAXERR IPULOG_ERR_INVNL

#endif /* _LIBULOG_H */

#endif
