/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: messages_fifo.h,v 1.17 2005/01/17 13:13:21 jura Exp $ */


//////////////////////////////////////////////////////////////////////////
// Message class
#define NUM_MSG_TYPES	6

typedef u_char  message_type;
#define	MSG_STORE	1
#define MSG_READ	2
#define MSG_ALERT	3
#define MSG_COMMAND	4
#define MSG_PVM_BILLING	5


class Message {
	private:
		pthread_mutex_t *lock;
	public:
		u_char active;
		Message *next;
		message_type type;
		Message(message_type t);
		~Message();
		void Push();
		void Pop();
		u_char Active();
};

class Message_Read: public Message {
	public:
		oid netunit;
		oid ap;
		policy_data *pdata;
		char prefix; // M, W, D, H, F
		Message_Read();
		~Message_Read();
};

class Message_Store: public Message {
	public:
		oid netunit;
		oid ap;
		pstat *data;
		char prefix; // M, W, D, H, F
		time_t ts;
		Message_Store();
		~Message_Store();
};

class Message_Alert: public Message {
	public:
		alert *al;
		Message_Alert();
		~Message_Alert();
};

class Message_PVM_Billing: public Message {
	public:
		Account *account;
		char *text;
		time_t ts;
		Message_PVM_Billing();
		~Message_PVM_Billing();
};
//////////////////////////////////////////////////////////////////////////
typedef struct MsgHolder {
        Message *msg;
        MsgHolder *next;
        } MsgHolder;
//////////////////////////////////////////////////////////////////////////
// FIFO class
class FIFO {
	private:
		pthread_mutex_t *lock;
	public:
		MsgHolder *root;
		MsgHolder *last;
		MsgHolder *ready;
		unsigned num_items;
		unsigned max_items;
		unsigned long total_items;
		unsigned num_holders;
		FIFO(unsigned max);
		~FIFO();
		MsgHolder *newHolder();
		void freeHolder(MsgHolder *h);
		u_char Push(Message *msg);
		Message *TryPop();
		Message *Pop();
};
//////////////////////////////////////////////////////////////////////////
class MessageManager {
	private:
		pthread_mutex_t *lock;
	public:
		Message *ready[NUM_MSG_TYPES];
		unsigned ready_items[NUM_MSG_TYPES];
		unsigned allocated[NUM_MSG_TYPES];
		unsigned total_ready_items;
		unsigned total_allocated;	

		MessageManager();
		~MessageManager();
		Message* New(message_type t);
		void Delete(Message *msg);
		void Usage(Connection *conn);
};
//////////////////////////////////////////////////////////////////////////
class DS_FIFO {
	public:
		IPStatMsg *root;
		IPStatMsg *last;
		IPStatMsg *ready;
		unsigned num_items;
		unsigned max_items;
		unsigned long total_items;
		unsigned ready_items;
		pthread_mutex_t *lock;
                DS_FIFO(unsigned max);
                ~DS_FIFO();
                IPStatMsg* Push(IPStatMsg *msg);
                IPStatMsg* Pop(IPStatMsg *msg);
};
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
 
