/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: policy.h,v 1.55 2005/01/17 13:13:21 jura Exp $ */

/////////////////////////////////////////////////////////////////////////////////////
extern time_t fw_check_changed;

#define IS_FW_CHECK_CHANGED(since) ((unsigned)fw_check_changed>=since)
#define FW_CHECK_CHANGED(now)	{ fw_check_changed=now; }
/////////////////////////////////////////////////////////////////////////////////////
#define POLICY_TYPES_NUM 	3

//number here should be in sync with char policy_type_name[][] defined in policy.c
enum policy_type { POLICY_NONE=0, POLICY_ACCT=1, POLICY_FW=2 }; 

/////////////////////////////////////////////////////////////////////////////////////
#ifndef PC_MAX_PORTS
#define PC_MAX_PORTS	10
#endif

#ifndef PC_MAX_IFS
#define PC_MAX_IFS 10
#endif

#ifndef PC_MAX_ADDRS
#define PC_MAX_ADDRS 10
#endif

#ifndef PC_MAX_POLICIES
#define PC_MAX_POLICIES 10
#endif

typedef u_char policy_target_type;

#define PT_UNKNOWN		0
#define PT_IP_TRAFFIC		0x01
#define PT_NETFLOW_TRAFFIC	0x02
#define PT_LIBPCAP_TRAFFIC	0x04
#define PT_MAIL_STAT		0x08
#define PT_CACHE_EFF		0x10
#define PT_LOGIN_LOG		0x20
#define PT_POLICY		0x40

typedef u_short policy_check_type;

#define PC_UNKNOWN	0
#define PC_IP_PROTO	0x0001
#define PC_UNIT		0x0002
#define PC_FILE		0x0004
#define PC_IP_TOS	0x0008
#define PC_IP_PORTS	0x0010
#define PC_IFINDEX	0x0020
#define PC_IP_ADDR	0x0040
#define PC_TIME		0x0080
#define PC_DAYOFWEEK	0x0100

typedef u_char policy_logic_type;

#define PL_OR	0
#define PL_AND  0x01


typedef struct policy_target {
	policy_target_type	target_type;
	policy_check_type	check_type;
	
	//check_types
	
	//PC_IP
	u_short proto;				// as in /etc/protocols

	//PC_IP_ADDR
	//this is when or dst or src in
	u_char num_addrs;
	struct in_addr addr[PC_MAX_ADDRS];		/* Source and destination IP addr */
	struct in_addr addr_mask[PC_MAX_ADDRS];		/* Mask for src and dest IP addr */
	
	//PC_IP_PORTS
	u_char  num_ports;
	u_short src_ports[PC_MAX_PORTS];
	u_short dst_ports[PC_MAX_PORTS];
	
	//PC_IP_TOS
	u_char ip_tos;

	//PC_UNIT
	oid 	unit_id;	
	char 	*unit_name;
	NetUnit *unit;

	//PC_FILE
	PrefixFile *file;
	
	//PC_IFS
	int src_ifs[PC_MAX_IFS];
	int dst_ifs[PC_MAX_IFS];

	//PC_TIME
	int t_begin, t_end; /* seconds from midnight */

	//PC_DAYOFWEEK
	u_char day_allowed[7];	//day_of_week allowed, 0 is monday, 6 is sunday (but here in america weeks starts at sunday :)
	int day_d1, day_d2; 	/* begin and end of interval */

	//policy_type==PT_POLICY and check_type=UNKNOWN
	policy_logic_type logic; //0==or; 1=and
	u_char inversion[PC_MAX_POLICIES];
	Policy *list[PC_MAX_POLICIES];
	
} policy_target;
	 
/////////////////////////////////////////////////////////////////////////////////////
class Policy {
	public:
		oid id;
		char *name;
		
		policy_target target; // ip, mail, squid, login, etc...

		Policy *next;

		Policy();
		~Policy();
		void setName(char *n);
		u_char setTarget(char **tgt, u_char *i, u_char no_flag=0);
		char *getTarget();
		u_char Check(IPFlowStat *flow, match mf);
};

/////////////////////////////////////////////////////////////////////////////////////
class PolicyList {
	public:
		Policy *root;
		Policy *last;
		u_char num_policies;
		pthread_rwlock_t *rwlock;

		PolicyList();
		~PolicyList();
		void Insert(Policy *p);
		void Delete(Policy *p);
		void Delete(oid id);
		void DeleteAll();
		void DeleteUnitFromTarget(NetUnit *u);
		Policy *getPolicy(char *name);
		Policy *getPolicyById(oid id);
		friend int cShowPolicy(Connection *conn);
		};

/////////////////////////////////////////////////////////////////////////////////////
int cPolicy(Connection *conn, char *param[], u_char no_flag);
int cShowPolicy(Connection *conn);

/////////////////////////////////////////////////////////////////////////////////////
typedef struct pstat {
	unsigned long long in;
	unsigned long long out;
	time_t from;
	} pstat;

/////////////////////////////////////////////////////////////////////////////////////
typedef u_char policy_flag;

#define POLICY_FLAG_NONE	0x00
#define POLICY_FLAG_BRK		0x01
#define POLICY_FLAG_INV		0x02

typedef struct policy_data {
	Policy *policy;
	time_t timestamp; 
	time_t to; // last time policy_data matched, thats why we don't need time_t to in pstat
	unsigned long long check;
	unsigned long long match;
	pstat flow;
	pstat h,d,w,m;
	policy_data *next;
	policy_flag flags;  //  POLICY_FLAG_*
} policy_data;

/////////////////////////////////////////////////////////////////////////////////////
class PdList {
	public:
		policy_data *root;
		policy_data *last;
		pthread_rwlock_t *rwlock;
		u_char num_policies;

		PdList();
		~PdList();
		policy_data *Add(Policy *p, u_char flags=0, u_char place=0);
		u_char Delete(Policy *p);
		void List(Connection *conn);
		void ListForCfg(FILE *f);
		void SetForUnit(policy_type pt, NetUnit *u);
		policy_data *Get(Policy *p);
		time_t LastUsed();
		void ClearLastUsed();
		u_char IsNetCheckBroken(NetUnit *u);
};

/////////////////////////////////////////////////////////////////////////////////////
void PolicyDataUpdate(match mf, policy_data *p, IPFlowStat *flow);
void PolicyAdd(NetUnit *u, u_char *i, policy_type p, Connection *conn, char *param[], u_char no_flag);
void sPConstructReadMessages(oid netunit, policy_data *pdata);
/////////////////////////////////////////////////////////////////////////////////////
typedef u_char SysPolicy;

#define SP_NONE			0x00
#define SP_DENY			0x01
#define SP_DENY_MONEY		0x02
#define SP_DENY_BLOCK		0x04
#define SP_DENY_QUOTA		0x08
#define SP_DENY_AUTH		0x10
#define SP_DENY_LOGIN		0x20

void SetSysPolicy(char *p, NetUnit *u, Connection *conn);
void PrintSysPolicy(FILE *f, SysPolicy p, oid perm);
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
