/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: services.h,v 1.24 2005/01/17 13:13:22 jura Exp $ */

#define SERVICE_TYPES_NUM	20

enum service_type { SERVICE_UNDEF=0, SERVICE_STORAGE=1, SERVICE_PROCESSOR=2, SERVICE_DATASOURCE=3, SERVICE_MONITOR=4, SERVICE_HTML=5, SERVICE_QUOTA=6, SERVICE_QUOTACTL=7, SERVICE_LOGIN=8, SERVICE_ALERTER=9, SERVICE_SCHEDULER=10, SERVICE_BILLING=11, SERVICE_WEBLOGIN=12, SERVICE_PVMGATE=13, SERVICE_SERVER=14, SERVICE_MAIN=15, SERVICE_DS_IPQ=16, SERVICE_DS_IPFW=17, SERVICE_DS_LIBPCAP=18, SERVICE_DS_ULOG=19 };

//////////////////////////////////////////////////////////////////////////
//cancellation points stuff
#define SET_CANCEL()		pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, NULL);pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);
#define TEST_CANCEL(arg)	{ int cancel_state;pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, &cancel_state);arg;pthread_setcancelstate(cancel_state, NULL); }
//////////////////////////////////////////////////////////////////////////
#define SERVICE_RUN	1
//////////////////////////////////////////////////////////////////////////
class Service {
	public:
		char *getName();
		Service(service_type type, u_char i=0);
		~Service();
		void Shutdown();
		void setTID();
		Service *next;
		void *cfg;
		pthread_t t_id;
		service_type type;
		u_char instance;
		u_char flags;
		u_char Wakeup();
		u_char Sleep(unsigned sec=0);
		void setSleep() { sleep_state=1; }
		int isSleep() { return sleep_state; }
		void Start();
		void ProcessCfg(char *param[], Connection *conn, u_char no_flag);
		void listCfg(FILE *f, int nopasswords=0);
		void listInfo(FILE *f);
		void showPerf(FILE *f, u_char isheader=0);

	private:
		pthread_mutex_t *sleep_mutex;
		pthread_cond_t *sleep_cond;
		u_char sleep_state;
		};

//////////////////////////////////////////////////////////////////////////
class ServicesList {
	private:
		Service *root;
		unsigned num_services;
		pthread_rwlock_t *rwlock;
		unsigned long tries_lock;
                unsigned long tries_lock_failed;
		char *unknown_service;
	public:
		ServicesList();
		~ServicesList();
		void Insert(Service *s);
		void Delete(Service *s);
		Service *getService(service_type type, u_char i);
		Service *getServiceNextByType(service_type type, Service *s=NULL);
		unsigned getServices() { return num_services; }
		Service *getServiceByThr(pthread_t t);
		void StartAll(Service *except=NULL);
		void ShutdownAll(Service *except);
		void listCfg(FILE *f, int nopasswords=0);
		void listInfo(FILE *f);
		void showPerf(FILE *f, u_char isheader=0);
		};

//////////////////////////////////////////////////////////////////////////
void cService(Connection *conn, char *param[], u_char no_flag);
