/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	(c) 1998-2002 Anton Vinokurov <anton@netams.com>
***	(c) 2002-2005 NeTAMS Development Team
***	All rights reserved. See 'Copying' file included in distribution
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: users.h,v 1.10 2005/01/17 13:13:22 jura Exp $ */

// user modes definition
enum user_mode { USER_HUMAN, USER_DATASOURCE, USER_STORAGE };

//////////////////////////////////////////////////////////////////////////
class User {
	public:
		char *real_name;
		char *name;
		char *email;
		char *password;
		char *crypted;
		u_char permissions;
		u_char hidden;
		oid id;
		User(char *name, u_char hidden=0);
		~User();
		User *next;
		user_mode mode;

		void setName(char *s);
		void setRealName(char *s);
		void setEmail(char *s);
		void setPassword(char *s);
		void setCrypted(char *s);
		void setPermissions(char *s);
		u_char getPermissions();
		};

//////////////////////////////////////////////////////////////////////////
class UsersList {
	private:
		User *root;
		User *last;
		unsigned num_users;
		pthread_mutex_t *lock;
	public:
		u_char changed_pw;
		u_char changed_user;
		UsersList();
		~UsersList();
		void Insert(User *s);
		void Delete(char *name);
		void Delete(User *s);
		User *getUser(char *name);
		User *getUserById(oid id);
		void listUsers(Connection *conn);
		void listUsersCfg(FILE *f, int nopasswords=0);
		void listUsersHtml(Connection *conn);
		void listPasswordsHtml(Connection *conn);
		unsigned getUsers() { return num_users; }
		};

//////////////////////////////////////////////////////////////////////////
int cUser(Connection *conn, char *param[], u_char no_flag);
int cShowUsers(Connection *conn);
