#!/usr/bin/perl

# NetBilling - gettraf
#
# (C) 2003, Michael Klimenko
#
# $Revision: 2.4 $
#

use DBI;
use Fcntl ':flock'; # import LOCK_* constants

#    procs.pl
require "/home/httpd/netbill/cgi-bin/admin/procs.pl";

# (1)/(0)  
my $DEBUG = 0;

print "Netbilling\ngettraf\n";


##  LOCK-
open(LCKF, ">$gettraflock") || die "Can't open lockfile $gettraflock\n$!\n";
# make exclusive non-blocking lock on lockfile
flock(LCKF, LOCK_NB|LOCK_EX) || die "$gettraflock ,   !\n";

##  PID nacctd
open (PID, $nacctdpidpath) or print "net-acct   ($nacctdpidpath  )\n";
while (<PID>) {
    chomp;
    $nacctdpid = $_ if /^\d+$/;
}
close(PID);
if ($nacctdpid == 0) { print "net-acct   ( PID)\n"; }
	

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:database=$dbname;host=$dbhost",
                           $dbuser, $dbpass,{'RaiseError' => 1});
			   
# Exit if no connection
if ($dbh == undef) { die "Error connecting to database"; }

##    IP
our @clients_lst = (); # global
our %client_id_from_ip; #        IP
our %client_discount; # 
our %client_macs; #  MAC-  IP-
my $sth;
eval {$sth = $dbh->prepare("SELECT ID,IP,MAC,Discount FROM Client");$sth->execute();};
if ($@) { log_msg("    : $@"); die "    : $@"; };
while (my $ref=$sth->fetchrow_hashref()) {
    push @clients_lst,$ref->{'IP'};
    $client_id_from_ip{$ref->{'IP'}} = $ref->{'ID'};
    $client_discount{$ref->{'IP'}} = $ref->{'Discount'};
    $client_macs{$ref->{'IP'}} = $ref->{'MAC'};
}
$sth->finish(); undef $sth;
## debug
if ($DEBUG) { 
    print "------------ Clients data from DB\n";
    print "\$#clients_lst = $#clients_lst\n";
    print "\%clients: " . join(" ", (keys %client_id_from_ip)) . "\n";
    print "\%client IDs: " . join(" ", (values %client_id_from_ip)) . "\n";
    print "\%client discounts: " . join(" ", (values %client_discount)) . "\n";
    print "\%client MACs: " . join(" ", (values %client_macs)) . "\n";
}

##        
my %zones; #    : $zones{}{PriceIn}, $zones{}{PriceOut}, $zones{}{A} -  -
my @zoneids; #   ,     OrderNum
eval { $sth = $dbh->prepare("SELECT ID,PriceIn,PriceOut FROM Zone ORDER BY OrderNum") };
$sth->execute();
# debug
if ($DEBUG) { print "------------ Loading zones:\n"; }
while (my $ref = $sth->fetchrow_hashref()) {
    my $zoneid = $ref->{'ID'};
    push @zoneids, $zoneid;
    $zones{$zoneid}{PriceIn}=$ref->{'PriceIn'}+0;
    $zones{$zoneid}{PriceOut}=$ref->{'PriceOut'}+0;
    #     
    my $i = 0;
    my $sth1 = $dbh->prepare("SELECT ID,IP,Mask,Neg FROM Address WHERE Zone_ID=$ref->{'ID'} ORDER BY Neg DESC");
    $sth1->execute();
    while (my $ref1=$sth1->fetchrow_hashref()) {
	$zones{$zoneid}{A}[$i]{IP} = $ref1->{'IP'}+0;
	$zones{$zoneid}{A}[$i]{Mask} = $ref1->{'Mask'}+0;
	$zones{$zoneid}{A}[$i]{Neg} = $ref1->{'Neg'};
	if ($DEBUG) { print "\t$zoneid:\t".($ref1->{'Neg'}?"!":"")." ".ipnum2str($ref1->{'IP'})."/".ipnum2str($ref1->{'Mask'}).": "; }
	#     
	my $sth2 = $dbh->prepare("SELECT PortNum FROM Port WHERE Address_ID=$ref1->{'ID'}");
	$sth2->execute();
	@{$zones{$zoneid}{A}[$i]{Ports}} = ();
	while (my $ref2=$sth2->fetchrow_hashref()) {
	    if ($DEBUG) { print "$ref2->{'PortNum'} "; }
	    push @{$zones{$zoneid}{A}[$i]{Ports}}, $ref2->{'PortNum'};
	}
	$sth2->finish();
	$i++;
	if ($DEBUG) { print "(".(($#{$zones{$zoneid}{A}[$i-1]{Ports}})+1) . " ports)\n"; }
    }
    $sth1->finish();
}
$sth->finish(); undef $sth;


##    
my %total_inb; my %total_outb;
#      nacctd  
if ($nacctdpid) {
    print "Prevent nacctd from writing to log\n";
    kill SIGTSTP, $nacctdpid;
}
print "Reading nacctd log\n";
open (F, $nacctdout) or print "Can't open $nacctdout !\n";
while (<F>) {
    chomp;
    if (/^\d+\s+\d+\s+(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s+(\d+)\s+(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\s+(\d+)\s+(\d+)/) {
	my $srcip = $1; my $srcport = $2; my $dstip = $3; my $dstport = $4; my $size = $5;
	# debug
	if ($DEBUG) { print ">> read line: $srcip:$srcport > $dstip:$dstport, $size bytes\n"; }
	#      ,  ,    
	if (is_client_ip($srcip)) { #    
    	    if ($DEBUG) { print "         It is outbound\n"; }
	    #      ,  
	    foreach my $zid (@zoneids) {
		if (ip_in_zone($dstip, $dstport, $zid)) {
		    #    ,     
		    $total_outb{$srcip}{$zid} += $size;
		    last;
		}
	    }
	}
	if (is_client_ip($dstip)) { #    
    	    if ($DEBUG) { print "         It is inbound\n"; }
	    #      ,  
	    foreach my $zid (@zoneids) {
		if (ip_in_zone($srcip,$srcport,$zid)) {
		    #    ,     
		    $total_inb{$dstip}{$zid} += $size;
		    last;
		}
	    }
	}
    }
}
close(F);

#        ( )
if ($keepnacctdout) {
    my $null;
    (my $sec,my $min,my $hour,my $mday,my $month,my $year,$null,$null,$null) = localtime(time);
    my $newnacctdout = $keepnacctdoutdir . '/' . sprintf("%4d%02d%02d.log",$year+1900,$month+1,$mday);
    print "cat $nacctdout >> $newnacctdout\n";
    `cat $nacctdout >> $newnacctdout`;
}

#    
unlink ($nacctdout);

#    nacctd  
if ($nacctdpid) {
    print "Allow nacctd to write to log\n";
    kill SIGCONT, $nacctdpid;
}


print "Put traffic and its price into database\n";
##         
##       
my @deactivate_lst = (); #  ,   
foreach $client (keys %total_inb) {
    my $client_costin = 0; #      (   )
    foreach $zid (keys %{$total_inb{$client}}) {
	#      (  )
	eval {
	    my $sth = $dbh->prepare("SELECT Client_ID FROM Traffic WHERE Client_ID=$client_id_from_ip{$client} AND Zone_ID=$zid AND Year=YEAR(NOW()) AND Month=MONTH(NOW())");
	    $sth->execute();
	    if ($sth->rows <= 0) {$dbh->do("INSERT INTO Traffic (Client_ID,Zone_ID,Year,Month) VALUES ($client_id_from_ip{$client},$zid,YEAR(NOW()),MONTH(NOW()))") };
	    $sth->finish();
	};
	#     
	my $costin = $total_inb{$client}{$zid} / $bytesinkb / $bytesinkb * $zones{$zid}{PriceIn};
	$costin *= 1-$client_discount{$client}/100; #  
	$client_costin += $costin;
	#    
	eval { $dbh->do("UPDATE Traffic SET Inbound=Inbound+$total_inb{$client}{$zid},CostIn=CostIn+$costin  WHERE Client_ID=$client_id_from_ip{$client} AND Zone_ID=$zid AND Month=MONTH(NOW()) AND Year=YEAR(NOW())") };
	if ($@) { log_msg("      : $@"); die "      : $@"; }
    }
    #     ,     >0
    if ( $client_costin > 0 ) {
        eval { $sth = $dbh->prepare("SELECT Credit,CanCredit FROM Client WHERE ID=$client_id_from_ip{$client}"); };
	$sth->execute();
	my $ref2=$sth->fetchrow_hashref();
        my $newcredit = $ref2->{'Credit'} - $client_costin;
        my $cancredit = $ref2->{'CanCredit'};
	$sth->finish();
        my $deact_sql = ''; #   ,   . SQL-
	if ($newcredit < 0 && !$cancredit)
	    {$deact_sql = ', Active=0 '; push @deactivate_lst,$client; } # 
        eval { $dbh->do("UPDATE Client SET Credit=$newcredit $deact_sql WHERE ID=$client_id_from_ip{$client}") };
	if ($@) { log_msg("          : $@"); }
    }
}
foreach $client (keys %total_outb) {
    my $client_costout = 0; #      (   )
    foreach $zid (keys %{$total_outb{$client}}) {
	#      (  )
	eval {
	    my $sth = $dbh->prepare("SELECT Client_ID FROM Traffic WHERE Client_ID=$client_id_from_ip{$client} AND Zone_ID=$zid AND Year=YEAR(NOW()) AND Month=MONTH(NOW())");
	    $sth->execute();
	    if ($sth->rows <= 0) {$dbh->do("INSERT INTO Traffic (Client_ID,Zone_ID,Year,Month) VALUES ($client_id_from_ip{$client},$zid,YEAR(NOW()),MONTH(NOW()))") };
	    $sth->finish();
	};
	#     
	my $costout = $total_outb{$client}{$zid} / $bytesinkb / $bytesinkb * $zones{$zid}{PriceOut};
	$costout *= 1-$client_discount{$client}/100; #  
	$client_costout += $costout;
	#    
	eval { $dbh->do("UPDATE Traffic SET Outbound=Outbound+$total_outb{$client}{$zid}, CostOut=CostOut+$costout  WHERE Client_ID=$client_id_from_ip{$client} AND Zone_ID=$zid AND Month=MONTH(NOW()) AND Year=YEAR(NOW())") };
	if ($@) { log_msg("      : $@"); die "      : $@"; }
    }
    #     ,     >0
    if ( $client_costout > 0 ) {
        eval { $sth = $dbh->prepare("SELECT Credit,CanCredit FROM Client WHERE ID=$client_id_from_ip{$client}"); };
	$sth->execute();
        my $ref2 = $sth->fetchrow_hashref();
	my $newcredit = $ref2->{'Credit'} - $client_costout;
        my $cancredit = $ref2->{'CanCredit'};
	$sth->finish();
        my $deact_sql = ''; #   ,   .  SQL-
	if ($newcredit < 0 && !$cancredit)
	    {$deact_sql = ', Active=0 '; push @deactivate_lst,$client;} # 
        eval { $dbh->do("UPDATE Client SET Credit=$newcredit $deact_sql WHERE ID=$client_id_from_ip{$client}") };
	if ($@) { log_msg("          : $@"); }
    }
}


print "Check, if some clients are to be deactivated\n";
##  
#       
my @deactive_lst = sort @deactivate_lst;
my @dl = ();
#  ,    
$#deactive_lst++; #    ( !)
for (my $i=0; $i<=$#deactive_lst; $i++) {
    if ($deactive_lst[$i] ne $deactive_lst[$i+1])  {push @dl,$deactive_lst[$i];}
}
foreach $cip (@dl) {
    #      
    log_user_event($dbh, $client_id_from_ip{$cip}, "  -  ");
    #  
    eval {
        $ENV{'PATH'} = '/bin:/usr/bin'; # make tainted
        delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};
        my $cmd = "$spath_deactivate $cip $client_macs{$cip}";
        $cmd =~ /^(.+)$/;
	print "  Deactivating $cip: $cmd\n";
	log_msg("Exec $1");
	system($1);
    };print $@;
}

$dbh->disconnect();

print "Done!\n\n";

##  LOCK-
flock(LCKF, LOCK_UN);

exit;

##################################################			   

# ,   IP- 
sub is_client_ip($)
{
    my $ip = shift @_;
    if ($DEBUG) { print "--- CALL is_client_ip($ip),\t\$#clients_lst = $#clients_lst\n"; }
    if ($#clients_lst < 0) {return 0;} #  !
    foreach $i (@clients_lst) {
	if ($i eq $ip) {return 1;}
    }
    if ($DEBUG) { print "         Client $ip not found in \@clients_lst\n"; }
    return 0;
}

#    ,   -- %zones
sub ip_in_zone($$$)
{
    (my $str_ip, my $port, my $zoneid) = @_;
    #    
    my $ip = ipstr2num($str_ip)+0;
    #  ,      
    my $res = 0;
    # debug
    if ($DEBUG) { print "--- CALL ip_in_zone($str_ip, $port, $zoneid) -> "; }
    #     
    for ($i=0; $i<=$#{$zones{$zoneid}{A}}; $i++) {
	my $adr_hash = \%{$zones{$zoneid}{A}[$i]};
        my $a_ip = $$adr_hash{'IP'}; my $a_msk = $$adr_hash{'Mask'}; my $a_neg = $$adr_hash{'Neg'}; my $a_ports_ref = \@{$$adr_hash{'Ports'}};
        #     
        if ( (($a_ip & $a_msk) == ($ip & $a_msk)) && #  
              (is_exist($a_ports_ref, $port)) )     #   
	{
	    if ($a_neg) { #     
		$res = 0; #      
	    } else {
		$res = 1;
	    }
	}
    }
    # debug
    if ($DEBUG) { print "IP is " . ($res ? "" : "not ") . "in zone $zoneid\n"; }
    
    return $res;									  												      
}

#      (  )
sub is_exist($$)
{
    (my $arrayref, my $elem) = @_;
    #   , ,     
    if ($#{@$arrayref} == -1) { return 1; }
    foreach $e (@$arrayref) {
	if ($e eq $elem) { return 1; }
    }
    return 0;
}
