#!/usr/bin/perl

#
# NetBilling - clients
#
# (C) 2003, Michael Klimenko
#
# $Revision: 2.3 $
#

use DBI;
use CGI;

require "./procs.pl";

$scriptpath=$spath_clients;

html_start($lang{CL_TITLE});
print_navmenu();


my $co = new CGI;
my $show_client = 0; #     

# Connect to the database.
my $dbh = DBI->connect("DBI:mysql:database=$dbname;host=$dbhost",
                           $dbuser, $dbpass,{'RaiseError' => 1});
			   
if ($dbh == undef) { print "Error connecting to database"; exit(-1); }
			   
print "<DIV align=center><h1>$orgtitle</h1><h2>$lang{CL_HEAD}</h2></DIV><br>";

if ($co->param('Action') eq 'edit') {
    # Edit client form
    print "\n<DIV align=center><h3>$lang{CL_EDIT_HEAD}</h3></DIV>";
    my $sth;
    eval { $sth = $dbh->prepare("SELECT * FROM Client WHERE ID=".$co->param('ID')); $sth->execute();};
    if ($@) { print "<FONT color=red>! $@</FONT>"; }
    my $ref = $sth->fetchrow_hashref();
    
    print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\">";
    print "<INPUT TYPE=hidden NAME=Action VALUE='editclient'><INPUT TYPE=hidden NAME=ID VALUE=".$co->param('ID').">";
    print "<TABLE align=center>";
    print "<TR><TD>$lang{CL_FIELD_IP}:</TD><TD><INPUT TYPE=text MAXLENGTH=15 NAME=IP VALUE='".$ref->{'IP'}."'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_MAC}:</TD><TD><INPUT TYPE=text MAXLENGTH=17 NAME=MAC VALUE='".$ref->{'MAC'}."'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_CREDIT}:</TD><TD>".$ref->{'Credit'}." $currencysign</TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_DISCOUNT}:</TD><TD><INPUT TYPE=text MAXLENGTH=3 NAME=Discount VALUE='".$ref->{'Discount'}."'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_MONTHFEE}:</TD><TD><INPUT TYPE=text MAXLENGTH=8 NAME=MonthFee VALUE='".$ref->{'MonthFee'}."'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_LANG}:</TD><TD><INPUT TYPE=text MAXLENGTH=15 NAME=Language VALUE='".$ref->{'Language'}."'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_ACTIVE}:</TD><TD><INPUT TYPE=checkbox NAME=Active "; if ($ref->{'Active'} eq '1') {print "CHECKED";} print "></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_CANCREDIT}:</TD><TD><INPUT TYPE=checkbox NAME=CanCredit "; if ($ref->{'CanCredit'} eq '1') {print "CHECKED";} print "></TD></TR>";
    print "<TR><TD colspan=2><INPUT TYPE=submit VALUE='$lang{BTN_EDIT}'></TD></TR>";
    print "</TABLE></FORM>";
    print "<DIV align=center>[&nbsp;<A href=$scriptpath\?Action=show\&ID='$ref->{'ID'}'>$lang{LNK_BACK}</A>&nbsp;]</DIV>";

    $sth->finish();
    $dbh->disconnect();
    exit;
} elsif ( ($co->param('Action') eq 'add') && (length($co->param('IP'))>=7) ) {
    # Add client
    my $active = 0; my $cancredit = 0;
    if (defined $co->param('Active')) { $active=1; };
    if (defined $co->param('CanCredit')) { $cancredit=1; }
    add_client($dbh, $co->param('IP'), $co->param('MAC'), $co->param('Credit'), $co->param('Discount'), $co->param('MonthFee'), $active, $cancredit, $co->param('Language'));
} elsif ( ($co->param('Action') eq 'editclient') && (length($co->param('IP'))>=7) ) {
    # Edit client
    my $active = 0; my $cancredit = 0;
    if (defined $co->param('Active')) { $active=1; }
    if (defined $co->param('CanCredit')) { $cancredit=1; }
    edit_client($dbh, $co->param('ID'), $co->param('IP'), $co->param('MAC'), undef, $co->param('Discount'), $co->param('MonthFee'), $active, $cancredit, $co->param('Language'));
    $show_client = 1;
} elsif ( ($co->param('Action') eq 'del') && (defined $co->param('confirm')) ) {
    # Delete client
    del_client($dbh, $co->param('ID'));
} elsif ( ($co->param('Action') eq 'useradd') && (defined $co->param('FIO')) && (defined $co->param('ID')) ) {
    # Add user
    my $senddayrep = 0; my $sendmonthrep = 0;
    if (defined $co->param('SendDayReport')) { $senddayrep=1; }
    if (defined $co->param('SendMonthReport')) { $sendmonthrep=1; }
    add_user($dbh, $co->param('ID'), $co->param('FIO'), $co->param('Address'), $co->param('Phone'), $co->param('pass'), $co->param('Email'), $senddayrep, $sendmonthrep);
    $show_client = 1;
} elsif ( ($co->param('Action') eq 'userdel') && (defined $co->param('ID')) ) {
    # Del user
    del_user($dbh, $co->param('ID'), $co->param('UID'));
    $show_client = 1;
} elsif ( ($co->param('Action') eq 'useredit') && (defined $co->param('ID')) ) {
    # Edit user
    my $senddayrep = 0; my $sendmonthrep = 0;
    if (defined $co->param('SendDayReport')) { $senddayrep=1; }
    if (defined $co->param('SendMonthReport')) { $sendmonthrep=1; }
    edit_user($dbh, $co->param('ID'), $co->param('UID'), $co->param('pass'), $co->param('FIO'), $co->param('Address'), $co->param('Phone'), $co->param('Email'), $senddayrep, $sendmonthrep );
    $show_client = 1;
}
if ( (($co->param('Action') eq 'show') && (defined $co->param('ID'))) || $show_client ) {
    # Show client
    get_client($co->param('ID'));
}
if ($co->param('Action') eq 'dlist') {
    # Show detailed client list
    my $order; if (defined $co->param('Order')) {$order = $co->param('Order');}else{$order = 'IP';}
    get_detailedlist($dbh,$order);
}
    # Client list
    get_clientlist($dbh);
    # Print Query Form
    print "<DIV align=center><h3>$lang{CL_ADD_HEAD}</h3></DIV>\n";
    print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\"><INPUT TYPE=hidden NAME=Action VALUE='add'>\n";
    print "<TABLE align=center>";
    print "<TR><TD>$lang{CL_FIELD_IP}:</TD><TD><INPUT TYPE=text MAXLENGTH=15 NAME=IP VALUE='0.0.0.0'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_MAC}:</TD><TD><INPUT TYPE=text MAXLENGTH=17 NAME=MAC VALUE='00:00:00:00:00:00'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_CREDIT}:</TD><TD><INPUT TYPE=text MAXLENGTH=8 NAME=Credit VALUE='0'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_DISCOUNT}:</TD><TD><INPUT TYPE=text MAXLENGTH=3 NAME=Discount VALUE='0'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_MONTHFEE}:</TD><TD><INPUT TYPE=text MAXLENGTH=8 NAME=MonthFee VALUE='$default_fee'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_LANG}:</TD><TD><INPUT TYPE=text MAXLENGTH=15 NAME=Language VALUE='$default_language'></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_ACTIVE}:</TD><TD><INPUT TYPE=checkbox NAME=Active></TD></TR>";
    print "<TR><TD>$lang{CL_FIELD_CANCREDIT}:</TD><TD><INPUT TYPE=checkbox NAME=CanCredit></TD></TR>";
    print "<TR><TD colspan=2><INPUT TYPE=submit VALUE='$lang{BTN_ADD}'></TD></TR>";
    print "</TABLE></FORM>";


$dbh->disconnect();

html_end();
exit;

####################

#    
sub get_client($)
{
    my $cid = shift @_;
    my $sth;
    eval { $sth = $dbh->prepare("SELECT * FROM Client WHERE ID=$cid");$sth->execute();};
    if ($@) { print "<FONT color=red>! $@</FONT>"; }
    my $ref = $sth->fetchrow_hashref();
    print "<TABLE align=center border=1 cellspacing=0 class=btbl style='BACKGROUND-COLOR:#ffffff;'><TR><TD class=btbl>";
    print "<TABLE align=center>";
    print "<TR style='background-color:#4fafaf'><TD style='font-size:16pt'>$ref->{'IP'}</TD>";
    print "<TD><TABLE width=100% height=100%><TR valign=middle><TD><FORM ACTION=\"$scriptpath\" METHOD=\"POST\">\n";
    print "<INPUT TYPE=hidden NAME=ID VALUE=$ref->{'ID'}>";
    print "<INPUT TYPE=hidden NAME=Action VALUE='edit'>";
    print "<input type=\"submit\" value=\"$lang{BTN_EDIT}\"></FORM></TD><TD>";
    print "<FORM ACTION=\"$scriptpath\" METHOD=\"POST\">\n";
    print "<INPUT TYPE=hidden NAME=ID VALUE=$ref->{'ID'}>";
    print "<INPUT TYPE=hidden NAME=Action VALUE='del'>";
    print "<input type=\"submit\" value=\"$lang{BTN_DEL}\"><INPUT TYPE=checkbox NAME=confirm TITLE='$lang{BTN_DEL_CONFIRM}'></FORM></TD>";
    print "<TD><FORM ACTION=\"$spath_income\" METHOD=\"POST\"><INPUT TYPE=hidden NAME=Action VALUE=addmoney>";
    print "<INPUT TYPE=hidden NAME=ID VALUE=$ref->{'ID'}>";
    print "<INPUT TYPE=submit VALUE='$lang{CL_ADD_MONEY}'>";
    print "<INPUT TYPE=text NAME=Sum VALUE='0.00' SIZE=5>";
    print "</FORM></TD></TR></TABLE>";
    print "</TD></TR>\n";
    
    my $sth1;
    eval { $sth1 = $dbh->prepare("SELECT * FROM User WHERE Client_ID=$cid");$sth1->execute();};
    if ($@) { print "<FONT color=red>! $@</FONT>"; }
    print "<TR style='background-color:#efef9f'><TD>$lang{CL_FIELD_USERS}:</TD><TD>";
    print "<TABLE border=1 cellspacing=0 cellpadding=2 width=100%>";
    print "<TR><TH>$lang{USR_FIELD_UID}</TH><TH>$lang{USR_FIELD_FIO}</TH><TH>$lang{USR_FIELD_ADDRESS}</TH><TH>$lang{USR_FIELD_PHONE}</TH><TH>$lang{USR_FIELD_PASSWD}</TH><TH>$lang{USR_FIELD_EMAIL}</TH><TH TITLE=\"$lang{USR_FIELD_SENDDAYREPORT}\">$lang{USR_FIELD_SENDDAYREPORT_SHORT}</TH><TH TITLE=\"$lang{USR_FIELD_SENDMONTHREPORT}\">$lang{USR_FIELD_SENDMONTHREPORT_SHORT}</TH><TH>&nbsp;</TH></TR>";
    while (my $ref1 = $sth1->fetchrow_hashref()) {
	print "<FORM ACTION=\"$scriptpath\" METHOD=POST><INPUT TYPE=hidden NAME=Action VALUE=useredit><TR>";
	print "<TD>$ref1->{'ID'}<INPUT TYPE=hidden NAME=UID VALUE=$ref1->{'ID'}></TD>";
	print "<TD><INPUT NAME=FIO SIZE=13 MAXLENGTH=50 VALUE='$ref1->{'FIO'}'></TD>";
	print "<TD><INPUT NAME=Address SIZE=20 MAXLENGTH=80 VALUE='$ref1->{'Address'}'></TD>";
	print "<TD><INPUT NAME=Phone SIZE=6 MAXLENGTH=20 VALUE='$ref1->{'Phone'}'></TD>";
	print "<TD><INPUT NAME=pass SIZE=6 MAXLENGTH=20 VALUE='$ref1->{'Password'}'></TD>";
	print "<TD><INPUT NAME=Email SIZE=10 MAXLENGTH=40 VALUE='$ref1->{'Email'}'></TD>";
	print "<TD><INPUT TYPE=checkbox NAME=SendDayReport".(($ref1->{'SendDayReport'}==1)?" CHECKED":"")."></TD>";
	print "<TD><INPUT TYPE=checkbox NAME=SendMonthReport".(($ref1->{'SendMonthReport'}==1)?" CHECKED":"")."></TD>";
	print "<TD width=1 align=center>";
	print "<INPUT TYPE=hidden NAME=ID VALUE=$cid><INPUT TYPE=submit VALUE='$lang{BTN_EDIT}'></FORM>";
	print "<FORM ACTION=\"$scriptpath\" METHOD=POST><INPUT TYPE=hidden NAME=Action VALUE=userdel><INPUT TYPE=hidden NAME=ID VALUE=$cid><INPUT TYPE=hidden NAME=UID VALUE=$ref1->{'ID'}><INPUT TYPE=submit VALUE='$lang{BTN_DEL}'></FORM></TD>";
	print "</TR>";
	
    }
    print "<FORM ACTION=\"$scriptpath\" METHOD=POST><INPUT TYPE=hidden NAME=Action VALUE=useradd><INPUT TYPE=hidden NAME=ID VALUE=$cid>";
    print "<TR><TD>&nbsp;</TD><TD><INPUT TYPE=text NAME=FIO MAXLENGTH=50 SIZE=13></TD>";
    print "<TD><INPUT TYPE=text NAME=Address MAXLENGTH=80 SIZE=20></TD>";
    print "<TD><INPUT TYPE=text NAME=Phone MAXLENGTH=20 SIZE=6></TD>";
    print "<TD><INPUT TYPE=text NAME=pass MAXLENGTH=20 SIZE=6></TD>";
    print "<TD><INPUT TYPE=text NAME=Email MAXLENGTH=40 SIZE=10></TD>";
    print "<TD><INPUT TYPE=checkbox NAME=SendDayReport></TD>";
    print "<TD><INPUT TYPE=checkbox NAME=SendMonthReport></TD>";
    print "<TD><INPUT TYPE=submit VALUE='$lang{BTN_ADD}'></TD></TR></FORM>";
    print "</TABLE>";
    print "</TD></TR>";
    $sth1->finish();
    print "<TR style='background-color:#efef9f'><TD>$lang{CL_FIELD_MAC}:</TD><TD>$ref->{'MAC'}</TD></TR>";
    print "<TR style='background-color:#efef9f'><TD>$lang{CL_FIELD_CREDIT}:</TD><TD>$ref->{'Credit'}&nbsp;$currencysign</TD></TR>";
    print "<TR style='background-color:#efef9f'><TD>$lang{CL_FIELD_DISCOUNT}:</TD><TD>$ref->{'Discount'} \%</TD></TR>";
    print "<TR style='background-color:#efef9f'><TD>$lang{CL_FIELD_MONTHFEE}:</TD><TD>$ref->{'MonthFee'}&nbsp;$currencysign ".sprintf($lang{CL_MONTHFEE_DAY_WARNING},$monthfee_day)."</TD></TR>";
    print "<TR style='background-color:#efef9f'><TD>$lang{CL_FIELD_LANG}:</TD><TD>$ref->{'Language'}</TD></TR>";
    print "<TR style='background-color:#efef9f'><TD>$lang{CL_FIELD_ACTIVE}:</TD><TD>";
    if ($ref->{'Active'} eq '1') {print "$lang{YES}";} else {print "$lang{NO}";} print "</TD></TR>";
    print "<TR style='background-color:#efef9f'><TD>$lang{CL_FIELD_CANCREDIT}:</TD><TD>";
    if ($ref->{'CanCredit'} eq '1') {print "$lang{YES}";} else {print "$lang{NO}";} print "</TD></TR>";
    print "<TR style='background-color:#efef9f'><TD>$lang{CL_FIELD_TRAFFIC}:</TD><TD align=center>";
    # 
    print "<TABLE border=1 cellspacing=0 cellpadding=2>";
    print "<TR><TH rowspan=2>$lang{CL_FIELD_PERIOD}</TH><TH rowspan=2>$lang{CL_FIELD_ZONE}</TH><TH colspan=2>$lang{CL_FIELD_TRAFFIC}</TH><TH colspan=2>$lang{CL_FIELD_COST}</TH></TR>";
    print "<TR><TH>$lang{CL_FIELD_TRAFFIC_INBOUND}</TH><TH>$lang{CL_FIELD_TRAFFIC_OUTBOUND}</TH><TH>$lang{CL_FIELD_TRAFFIC_INBOUND}</TH><TH>$lang{CL_FIELD_TRAFFIC_OUTBOUND}</TH></TR>";
    my %zonetraf_in; my %zonetraf_out;
    my %zonecost_in; my %zonecost_out;
    my $sth1;
    eval {$sth1 = $dbh->prepare("SELECT T.Inbound inb,T.Outbound outb,T.CostIn cin,T.CostOut cout,T.Year year,T.Month month,Z.Name zname FROM Traffic T, Zone Z WHERE Z.ID=T.Zone_ID AND T.Client_ID=".$ref->{'ID'}." ORDER BY T.Year,T.Month");$sth1->execute();};
    if ($@) { print "<FONT color=red>! $@</FONT>"; }
    my $prevdate; #   
    while (my $ref1 = $sth1->fetchrow_hashref()) {
	#   ,    
	my $date = sprintf "%02d.%d",$ref1->{'month'},$ref1->{'year'};
	if ($date ne $prevdate) {
	    if (defined $prevdate) { print "<TR><TD colspan=6 bgcolor=#afaf40></TD></TR>"; }
	};
        $prevdate=$date;
        print "<TR><TD align=center><b>$date</b></TD><TD>$ref1->{zname}</TD>";
	print "<TD>".(sprintf "%0.3f",$ref1->{inb}/$bytesinkb/$bytesinkb)." $lang{MEGABYTES}</TD>";
	print "<TD>".(sprintf "%0.3f",$ref1->{outb}/$bytesinkb/$bytesinkb)." $lang{MEGABYTES}</TD>";
        print "<TD>$ref1->{'cin'}&nbsp;$currencysign</TD><TD>$ref1->{'cout'}&nbsp;$currencysign</TD></TR>";
	$zonetraf_in{$ref1->{'zname'}} += $ref1->{inb};
	$zonetraf_out{$ref1->{'zname'}} += $ref1->{outb};
	$zonecost_in{$ref1->{'zname'}} += $ref1->{cin};
	$zonecost_out{$ref1->{'zname'}} += $ref1->{cout};
    }
    $sth1->finish();
    print "<TR><TD colspan=6 bgcolor=#ffffff></TD></TR>";
    print "<TR><TD align=center rowspan=".(keys %zonetraf_in)."><b>$lang{CL_FIELD_TRAFFIC_COMMON}</b></TD>";
    foreach $zname (keys %zonetraf_in) {
	print "<TD>$zname</TD>";
	print "<TD>".(sprintf "%0.3f",$zonetraf_in{$zname}/$bytesinkb/$bytesinkb)." $lang{MEGABYTES}</TD>";
	print "<TD>".(sprintf "%0.3f",$zonetraf_out{$zname}/$bytesinkb/$bytesinkb)." $lang{MEGABYTES}</TD>";
	print "<TD>".(sprintf "%.2f",$zonecost_in{$zname})."&nbsp;$currencysign</TD>";
	print "<TD>".(sprintf "%.2f",$zonecost_out{$zname})."&nbsp;$currencysign</TD></TR><TR>";
    }
    print "</TR></TABLE>";
    print "</TD></TR>";
    #
    print "</TABLE></TD></TR></TABLE>";
    print "<DIV align=center><FONT size=-1 face=tahoma,verdana>".sprintf($lang{CL_BYTESINKB_WARNING},$bytesinkb)."</FONT></DIV><hr>\n";
    $sth->finish();
}

#      
sub get_detailedlist($$)
{
    my $dbh = shift;
    my $order = shift;
    my $sth;
    eval{ $sth = $dbh->prepare("SELECT ID,IP,Credit,Discount,MonthFee,Active FROM Client ORDER BY $order"); $sth->execute();};
    if ($@) { print "<FONT color=red>! $@</FONT>"; }
    print "<TABLE border=1 cellspacing=0 align=center class=btbl>";
    print "<TR style='BACKGROUND-COLOR:#4fafaf'>";
    print "<TH class=btbl TITLE='$lang{CL_LIST_FIELD_SORTBY_IP}'><A href=$scriptpath?Action=dlist&Order=IP class=atbl>$lang{CL_LIST_FIELD_IP}</A></TH>";
    print "<TH class=btbl TITLE='$lang{CL_LIST_FIELD_SORTBY_DISCOUNT}'><A href=$scriptpath?Action=dlist&Order=Discount class=atbl>$lang{CL_LIST_FIELD_DISCOUNT}</A></TH>";
    print "<TH class=btbl TITLE='$lang{CL_LIST_FIELD_SORTBY_MONTHFEE}'><A href=$scriptpath?Action=dlist&Order=MonthFee class=atbl>$lang{CL_LIST_FIELD_MONTHFEE}</A></TH>";
    print "<TH class=btbl TITLE='$lang{CL_LIST_FIELD_SORTBY_CREDIT}'><A href=$scriptpath?Action=dlist&Order=Credit class=atbl>$lang{CL_LIST_FIELD_CREDIT}</A></TH></TR>";
    while (my $ref = $sth->fetchrow_hashref()) {
	my $href = "$scriptpath\?Action=show\&ID='$ref->{'ID'}'";
	if ($ref->{'Active'}==1) {
	    print "<TR style='background-color:#efef9f' TITLE='$lang{CL_STATE_ACTIVE}'>";
	    print "<TD class=btbl><B><A href=$href class=atbl>$ref->{'IP'}</B></A></TD>";
	} else {
	    print "<TR style='background-color:#efef9f' TITLE='$lang{CL_STATE_NOTACTIVE}'>";
	    print "<TD class=btbl><A href=$href class=atbl>$ref->{'IP'}</A></TD>";
	}
	print "<TD class=btbl>$ref->{'Discount'}&nbsp;\%</TD><TD class=btbl>$ref->{'MonthFee'}&nbsp;$currencysign</TD><TD class=btbl>$ref->{'Credit'}&nbsp;$currencysign</TD></TR>";
    }
    print "</TABLE><hr>\n";
    $sth->finish();
}

#    ( IP)  
sub get_clientlist($)
{
    my $dbh = shift;
    my $clientcount = 1;
    my $sth;
    eval{ $sth = $dbh->prepare("SELECT ID,IP,Active FROM Client ORDER BY IP"); $sth->execute();};
    if ($@) { print "<FONT color=red>! $@</FONT>"; }
    print "<TABLE border=1 cellspacing=0 align=center class=btbl>";
    print "<TR style='background-color:#efef9f'>";
    while (my $ref = $sth->fetchrow_hashref()) {
	if ($ref->{'Active'}==1) {
	    print "<TD class=btbl TITLE='$lang{CL_STATE_ACTIVE}'><A href=$scriptpath\?Action=show\&ID='$ref->{'ID'}' class=atbl><B>$ref->{'IP'}</B></A></TD>";
	} else {
	    print "<TD class=btbl TITLE='$lang{CL_STATE_NOTACTIVE}'><A href=$scriptpath\?Action=show\&ID='$ref->{'ID'}' class=atbl>$ref->{'IP'}</A></TD>";
	}
	if ($clientcount % 6 == 0) {print "</TR><TR style='background-color:#efef9f'>";}
	$clientcount++;
    }
    print "</TR></TABLE>";
    print "<DIV align=center>[&nbsp;<A href=$scriptpath?Action=dlist>$lang{CL_DETAILED_LIST_LNK}</A>&nbsp;]</DIV><hr>\n";
    $sth->finish();
}

#########################################

#  
sub add_client($$$$$$$$)
{
    (my $dbh, my $cip, my $cmac, my $ccredit, my $cdiscount, my $cmonthfee, my $cactive, my $ccancredit, my $clanguage) = @_;
    if ($cmonthfee < 0) { $cmonthfee = 0; }
    my $query = "INSERT INTO Client (IP,MAC,Credit,Discount,MonthFee,Active,CanCredit,Language) VALUES ";
    $query .= "('$cip', '$cmac', 0, $cdiscount, $cmonthfee, $cactive, $ccancredit, '$clanguage')";
    eval { $dbh->do($query) };
    if ($@) {print "<FONT color=red>  :<br>$@.<br>    .</FONT><br>"; return;}
    #    MAC    
    $query = "SELECT ID,MAC FROM Client WHERE IP='$cip'";
    my $sth;
    eval {$sth = $dbh->prepare($query);$sth->execute();};
    if ($@) {print "<FONT color=red>:<br> ($@).</FONT><br>"};
    my $ref = $sth->fetchrow_hashref(); my $cid = $ref->{'ID'}; my $cmac = $ref->{'MAC'};
    if ((! defined $cid) || $cid eq '') { print "<FONT color=red>  .</FONT><br>";return; }
    $sth->finish();
    #    
    eval {
	$ENV{'PATH'} = '/bin:/usr/bin'; # make tainted
	delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};
	if ($cactive == 1) {
	    my $cmd = "$spath_activate $cip $cmac";
	    $cmd =~ /^(.+)$/; # for making $cmd untainted
	    log_msg("Exec $1");
	    system($1);
	} else {
	    my $cmd = "$spath_deactivate $cip $cmac";
	    $cmd =~ /^(.+)$/;
	    log_msg("Exec $1");
	    system($1);
	}
    };print $@;
    #       
    undef $sth;
    eval {$sth = $dbh->prepare("SELECT ID FROM Zone");$sth->execute();};
    if ($@) {print "<FONT color=red>:<br> ($@).</FONT><br>"};
    while (my $ref = $sth->fetchrow_hashref()) {
	$query = "INSERT INTO Traffic (Client_ID,Zone_ID,Year,Month) VALUES ($cid, $ref->{'ID'},YEAR(NOW()),MONTH(NOW()))";
	eval { $dbh->do($query); };
	if ($@) {print "<FONT color=red>  :<br>$@.</FONT><br>";}
    }
    $sth->finish();
    #   
    if ($ccredit != 0) {add_money($dbh,$cid,$ccredit);}
}

#  
sub edit_client($$$$$$$$$)
{
    (my $dbh, my $cid, my $cip, my $cmac, my $ccredit, my $cdiscount, my $cmonthfee, my $cactive, my $ccancredit, my $clanguage) = @_;
    my $query = "UPDATE Client SET ";
    $query .= " IP = '$cip', MAC = '$cmac', Discount=$cdiscount, MonthFee=$cmonthfee, Active=$cactive, CanCredit=$ccancredit, Language='$clanguage' ";
    $query .= " WHERE ID=$cid";
    eval { $dbh->do($query) };
    if ($@) {print "<FONT color=red>  :<br>$@.<br>    .</FONT><br>"; return;}
    #    
    eval {
	$ENV{'PATH'} = '/bin:/usr/bin'; # make tainted
	delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};
	if ($cactive == 1) {
	    my $cmd = "$spath_activate $cip $cmac";
	    $cmd =~ /^(.+)$/; # for making $cmd untainted
	    log_msg("Exec $1");
	    system($1);
	} else {
	    my $cmd = "$spath_deactivate $cip $cmac";
	    $cmd =~ /^(.+)$/;
	    log_msg("Exec $1");
	    system($1);
	}
    };print $@;
}

#  
sub del_client($$)
{
    (my $dbh, my $id) = @_;
    #  ,    IP
    my $sth;
    eval { $sth = $dbh->prepare("SELECT IP FROM Client WHERE ID=$id"); $sth->execute(); };
    if ($@) { print "<FONT color=red>   ($@).</FONT><br>"; };
    my $ref=$sth->fetchrow_hashref(); my $cip = $ref->{'IP'};
    eval {
	$ENV{'PATH'} = '/bin:/usr/bin'; # make tainted
	delete @ENV{'IFS', 'CDPATH', 'ENV', 'BASH_ENV'};
	my $cmd = "$spath_deactivate $cip";
	$cmd =~ /^(.+)$/;
	log_msg("Exec $1");
	system($1);
    };print $@;
    $sth->finish();
    eval { $dbh->do("DELETE FROM Client WHERE ID=$id") };
    if ($@) {print "<FONT color=red>   ($@).</FONT><br>"};
    #     
    eval { $dbh->do("DELETE FROM User WHERE Client_ID=$id") };
    if ($@) {print "<FONT color=red>    ($@).</FONT><br>"};    
    #     
    eval { $dbh->do("DELETE FROM Traffic WHERE Client_ID=$id") };
    if ($@) {print "<FONT color=red>    ($@).</FONT><br>"};    
    #    
    eval { $dbh->do("DELETE FROM Income WHERE Client_ID=$id") };
    if ($@) {print "<FONT color=red>    ($@).</FONT><br>"};    
    #    
    eval { $dbh->do("DELETE FROM Outlay WHERE Client_ID=$id") };
    if ($@) {print "<FONT color=red>    ($@).</FONT><br>"};    
}


#    
sub add_user($$$$$$)
{
    (my $dbh, my $cid, my $fio, my $address, my $phone, my $pass, my $email, my $senddayrep, my $sendmonthrep) = @_;
    my $sth;
    eval { $sth = $dbh->prepare("INSERT INTO User VALUES (0,$cid,'$pass','$fio','$address','$phone','$email',$senddayrep, $sendmonthrep)"); $sth->execute(); };
    if ($@) { print "<FONT color=red>     ($@).</FONT><br>"; };
}

#    
sub del_user($$$)
{
    (my $dbh, my $cid, my $uid) = @_;
    my $sth;
    eval { $sth = $dbh->prepare("DELETE FROM User WHERE ID=$uid AND Client_ID=$cid"); $sth->execute(); };
    if ($@) { print "<FONT color=red>     ($@).</FONT><br>"; };
}

#    
sub edit_user($$$$$$$)
{
    (my $dbh, my $cid, my $uid, my $pass, my $fio, my $address, my $phone, my $email, my $senddayrep, my $sendmonthrep) = @_;
    my $query = "UPDATE User SET ";
    $query .= " Client_ID = $cid, Password = '$pass', FIO = '$fio', Address = '$address', Phone = '$phone', ";
    $query .= " Email = '$email', SendDayReport = $senddayrep, SendMonthReport = $sendmonthrep ";
    $query .= " WHERE Client_ID=$cid AND ID=$uid";
    eval { $dbh->do($query) };
    if ($@) {print "<FONT color=red>    :<br>$@.<br>    .</FONT><br>"; return;}
}
